/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Dick Porter <dick@cymru.net>
 *
 */

#include <string.h>
#include <assert.h>

#include "orbit.h"

#include "orbit_poa.h"

#include "orbit_poa_type.h"

PortableServer_ThreadPolicyValue PortableServer_ThreadPolicy__get_value(PortableServer_ThreadPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_PolicyType PortableServer_ThreadPolicy__get_policy_type(PortableServer_ThreadPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_Policy *PortableServer_ThreadPolicy_copy(PortableServer_ThreadPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

void PortableServer_ThreadPolicy_destroy(PortableServer_ThreadPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}


PortableServer_LifespanPolicyValue PortableServer_LifespanPolicy__get_value(PortableServer_LifespanPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_PolicyType PortableServer_LifespanPolicy__get_policy_type(PortableServer_LifespanPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_Policy *PortableServer_LifespanPolicy_copy(PortableServer_LifespanPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

void PortableServer_LifespanPolicy_destroy(PortableServer_LifespanPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}


PortableServer_IdUniquenessPolicyValue PortableServer_IdUniquenessPolicy__get_value(PortableServer_IdUniquenessPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_PolicyType PortableServer_IdUniquenessPolicy__get_policy_type(PortableServer_IdUniquenessPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_Policy *PortableServer_IdUniquenessPolicy_copy(PortableServer_IdUniquenessPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

void PortableServer_IdUniquenessPolicy_destroy(PortableServer_IdUniquenessPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}


PortableServer_IdAssignmentPolicyValue PortableServer_IdAssignmentPolicy__get_value(PortableServer_IdAssignmentPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_PolicyType PortableServer_IdAssignmentPolicy__get_policy_type(PortableServer_IdAssignmentPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_Policy *PortableServer_IdAssignmentPolicy_copy(PortableServer_IdAssignmentPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

void PortableServer_IdAssignmentPolicy_destroy(PortableServer_IdAssignmentPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}


PortableServer_ImplicitActivationPolicyValue PortableServer_ImplicitActivationPolicy__get_value(PortableServer_ImplicitActivationPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_PolicyType PortableServer_ImplicitActivationPolicy__get_policy_type(PortableServer_ImplicitActivationPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_Policy *PortableServer_ImplicitActivationPolicy_copy(PortableServer_ImplicitActivationPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

void PortableServer_ImplicitActivationPolicy_destroy(PortableServer_ImplicitActivationPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}


PortableServer_ServantRetentionPolicyValue PortableServer_ServantRetentionPolicy__get_value(PortableServer_ServantRetentionPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_PolicyType PortableServer_ServantRetentionPolicy__get_policy_type(PortableServer_ServantRetentionPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_Policy *PortableServer_ServantRetentionPolicy_copy(PortableServer_ServantRetentionPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

void PortableServer_ServantRetentionPolicy_destroy(PortableServer_ServantRetentionPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}


PortableServer_RequestProcessingPolicyValue PortableServer_RequestProcessingPolicy__get_value(PortableServer_RequestProcessingPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_PolicyType PortableServer_RequestProcessingPolicy__get_policy_type(PortableServer_RequestProcessingPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

CORBA_Policy *PortableServer_RequestProcessingPolicy_copy(PortableServer_RequestProcessingPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(0);
}

void PortableServer_RequestProcessingPolicy_destroy(PortableServer_RequestProcessingPolicy obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}


void PortableServer_POAManager_activate(PortableServer_POAManager obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}

void PortableServer_POAManager_hold_requests(PortableServer_POAManager obj, CORBA_boolean wait_for_completion, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}

void PortableServer_POAManager_discard_requests(PortableServer_POAManager obj, CORBA_boolean wait_for_completion, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}

void PortableServer_POAManager_deactivate(PortableServer_POAManager obj, CORBA_boolean etherealize_objects, CORBA_boolean wait_for_completion, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}


CORBA_boolean PortableServer_AdapterActivator_unknown_adapter(PortableServer_AdapterActivator obj, PortableServer_POA parent, CORBA_char *name, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(CORBA_FALSE);
}


PortableServer_Servant PortableServer_ServantActivator_incarnate(PortableServer_ServantActivator obj, PortableServer_ObjectId *oid, PortableServer_POA adapter, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

void PortableServer_ServantActivator_etherealize(PortableServer_ServantActivator obj, PortableServer_ObjectId *oid, PortableServer_POA adapter, PortableServer_Servant serv, CORBA_boolean cleanup_in_progress, CORBA_boolean remaining_activations, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}

PortableServer_POA PortableServer_POA_create_POA(PortableServer_POA poa, CORBA_char *adapter_name, PortableServer_POAManager a_POAManager, CORBA_PolicyList* policies, CORBA_Environment *ev)
{
	PortableServer_POA new_poa = NULL;


	if(policies) {
		g_warning("non-default POA policies aren't implemented yet\n");
	}

	new_poa = ORBit_POA_new(adapter_name,a_POAManager,policies,ev);
	/* Need to check environemnt here */
	g_warning("PortableServer_POA_create_POA: Need to check environment here!");
	

	ORBit_POA_add_child(poa,new_poa,ev);

	return(new_poa);
}

PortableServer_POA *PortableServer_POA_find_POA(PortableServer_POA obj, CORBA_char *adapter_name, CORBA_boolean activate_it, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

void PortableServer_POA_destroy(PortableServer_POA obj, CORBA_boolean etherealize_objects, CORBA_boolean wait_for_completion, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}

PortableServer_ThreadPolicy *PortableServer_POA_create_thread_policy(PortableServer_POA obj, PortableServer_ThreadPolicyValue value, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_LifespanPolicy *PortableServer_POA_create_lifespan_policy(PortableServer_POA obj, PortableServer_LifespanPolicyValue value, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_IdUniquenessPolicy *PortableServer_POA_create_id_uniqueness_policy(PortableServer_POA obj, PortableServer_IdUniquenessPolicyValue value, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_IdAssignmentPolicy *PortableServer_POA_create_id_assignment_policy(PortableServer_POA obj, PortableServer_IdAssignmentPolicyValue value, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_ImplicitActivationPolicy *PortableServer_POA_create_implicit_activation_policy(PortableServer_POA obj, PortableServer_ImplicitActivationPolicyValue value, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_ServantRetentionPolicy *PortableServer_POA_create_servant_retention_policy(PortableServer_POA obj, PortableServer_ServantRetentionPolicyValue value, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_RequestProcessingPolicy *PortableServer_POA_create_request_processing_policy(PortableServer_POA obj, PortableServer_RequestProcessingPolicyValue value, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

CORBA_char *PortableServer_POA__get_the_name(PortableServer_POA obj, CORBA_Environment *ev)
{
	g_assert(obj);
	g_assert(obj->the_name);
	return obj->the_name;
}

PortableServer_POA *PortableServer_POA__get_the_parent(PortableServer_POA obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_POAManager PortableServer_POA__get_the_POAManager(PortableServer_POA obj, CORBA_Environment *ev)
{
	g_assert(obj);
	g_assert(obj->the_POAManager);
	return obj->the_POAManager;
}

PortableServer_AdapterActivator *PortableServer_POA__get_the_activator(PortableServer_POA obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

void PortableServer_POA__set_the_activator(PortableServer_POA obj, PortableServer_AdapterActivator the_activator, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}

PortableServer_Servant PortableServer_POA_get_servant_manager(PortableServer_POA obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

void PortableServer_POA_set_servant_manager(PortableServer_POA obj, PortableServer_ServantManager imgr, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}

PortableServer_Servant PortableServer_POA_get_servant(PortableServer_POA obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

void PortableServer_POA_set_servant(PortableServer_POA obj, PortableServer_Servant p_servant, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return;
}

PortableServer_ObjectId *PortableServer_POA_activate_object(PortableServer_POA obj, PortableServer_Servant p_servant, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return NULL;
}

void PortableServer_POA_activate_object_with_id(PortableServer_POA obj, PortableServer_ObjectId *id, PortableServer_Servant p_servant, CORBA_Environment *ev)
{
	PortableServer_ServantBase *servant = p_servant;

	g_hash_table_insert(obj->active_object_map,
			    id->_buffer,
			    p_servant);
	ORBIT_OBJECT_KEY(servant->_private)->object_id = id;
}

void PortableServer_POA_deactivate_object(PortableServer_POA obj, PortableServer_ObjectId *oid, CORBA_Environment *ev)
{
	g_hash_table_remove(obj->active_object_map, oid->_buffer);
}

CORBA_Object PortableServer_POA_create_reference(PortableServer_POA obj, CORBA_RepositoryId intf, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

CORBA_Object PortableServer_POA_create_reference_with_id(PortableServer_POA obj, PortableServer_ObjectId *oid, CORBA_RepositoryId intf, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_ObjectId *PortableServer_POA_servant_to_id(PortableServer_POA obj, PortableServer_Servant p_servant, CORBA_Environment *ev)
{
	PortableServer_ServantBase *serv = p_servant;
	g_return_val_if_fail(p_servant != NULL, NULL);
	return ORBIT_OBJECT_KEY(serv->_private)->object_id;
}

CORBA_Object PortableServer_POA_servant_to_reference(PortableServer_POA obj, PortableServer_Servant p_servant, CORBA_Environment *ev)
{
	return PortableServer_POA_id_to_reference(obj,
						  ORBIT_OBJECT_KEY(((PortableServer_ServantBase*)p_servant)->_private)->object_id, ev);
}

PortableServer_Servant PortableServer_POA_reference_to_servant(PortableServer_POA obj, CORBA_Object reference, CORBA_Environment *ev)
{
	g_return_val_if_fail(reference != NULL, NULL);

	return g_hash_table_lookup(obj->active_object_map,
				   reference->obj_id);
}

PortableServer_ObjectId *PortableServer_POA_reference_to_id(PortableServer_POA obj, CORBA_Object reference, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_Servant PortableServer_POA_id_to_servant(PortableServer_POA obj, PortableServer_ObjectId *oid, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

CORBA_Object PortableServer_POA_id_to_reference(PortableServer_POA obj, PortableServer_ObjectId *oid, CORBA_Environment *ev)
{
						  
	CORBA_Object retval = ORBit_CORBA_Object_new(ev);

	retval->orb = obj->the_POAManager->orb;

	retval->obj_id = g_strdup(oid->_buffer);
	retval->connection = GIOP_CONNECTION(iiop_connection_server());
	giop_connection_ref(retval->connection);

	ORBit_set_object_key(retval,
			     oid->_buffer,
			     strlen(oid->_buffer)+1);

	return CORBA_Object_duplicate(retval, ev);
}


PortableServer_POA *PortableServer_Current_get_POA(PortableServer_Current obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_ObjectId *PortableServer_Current_get_object_id(PortableServer_Current obj, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}


CORBA_char *PortableServer_ObjectId_to_string(PortableServer_ObjectId *id, CORBA_Environment *env)
{
	char *retval = ORBit_alloc(strlen(id->_buffer)+1, NULL, NULL);
	strcpy(retval, id->_buffer);
	return retval;
}

CORBA_wchar *PortableServer_ObjectId_to_wstring(PortableServer_ObjectId *id, CORBA_Environment *env)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_ObjectId *PortableServer_string_to_ObjectId(CORBA_char *str, CORBA_Environment *env)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

PortableServer_ObjectId *PortableServer_wstring_to_ObjectId(CORBA_wchar *str, CORBA_Environment *env)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}


PortableServer_POA *PortableServer_ServantBase__default_POA(PortableServer_Servant servant, CORBA_Environment *ev)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}


void PortableServer_ServantLocator_preinvoke(PortableServer_ObjectId *oid, PortableServer_POA adapter, CORBA_Identifier op_name, PortableServer_ServantLocator_Cookie *cookie)
{
	g_assert(!"Not yet implemented");
	return;
}

void PortableServer_ServantLocator_postinvoke(PortableServer_ObjectId *oid, PortableServer_POA adapter, CORBA_Identifier op_name, PortableServer_ServantLocator_Cookie cookie, PortableServer_Servant servant)
{
	g_assert(!"Not yet implemented");
	return;
}

void PortableServer_ServantBase__init(PortableServer_Servant servant,
				      CORBA_Environment *ev)
{
	PortableServer_ServantBase *serv = servant;
	serv->_private = g_new0(ORBit_ObjectKey, 1);
}

void PortableServer_ServantBase__fini(PortableServer_Servant servant,
				      CORBA_Environment *ev)
{
	PortableServer_ServantBase *serv = servant;

	g_free(serv->_private);
	serv->_private = NULL;
}


/************************ ServerRequest stuff ********************/

CORBA_Identifier CORBA_ServerRequest_operation(CORBA_ServerRequest req, CORBA_Environment *env)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

CORBA_Context *CORBA_ServerRequest_ctx(CORBA_ServerRequest req, CORBA_Environment *env)
{
	g_assert(!"Not yet implemented");
	return(NULL);
}

void CORBA_ServerRequest_arguments(CORBA_ServerRequest req, CORBA_NVList *parameters, CORBA_Environment *env)
{
	g_assert(!"Not yet implemented");
	return;
}

void CORBA_ServerRequest_set_result(CORBA_ServerRequest req, CORBA_any *value, CORBA_Environment *env)
{
	g_assert(!"Not yet implemented");
	return;
}

void CORBA_ServerRequest_set_exception(CORBA_ServerRequest req, CORBA_exception_type major, CORBA_any *value, CORBA_Environment *env)
{
	g_assert(!"Not yet implemented");
	return;
}
