/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter and Red Hat Software
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Phil Dawes <philipd@parallax.co.uk>
 *	  Elliot Lee <sopwith@redhat.com>
 *
 */

/*
 *   ORBit specific POA funcitons.
 *
 */

#include "orbit.h"
#include "orbit_poa_type.h"

static void ORBit_POAManager_release(PortableServer_POAManager poa_mgr,
				     CORBA_Environment *ev);

static void ORBit_POA_release(PortableServer_POA poa,
			      CORBA_Environment *ev);


ORBit_RootObject_Interface CORBA_POAManager_epv =
{
	(gpointer)ORBit_POAManager_release,
};

ORBit_RootObject_Interface CORBA_POA_epv =
{
	(gpointer)ORBit_POA_release,
};


PortableServer_POAManager 
ORBit_POAManager_new(CORBA_Environment *ev)
{
	PortableServer_POAManager poa_mgr;
	poa_mgr = g_new(struct PortableServer_POAManager_type, 1);

	ORBit_pseudo_object_init(ORBIT_PSEUDO_OBJECT(poa_mgr), ORBIT_PSEUDO_POAMANAGER);

	if(poa_mgr == NULL) {
		CORBA_exception_set_system(ev, ex_CORBA_NO_MEMORY, CORBA_COMPLETED_NO);
		goto error;
	}

	/* Initialise poa manager */

	ORBit_pseudo_object_init(ORBIT_PSEUDO_OBJECT(poa_mgr), ORBIT_PSEUDO_POAMANAGER);
	ORBIT_ROOT_OBJECT(poa_mgr)->refs = 0;

	ORBit_RootObject_set_interface(ORBIT_ROOT_OBJECT(poa_mgr),&CORBA_POAManager_epv,ev);

	poa_mgr->poa_collection = NULL;

	return poa_mgr;

error:
	if(poa_mgr != NULL){
		ORBit_POAManager_release(poa_mgr, ev);
	}
	return NULL;
}

void
ORBit_POAManager_release(PortableServer_POAManager poa_mgr,
			 CORBA_Environment *ev)
{

	if(--(ORBIT_ROOT_OBJECT(poa_mgr)->refs) > 0)
		return;

	if(poa_mgr != NULL) {
		if(poa_mgr->poa_collection != NULL)  {
			g_slist_free(poa_mgr->poa_collection);
			poa_mgr->poa_collection = NULL;
		}
		g_free(poa_mgr);
		poa_mgr = NULL;
	}
}

void
ORBit_POAManager_register_poa(PortableServer_POAManager poa_mgr, 
			      PortableServer_POA poa,
			      CORBA_Environment *ev)
{
	poa_mgr->poa_collection = 
		g_slist_append(poa_mgr->poa_collection,poa);
}

PortableServer_POA 
ORBit_POA_new(CORBA_char *adapter_name,
	      PortableServer_POAManager the_POAManager,
	      CORBA_PolicyList *policies,
	      CORBA_Environment *ev)
{  
	
	PortableServer_POA poa;

	/* Create the object */
	poa = (PortableServer_POA) g_new(struct PortableServer_POA_type, 1); 
	if(poa == NULL) {
		CORBA_exception_set_system(ev, ex_CORBA_NO_MEMORY, CORBA_COMPLETED_NO);
		goto error;
	}

	ORBit_pseudo_object_init(ORBIT_PSEUDO_OBJECT(poa), ORBIT_PSEUDO_POA);
	
	ORBIT_ROOT_OBJECT(poa)->refs = 0;
	ORBit_RootObject_set_interface(ORBIT_ROOT_OBJECT(poa),&CORBA_POA_epv,ev);
  
	/* Register this poa with the poa manager */
	if(the_POAManager != NULL) {
		ORBit_POAManager_register_poa(the_POAManager,poa,ev);
		if(ev->_major != CORBA_NO_EXCEPTION) {
			/* TODO - add some proper exception handling here  */
			g_assert(!"Exception thrown but handler not implemented");
		}

	}


	/* Need to initialise poa policies etc.. here */

	/* copy the name  */
	poa->the_name = g_strdup(adapter_name);
	if(poa->the_name == NULL) {
		CORBA_exception_set_system(ev, ex_CORBA_NO_MEMORY, CORBA_COMPLETED_NO);
		goto error;
	}
	/* Wire up the poa_manager */
	poa->the_POAManager = the_POAManager;

	poa->active_object_map = g_hash_table_new(g_str_hash, g_str_equal);

	/* Initialise the child poas table */
	poa->child_POAs = NULL;      /* initialise the slist */


	return poa;

error:
	if(poa->the_name){
		CORBA_free(poa->the_name);
	}
	if(poa != NULL){
		ORBit_POA_release(poa, NULL);
	}
	return NULL;
}



void
ORBit_POA_release(PortableServer_POA poa,
		  CORBA_Environment *ev)
{
	ORBIT_ROOT_OBJECT_UNREF(poa);

	if(ORBIT_ROOT_OBJECT(poa)->refs <= 0) {
		
		if(poa->the_name){
			CORBA_free(poa->the_name);
		}
		g_slist_free(poa->child_POAs);
		g_free(poa);
	}
}


void
ORBit_POA_add_child(PortableServer_POA poa,
		    PortableServer_POA child_poa,
		    CORBA_Environment *ev)

{
	poa->child_POAs = g_slist_prepend(poa->child_POAs,child_poa);
}

void
ORBit_POA_handle_request(PortableServer_POA poa,
			 GIOPRecvBuffer *recv_buffer)
{
	PortableServer_ServantBase *servant;
	ORBitSkeleton skel;
	gpointer imp;
	CORBA_Environment ev;

	g_assert(poa);
	g_assert(recv_buffer);

	CORBA_exception_init(&ev);
	
	g_assert(poa);

	servant = g_hash_table_lookup(poa->active_object_map,
				      recv_buffer->message.u.request.object_key._buffer);

	g_assert(poa);
	g_assert(servant);

	skel = ORBIT_OBJECT_KEY(servant->_private)->class_info->relay_call(servant, recv_buffer, &imp);

	skel(servant, recv_buffer, &ev, imp);
}
