/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Dick Porter <dick@cymru.net>
 *
 */

#ifndef _ORBIT_H_
#define _ORBIT_H_

#include <glib.h>

#include <IIOP/IIOP.h>
#include <ORBitutil/thread-safety.h>
#include <ORBitutil/trace.h>
#include "orbit_config.h"
#include "orbit_types.h"
#include "allocators.h"
#include "boa.h"
#include "cdr.h"
#include "dii.h"
#include "dynany.h"
#include "env.h"
#include "iop.h"
#include "ir.h"
#include "options.h"
#include "orb.h"
#include "poa.h"
#include "sequences.h"
#include "typecode.h"

extern void CORBA_any_set_release(
	CORBA_any *,
	CORBA_boolean);

extern CORBA_boolean CORBA_any_get_release(
	CORBA_any *);

extern void CORBA_sequence_set_release(
	void *,
	CORBA_boolean);

extern CORBA_boolean CORBA_sequence_get_release(
	void *);

extern CORBA_any *CORBA_any_alloc(
	void);

extern CORBA_boolean ORBit_any_equivalent(
	CORBA_any obj,
	CORBA_any any,
	CORBA_Environment *ev);

extern CORBA_char *CORBA_string_dup(CORBA_char *string);
extern CORBA_char *CORBA_string_alloc(CORBA_unsigned_long len);
#define CORBA_string__free NULL

extern CORBA_wchar *CORBA_wstring_alloc(CORBA_unsigned_long len);
#define CORBA_wstring__free NULL

/* 19.14 */
extern CORBA_long CORBA_fixed_integer_part(
	const void *fp);

extern CORBA_long CORBA_fixed_fraction_part(
	const void *fp);

extern void CORBA_fixed_set(
	void *rp,
	const CORBA_long i,
	const CORBA_long f);

extern void CORBA_fixed_add(
	void *rp,
	const void *f1p,
	const void *f2p);

extern void CORBA_fixed_sub(
	void *rp,
	const void *f1p,
	const void *f2p);

extern void CORBA_fixed_mul(
	void *rp,
	const void *f1p,
	const void *f2p);

extern void CORBA_fixed_div(
	void *rp,
	const void *f1p,
	const void *f2p);

extern CORBA_fixed_d_s *CORBA_fixed_alloc(
	CORBA_unsigned_short d);

extern void CORBA_free(
	void *storage);

extern int ORBit_parse_inet(
	CORBA_Object obj,
	char *hostname,
	unsigned short port);

/****
     This function lets you use your own event loop, if you so wish.
     Also see IIOP.h's IIOP{Add,Remove}ConnectionHandler function pointers,
     which are app-settable (you should set them before CORBA_ORB_init,
     if you want them to be useful)
 ****/

    /* needs to be called by your event loop when data comes in on one of the
       GIOPConnection fd's */
void ORBit_custom_run_setup(CORBA_ORB orb, CORBA_Environment *ev);
void ORBit_handle_incoming(GIOPConnection *connection);

/********* Unused
extern glong ORBit_register_class(char *name,
				  gpointer method_stubs,
				  gpointer method_skels,
				  gpointer class_vtable_init_func,
				  glong *parent_class_ids);

extern void ORBit_initialize_object_vtable(CORBA_Object _handle_to_be,
					   glong class_id,
					   gboolean is_impl);
					   **** end unused ******/

#endif	/* !_ORBIT_H_ */
