/* This is -*- C -*- */
/* vim: set sw=2: */
/* $Id: guppi-attribute-flavor-private.h,v 1.5 2001/11/16 16:59:06 trow Exp $ */

/*
 * guppi-attribute-flavor-private.h
 *
 * Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 */

#ifndef __GUPPI_ATTRIBUTE_FLAVOR_PRIVATE_H__
#define __GUPPI_ATTRIBUTE_FLAVOR_PRIVATE_H__

#include "guppi-attribute-flavor.h"

BEGIN_GUPPI_DECLS

typedef struct _GuppiSignalsToForward GuppiSignalsToForward;
struct _GuppiSignalsToForward {
  gchar *name;
  gboolean queue;
};

struct _GuppiAttributesFlavorInfo {

  GuppiAttributeFlavor flavor;
  gchar *name;

  AttributeCreateDefaultFn create_default;
  AttributeDestroyFn destroy;
  AttributeCopyFn copy;
  AttributeEqualityFn equality;

  AttributeGetFromPointerFn getp;
  AttributeGetFromVarArgsFn va2p;
  AttributePutToVarArgsFn   p2va;

  AttributeWidgetFn widget;

  AttributeExportStringFn export_string;
  AttributeImportStringFn import_string;

  AttributeExportXMLFn export_xml;
  AttributeImportXMLFn import_xml;

  GList *signals_to_forward;
};

END_GUPPI_DECLS

#endif /* __GUPPI_ATTRIBUTE_FLAVOR_PRIVATE_H__ */

