/* This is -*- C -*- */
/* $Id: guppi-seq-object-core-impl.h,v 1.5 2001/08/21 02:54:53 trow Exp $ */

/*
 * guppi-seq-object-core-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 * Copyright (C) 2001 The Free Software Foundation
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_OBJECT_CORE_IMPL_H
#define _INC_GUPPI_SEQ_OBJECT_CORE_IMPL_H

/* #include <gtk/gtk.h> */
#include <guppi-defs.h>
#include <guppi-garray.h>
#include <guppi-seq-object.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiSeqObjectCore GuppiSeqObjectCore;
typedef struct _GuppiSeqObjectCoreClass GuppiSeqObjectCoreClass;

struct _GuppiSeqObjectCore {
  GuppiSeqObject parent;

  gint index_basis;
  gsize size;
  GuppiGArray *garray;
};

struct _GuppiSeqObjectCoreClass {
  GuppiSeqObjectClass parent_class;
};

#define GUPPI_TYPE_SEQ_OBJECT_CORE (guppi_seq_object_core_get_type())
#define GUPPI_SEQ_OBJECT_CORE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_OBJECT_CORE,GuppiSeqObjectCore))
#define GUPPI_SEQ_OBJECT_CORE0(obj) ((obj) ? (GUPPI_SEQ_OBJECT_CORE(obj)) : NULL)
#define GUPPI_SEQ_OBJECT_CORE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_OBJECT_CORE,GuppiSeqObjectCoreClass))
#define GUPPI_IS_SEQ_OBJECT_CORE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_OBJECT_CORE))
#define GUPPI_IS_SEQ_OBJECT_CORE0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_OBJECT_CORE(obj)))
#define GUPPI_IS_SEQ_OBJECT_CORE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_OBJECT_CORE))

GtkType guppi_seq_object_core_get_type (void);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_SEQ_OBJECT_CORE_H */

/* $Id: guppi-seq-object-core-impl.h,v 1.5 2001/08/21 02:54:53 trow Exp $ */
