%define  ver     0.40.1
%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define  prefix  /usr

Summary: GNOME Data Analysis and Visualization
Name: Guppi
Version: %ver
Release: %rel
Copyright: GPL
Group: Applications/Engineering
Source: ftp://ftp.gnome.org/pub/guppi/%{name}-%{ver}.tar.gz
Url: http://www.gnome.org/guppi
BuildRoot: /var/tmp/%{name}-%{ver}-root
Requires: guile >= 1.3.4

%description
GNOME is the GNU Network Object Model Environment. This powerful environment is both easy to use and easy to configure.

This package will install Guppi, a GNOME-based data analysis and visualization system.

Install this package if you want to test Guppi.

%package devel
Summary: Libraries and include files to develop Guppi-based applications
Group: Development/Libraries

%description devel
The Guppi-devel package includes the static libraries and header files for the
Guppi package.

Install Guppi-devel if you want to develop programs which will use the Guppi
libraries.

%prep
%setup

%build
%ifarch alpha
  MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

if [ ! -f configure ]; then
CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix $MYARCH_FLAGS --sysconfdir=/etc
else
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix $MYARCH_FLAGS --sysconfdir=/etc
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make prefix=$RPM_BUILD_ROOT%{prefix} install-strip

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS BIBLIOGRAPHY NEWS README
%attr(755,root,root) %{prefix}/bin/*
%{prefix}/lib/guppi/plug-ins/%{ver}/data_impl/*/*.plugin
%{prefix}/lib/guppi/plug-ins/%{ver}/data_impl/*/*.so
%{prefix}/lib/guppi/plug-ins/%{ver}/data_impl/*/*.scm
%{prefix}/lib/guppi/plug-ins/%{ver}/import/*/*.plugin
%{prefix}/lib/guppi/plug-ins/%{ver}/import/*/*.so
%{prefix}/lib/guppi/plug-ins/%{ver}/import/*/*.scm
%{prefix}/lib/guppi/plug-ins/%{ver}/import/*/*.glade
%{prefix}/lib/guppi/plug-ins/%{ver}/plot/*/*.plugin
%{prefix}/lib/guppi/plug-ins/%{ver}/plot/*/*.so
%{prefix}/lib/guppi/plug-ins/%{ver}/plot/*/*.scm
%{prefix}/lib/guppi/plug-ins/%{ver}/plot/*/*.glade
%{prefix}/lib/guppi/plug-ins/%{ver}/plot/*/*.png
%{prefix}/lib/lib*.so.*
%{prefix}/share/gnome/apps/Applications/guppi.desktop
%{prefix}/share/gnome/help/guppi/C/*.*
%{prefix}/share/guppi/glade/view-properties.glade
%{prefix}/share/guppi/scripts/python/Guppi/plot/*
%{prefix}/share/guppi/scripts/python/Guppi/data_impl/*
%{prefix}/share/guppi/scripts/python/Guppi/*.*
%{prefix}/share/guppi/scripts/*.*
%{prefix}/share/locale/*/LC_MESSAGES/*.mo
%{prefix}/share/oaf/GNOME_Guppi.oafinfo
%{prefix}/share/pixmaps/guppi/*.png
%{prefix}/share/pixmaps/gnome-guppi.png

%files devel
%defattr(-, root, root)

%{prefix}/include/gnome-1.0/libguppi/*
%{prefix}/include/gnome-1.0/libguppitank/*
%{prefix}/lib/guppi/plug-ins/%{ver}/data_impl/*/*.la
%{prefix}/lib/guppi/plug-ins/%{ver}/import/*/*.la
%{prefix}/lib/guppi/plug-ins/%{ver}/plot/*/*.la
%{prefix}/lib/lib*.so
%{prefix}/lib/lib*a
%{prefix}/lib/*.sh
%{prefix}/share/aclocal/libguppi.m4

%changelog

* Fri Nov 16 2001 Jon Trowbridge <trow@gnu.org>

- Changed references to 'include' to 'include/gnome-1.0'.

* Mon Apr 04 2001 John Gotts <jgotts@linuxsavvy.com>

- Vastly improved spec file.

* Sat Mar 04 2000 Jon Trowbridge <trow@gnu.org>

- Converted Guppi.spec to Guppi.spec.in.
- Tweaked the language in the summary & description.

* Mon Feb 28 2000 Jon Trowbridge <trow@gnu.org>

- Changed version to 0.34.3.

* Wed Feb 23 2000 Jon Trowbridge <trow@gnu.org>

- Updated to 0.34.2.

* Mon Feb 22 2000 Kenny Graunke <graunke@teleport.com>

- Updated to 0.34.1 (using repackaged source, ugh), spec file rewrite
- This 0.34.1 source disables readline due to broken libguilereadline.so
  problems in every guile 1.3.4 x86 RPM I've seen...

* Wed Jan 26 2000 Conrad Steenberg <conrad@srl.caltech.edu>

- Some Alpha fixes for configure
- Remove some unneeded stripping foo and just do a 'make install-strip' instead.
- Move this changelog to the bottom of the file :-)

* Mon Jan 24 2000 Kenny Graunke <graunke@teleport.com>

- First Guppi RPM
