/* This is -*- C -*- */
/* $Id: guppi-seq-impl.h,v 1.13 2001/01/16 23:36:19 trow Exp $ */

/*
 * guppi-seq-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_IMPL_H
#define _INC_GUPPI_SEQ_IMPL_H

/* #include <gtk/gtk.h> */

#include "guppi-data.h"
#include "guppi-data-impl.h"
#include "guppi-seq.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GuppiSeqImpl GuppiSeqImpl;

struct _GuppiSeqImpl {
  GuppiDataImpl parent;

  gpointer opaque_missing_values;
};

typedef struct {
  GuppiDataImplClass parent_class;

  void (*size_hint) (GuppiSeqImpl *, gsize);
  void (*get_bounds) (const GuppiSeqImpl *, gint *min, gint *max);
  void (*shift_indices) (GuppiSeqImpl *, gint delta);
  gboolean (*validate) (const GuppiSeqImpl *, const gchar *, gchar *, gsize);

    gboolean (*has_missing) (GuppiSeqImpl *);
    gsize (*missing_count) (GuppiSeqImpl *);

    gboolean (*missing) (GuppiSeqImpl *, gint i);
  void (*get) (const GuppiSeqImpl *, gint i, gchar *, gsize);

  void (*set) (GuppiSeqImpl *, gint, const gchar *);
  void (*set_missing) (GuppiSeqImpl *, gint);

  void (*insert) (GuppiSeqImpl *, gint, const gchar *);
  void (*insert_missing) (GuppiSeqImpl *, gint);

  void (*delete_many) (GuppiSeqImpl *, gint, gsize);
  void (*grow_to_include) (GuppiSeqImpl *, gint, gint);

} GuppiSeqImplClass;

#define GUPPI_TYPE_SEQ_IMPL (guppi_seq_impl_get_type())
#define GUPPI_SEQ_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_IMPL,GuppiSeqImpl))
#define GUPPI_SEQ_IMPL0(obj) ((obj) ? (GUPPI_SEQ_IMPL(obj)) : NULL)
#define GUPPI_SEQ_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_IMPL,GuppiSeqImplClass))
#define GUPPI_IS_SEQ_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_IMPL))
#define GUPPI_IS_SEQ_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_IMPL(obj)))
#define GUPPI_IS_SEQ_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_IMPL))

GtkType guppi_seq_impl_get_type (void);

GtkObject *guppi_seq_impl_new (void);

/*
 * API for low-level implementation of the missing values mask, that
 * can be used by derived classes.
 */

gboolean guppi_seq_impl_has_missing (GuppiSeqImpl *);
gsize guppi_seq_impl_missing_count (GuppiSeqImpl *);
gboolean guppi_seq_impl_missing (GuppiSeqImpl *, gint i);
void guppi_seq_impl_set_missing (GuppiSeqImpl *, gint i, gboolean);
void guppi_seq_impl_set_many_missing (GuppiSeqImpl * impl, gint i, gint N,
				      gboolean x);
void guppi_seq_impl_insert_missing (GuppiSeqImpl *, gint i, gboolean x,
				    gsize N);
void guppi_seq_impl_delete_missing (GuppiSeqImpl *, gint i, gsize N);
void guppi_seq_impl_clear_missing (GuppiSeqImpl *);

void guppi_seq_impl_debug_missing (GuppiSeqImpl *);



END_GUPPI_DECLS

#endif /* _INC_GUPPI_SEQ_IMPL_H */

/* $Id: guppi-seq-impl.h,v 1.13 2001/01/16 23:36:19 trow Exp $ */
