/* This is -*- C -*- */
/* $Id: guppi-scatter-style-view.h,v 1.5 2001/01/16 23:36:04 trow Exp $ */

/*
 * guppi-scatter-style-view.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SCATTER_STYLE_VIEW_H
#define _INC_GUPPI_SCATTER_STYLE_VIEW_H

/* #include <gnome.h> */
#include <guppi-defs.h>
#include "guppi-scatter-style.h"

BEGIN_GUPPI_DECLS

typedef struct _GuppiScatterStyleView GuppiScatterStyleView;
typedef struct _GuppiScatterStyleViewClass GuppiScatterStyleViewClass;

struct _GuppiScatterStyleView {
  GtkObject parent;

  GuppiScatterStyle *style;
  double scale_factor;

  GuppiMarker marker;
  double marker_sz1, marker_sz2;
  GuppiAlphaTemplate *marker_template;

  /* variable size1 template cache */
  GuppiMarker sz1_marker;
  double sz1_min, sz1_max, sz1_sz2, sz1_scale;
  gint sz1_cache_size;
  GuppiAlphaTemplate **sz1_cache;


  /* variable size2 template cache */
  GuppiMarker sz2_marker;
  double sz2_min, sz2_max, sz2_sz1, sz2_scale;
  gint sz2_cache_size;
  GuppiAlphaTemplate **sz2_cache;


  /* the mixed size1/size2 cache */
  GuppiMarker mixed_marker;
  double mixed_sz1_min, mixed_sz1_max, mixed_sz2_min, mixed_sz2_max;
  double mixed_scale;
  gint mixed_sz1_size, mixed_sz2_size;
  GuppiAlphaTemplate **mixed_cache;
};

struct _GuppiScatterStyleViewClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_SCATTER_STYLE_VIEW (guppi_scatter_style_view_get_type())
#define GUPPI_SCATTER_STYLE_VIEW(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SCATTER_STYLE_VIEW,GuppiScatterStyleView))
#define GUPPI_SCATTER_STYLE_VIEW0(obj) ((obj) ? (GUPPI_SCATTER_STYLE_VIEW(obj)) : NULL)
#define GUPPI_SCATTER_STYLE_VIEW_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SCATTER_STYLE_VIEW,GuppiScatterStyleViewClass))
#define GUPPI_IS_SCATTER_STYLE_VIEW(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SCATTER_STYLE_VIEW))
#define GUPPI_IS_SCATTER_STYLE_VIEW0(obj) (((obj) == NULL) || (GUPPI_IS_SCATTER_STYLE_VIEW(obj)))
#define GUPPI_IS_SCATTER_STYLE_VIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SCATTER_STYLE_VIEW))

GtkType guppi_scatter_style_view_get_type (void);

GuppiScatterStyleView *guppi_scatter_style_view_new (void);

void guppi_scatter_style_view_set_style (GuppiScatterStyleView *,
					 GuppiScatterStyle *);
void guppi_scatter_style_view_reset (GuppiScatterStyleView *);

void guppi_scatter_style_view_set_scale (GuppiScatterStyleView *, double);

GuppiAlphaTemplate
  *guppi_scatter_style_view_marker_template (GuppiScatterStyleView *,
					     double t_sz1, double t_sz2);
guint32 guppi_scatter_style_view_marker_color (GuppiScatterStyleView *,
					       double t);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_SCATTER_STYLE_VIEW_H */

/* $Id: guppi-scatter-style-view.h,v 1.5 2001/01/16 23:36:04 trow Exp $ */
