/* This is -*- C -*- */
/* vim: set sw=2: */
/* $Id: guppi-polynomial.h,v 1.1 2001/05/03 23:02:26 trow Exp $ */

/*
 * guppi-polynomial.h
 *
 * Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 */

#ifndef __GUPPI_POLYNOMIAL_H__
#define __GUPPI_POLYNOMIAL_H__

#include <glib.h>
#include "guppi-xml.h"

typedef struct _GuppiPolynomial GuppiPolynomial;
struct _GuppiPolynomial {
  gint d;    /* degree */
  gint N;    /* allocated degree */
  double *c; /* coefficients */
};

#define guppi_polynomial_degree(p) ((p)->d)

GuppiPolynomial *guppi_polynomial_new  (gint degree, ...);
GuppiPolynomial *guppi_polynomial_newv (gint degree, const double *);

GuppiPolynomial *guppi_polynomial_new_linear    (double c0, double c1);
GuppiPolynomial *guppi_polynomial_new_quadratic (double c0, double c1, double c2);

GuppiPolynomial *guppi_polynomial_copy (GuppiPolynomial *);
void             guppi_polynomial_free (GuppiPolynomial *);
double           guppi_polynomial_coefficient (GuppiPolynomial *, gint i);
double           guppi_polynomial_eval (GuppiPolynomial *, double);
void             guppi_polynomial_eval_many (GuppiPolynomial *, gint N, double *src, double *dest);

void             guppi_polynomial_D (GuppiPolynomial *);

/* Divide through by coefficient on highest-degree term, resulting in
   a polynomial with leading coefficient 1. */
void             guppi_polynomial_normalize (GuppiPolynomial *);

/* The remainder of dividing by the polynomial mod */
void             guppi_polynomial_modulo    (GuppiPolynomial *, GuppiPolynomial *mod);

/* Divide polynomial by (x-x0).  If x0 isn't a root, you have to manage the
   remainder term by hand. */
void             guppi_polynomial_deflate         (GuppiPolynomial *, double x0);
void             guppi_polynomial_deflate_complex (GuppiPolynomial *, double re, double im);

double           guppi_polynomial_newton_polish   (GuppiPolynomial *, double x0, gint max_iter, double epsilon);

double           guppi_polynomial_gershgorin_radius (GuppiPolynomial *);

void             guppi_polynomial_spew (GuppiPolynomial *);

xmlNodePtr       guppi_polynomial_export_xml (GuppiPolynomial *, GuppiXMLDocument *);
GuppiPolynomial *guppi_polynomial_import_xml (GuppiXMLDocument *, xmlNodePtr);

#endif /* __GUPPI_POLYNOMIAL_H__ */

