/* This is -*- C -*- */
/* $Id: guppi-linegraph-state.c,v 1.6 2001/05/06 07:56:36 trow Exp $ */

/*
 * guppi-linegraph-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-useful.h>
#include "guppi-linegraph-state.h"
#include "guppi-linegraph-view.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_linegraph_state_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_linegraph_state_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_linegraph_state_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/***************************************************************************/

static void
guppi_linegraph_state_class_init (GuppiLinegraphStateClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiElementStateClass *state_class = GUPPI_ELEMENT_STATE_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_ELEMENT_STATE);

  object_class->get_arg = guppi_linegraph_state_get_arg;
  object_class->set_arg = guppi_linegraph_state_set_arg;
  object_class->finalize = guppi_linegraph_state_finalize;

  state_class->view_type = GUPPI_TYPE_LINEGRAPH_VIEW;
}

static void
guppi_linegraph_state_init (GuppiLinegraphState * obj)
{

  guppi_element_state_add_shared (GUPPI_ELEMENT_STATE (obj),
				  SHARED_DATA, guppi_shared_data ());

  guppi_element_state_add_shared (GUPPI_ELEMENT_STATE (obj),
				  SHARED_X_DATA, guppi_shared_data ());

  guppi_element_state_add_shared (GUPPI_ELEMENT_STATE (obj),
				  SHARED_Y_DATA, guppi_shared_data ());


  obj->color = RGBA_BLUE;
  obj->width = guppi_in2pt (1.0 / 32);
}

GtkType guppi_linegraph_state_get_type (void)
{
  static GtkType guppi_linegraph_state_type = 0;
  if (!guppi_linegraph_state_type) {
    static const GtkTypeInfo guppi_linegraph_state_info = {
      "GuppiLinegraphState",
      sizeof (GuppiLinegraphState),
      sizeof (GuppiLinegraphStateClass),
      (GtkClassInitFunc) guppi_linegraph_state_class_init,
      (GtkObjectInitFunc) guppi_linegraph_state_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_linegraph_state_type =
      gtk_type_unique (GUPPI_TYPE_ELEMENT_STATE, &guppi_linegraph_state_info);
  }
  return guppi_linegraph_state_type;
}

GuppiElementState *
guppi_linegraph_state_new (void)
{
  return
    GUPPI_ELEMENT_STATE (guppi_type_new (guppi_linegraph_state_get_type ()));
}

GuppiData *
guppi_linegraph_state_data (GuppiLinegraphState *state)
{
  GtkObject *obj;
  g_return_val_if_fail (state && GUPPI_IS_LINEGRAPH_STATE (state), NULL);

  obj = guppi_element_state_get_shared (GUPPI_ELEMENT_STATE (state),
					SHARED_DATA);

  return GUPPI_DATA0 (obj);
}

void
guppi_linegraph_state_set_data (GuppiLinegraphState *state,
				GuppiData *data)
{
  g_return_if_fail (state && GUPPI_IS_LINEGRAPH_STATE (state));
  g_return_if_fail (data || GUPPI_IS_DATA (data));

  guppi_element_state_set_shared (GUPPI_ELEMENT_STATE (state),
				  SHARED_DATA, data);
}

GuppiSeqScalar *
guppi_linegraph_state_x_data (GuppiLinegraphState * state)
{
  GtkObject *obj;
  g_return_val_if_fail (state != NULL, NULL);
  g_return_val_if_fail (GUPPI_IS_LINEGRAPH_STATE (state), NULL);

  obj = guppi_element_state_get_shared (GUPPI_ELEMENT_STATE (state),
					SHARED_X_DATA);
  return GUPPI_SEQ_SCALAR0 (obj);
}

void
guppi_linegraph_state_set_x_data (GuppiLinegraphState * state,
				  GuppiSeqScalar * sd)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_LINEGRAPH_STATE (state));

  guppi_element_state_set_shared (GUPPI_ELEMENT_STATE (state),
				  SHARED_X_DATA, sd);
}

GuppiSeqScalar *
guppi_linegraph_state_y_data (GuppiLinegraphState * state)
{
  GtkObject *obj;
  g_return_val_if_fail (state != NULL, NULL);
  g_return_val_if_fail (GUPPI_IS_LINEGRAPH_STATE (state), NULL);

  obj = guppi_element_state_get_shared (GUPPI_ELEMENT_STATE (state),
					SHARED_Y_DATA);
  return GUPPI_SEQ_SCALAR0 (obj);
}

void
guppi_linegraph_state_set_y_data (GuppiLinegraphState * state,
				  GuppiSeqScalar * sd)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_LINEGRAPH_STATE (state));

  guppi_element_state_set_shared (GUPPI_ELEMENT_STATE (state),
				  SHARED_X_DATA, sd);

}

void
guppi_linegraph_state_set_width (GuppiLinegraphState * state, double w)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_LINEGRAPH_STATE (state));
  g_return_if_fail (w >= 0);

  if (state->width != w) {
    state->width = w;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}

void
guppi_linegraph_state_set_color (GuppiLinegraphState * state, guint32 c)
{
  g_return_if_fail (state != NULL);
  g_return_if_fail (GUPPI_IS_LINEGRAPH_STATE (state));

  if (state->color != c) {
    state->color = c;
    guppi_element_state_changed_delayed (GUPPI_ELEMENT_STATE (state));
  }
}


/* $Id: guppi-linegraph-state.c,v 1.6 2001/05/06 07:56:36 trow Exp $ */
