/* This is -*- C -*- */
/* $Id: guppi-barchart-item.c,v 1.14 2001/05/06 07:56:27 trow Exp $ */

/*
 * guppi-barchart-item.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-rgb.h>
#include "guppi-barchart-item.h"
#include "guppi-barchart-view.h"
#include "guppi-barchart-state.h"
#include "guppi-barchart-tools.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

enum {
  CLICKED_BAR,
  LAST_SIGNAL
};

guint bar_signals[LAST_SIGNAL] = { 0 };

static void
guppi_barchart_item_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_barchart_item_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_barchart_item_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_barchart_item_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/**************************************************************************/

static void
state_changed (GuppiCanvasItem * gci)
{
  guppi_canvas_item_request_update (gci);
}

static void
view_changed (GuppiCanvasItem * gci)
{
  guppi_canvas_item_request_update (gci);
}

static void
update (GuppiCanvasItem * gci, double aff[6], ArtSVP * clip_path, gint flags)
{

}

static void
render (GuppiCanvasItem * gci, GnomeCanvasBuf * buf)
{
  GuppiElementView *view;
  GuppiBarchartView *bc_view;
  GuppiBarchartState *state;
  gint c, c0, c1, r, r0, r1;
  double x0, y0, x1, y1, sc, eth;
  guint32 bar_color, edge_color;

  view = guppi_canvas_item_view (gci);
  bc_view = GUPPI_BARCHART_VIEW (view);
  state = GUPPI_BARCHART_STATE (guppi_canvas_item_state (gci));

  sc = guppi_canvas_item_scale (gci);

  eth = guppi_barchart_state_edge_thickness (state);
  eth = guppi_pt2px (eth * sc);
  edge_color = guppi_barchart_state_edge_color (state);

  guppi_barchart_state_col_bounds (state, &c0, &c1);
  for (c = c0; c <= c1; ++c) {

    guppi_barchart_state_rows_in_col (state, c, &r0, &r1);

    bar_color = guppi_barchart_state_col_color (state, c);

    for (r = r0; r <= r1; ++r) {

      guppi_barchart_view_bar_position (bc_view, r, c, &x0, &y0, &x1, &y1);

      /* Transform to canvas coordinates */
      guppi_canvas_item_vp2c_d (gci, x0, y0, &x0, &y0);
      guppi_canvas_item_vp2c_d (gci, x1, y1, &x1, &y1);

      /* This is sort of a silly way to draw a box with a border... */
      guppi_paint_soft_box (buf, x0, y0, x1, y1, edge_color);
      guppi_paint_soft_box (buf,
			    x0 + eth, MIN (y0, y1) + eth,
			    x1 - eth, MAX (y0, y1) - eth, bar_color);

    }
  }
}

static gboolean
double_click (GuppiCanvasItem * gci,
	      guint button, guint state, double pt_x, double pt_y)
{
  GuppiBarchartView *view =
    GUPPI_BARCHART_VIEW (guppi_canvas_item_view (gci));
  double x, y;
  gint r, c;

  guppi_element_view_pt2vp (GUPPI_ELEMENT_VIEW (view), pt_x, pt_y, &x, &y);

  if (guppi_barchart_view_find_bar_at_position (view, x, y, &r, &c)) {

    gtk_signal_emit (GTK_OBJECT (gci), bar_signals[CLICKED_BAR],
		     r, c, button, state);

    return TRUE;
  }

  return FALSE;
}

static void
foreach_class_toolkit (GuppiCanvasItem * item,
		       void (*fn) (GuppiPlotToolkit *, gpointer),
		       gpointer user_data)
{
  GuppiPlotToolkit *tk;

  tk = guppi_barchart_toolkit_style_toggle ();
  fn (tk, user_data);
  guppi_unref (tk);
}

static void
guppi_marshal_NONE__INT_INT_UINT_UINT (GtkObject * obj,
				       GtkSignalFunc func,
				       gpointer func_data, GtkArg * args)
{
  ((void (*)(GtkObject *,
	     gint, gint, guint, guint,
	     gpointer)) func) (obj,
			       GTK_VALUE_INT (args[0]),
			       GTK_VALUE_INT (args[1]),
			       GTK_VALUE_UINT (args[2]),
			       GTK_VALUE_UINT (args[3]), func_data);
}

/**************************************************************************/

static void
guppi_barchart_item_class_init (GuppiBarchartItemClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiCanvasItemClass *gci_class = GUPPI_CANVAS_ITEM_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_CANVAS_ITEM);

  object_class->get_arg = guppi_barchart_item_get_arg;
  object_class->set_arg = guppi_barchart_item_set_arg;
  object_class->destroy = guppi_barchart_item_destroy;
  object_class->finalize = guppi_barchart_item_finalize;

  gci_class->state_changed = state_changed;
  gci_class->view_changed = view_changed;
  gci_class->guppi_update = update;
  gci_class->guppi_render = render;
  gci_class->double_click = double_click;
  gci_class->foreach_class_toolkit = foreach_class_toolkit;

  guppi_canvas_item_class_set_item_class_toolkit (gci_class,
						  guppi_barchart_toolkit_new_default ());

  bar_signals[CLICKED_BAR] =
    gtk_signal_new ("clicked_bar",
		    GTK_RUN_FIRST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (GuppiBarchartItemClass, clicked_bar),
		    guppi_marshal_NONE__INT_INT_UINT_UINT,
		    GTK_TYPE_NONE, 4,
		    GTK_TYPE_INT, GTK_TYPE_INT, GTK_TYPE_UINT, GTK_TYPE_UINT);

  gtk_object_class_add_signals (object_class, bar_signals, LAST_SIGNAL);


}

static void
guppi_barchart_item_init (GuppiBarchartItem * obj)
{

}

GtkType guppi_barchart_item_get_type (void)
{
  static GtkType guppi_barchart_item_type = 0;
  if (!guppi_barchart_item_type) {
    static const GtkTypeInfo guppi_barchart_item_info = {
      "GuppiBarchartItem",
      sizeof (GuppiBarchartItem),
      sizeof (GuppiBarchartItemClass),
      (GtkClassInitFunc) guppi_barchart_item_class_init,
      (GtkObjectInitFunc) guppi_barchart_item_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_barchart_item_type =
      gtk_type_unique (GUPPI_TYPE_CANVAS_ITEM, &guppi_barchart_item_info);
  }
  return guppi_barchart_item_type;
}

GtkObject *
guppi_barchart_item_new (void)
{
  return GTK_OBJECT (guppi_type_new (guppi_barchart_item_get_type ()));
}



/* $Id: guppi-barchart-item.c,v 1.14 2001/05/06 07:56:27 trow Exp $ */
