/* This is -*- C -*- */
/* $Id: guppi-shared.h,v 1.6 2001/01/16 23:36:36 trow Exp $ */

/*
 * guppi-shared.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SHARED_H
#define _INC_GUPPI_SHARED_H

/* #include <gnome.h> */

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiShared GuppiShared;
typedef struct _GuppiSharedClass GuppiSharedClass;

struct _GuppiShared {
  GtkObject parent;

  /* specifications */
  GtkType allowed_type;
  gchar *changed_signal_name;
  void (*pre_set) (GuppiShared *, GtkObject *);
  void (*post_set) (GuppiShared *);

  /* data */
  GtkObject *obj;
  guint changed_handler;
};

struct _GuppiSharedClass {
  GtkObjectClass parent_class;

  /* Signals */

  /* Which particular data object we are holding has changed. */
  void (*changed_held) (GuppiShared *, GtkObject * prev_object);

  /* We continue to hold the same object, but the object's underlying
     state has changed. */
  void (*changed_underlying) (GuppiShared *);

  /* Either of the above. */
  void (*changed) (GuppiShared *);
};

#define GUPPI_TYPE_SHARED (guppi_shared_get_type())
#define GUPPI_SHARED(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SHARED,GuppiShared))
#define GUPPI_SHARED0(obj) ((obj) ? (GUPPI_SHARED(obj)) : NULL)
#define GUPPI_SHARED_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SHARED,GuppiSharedClass))
#define GUPPI_IS_SHARED(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SHARED))
#define GUPPI_IS_SHARED0(obj) (((obj) == NULL) || (GUPPI_IS_SHARED(obj)))
#define GUPPI_IS_SHARED_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SHARED))

GtkType guppi_shared_get_type (void);

void guppi_shared_construct (GuppiShared *,
			     GtkType allowed_type,
			     const gchar * changed_signal_name,
			     void (*pre_set) (GuppiShared *, GtkObject *),
			     void (*post_set) (GuppiShared *));
GuppiShared *guppi_shared_new (GtkType, const gchar *,
			       void (*)(GuppiShared *, GtkObject *),
			       void (*)(GuppiShared *));

/* GtkObject* guppi_shared_get(GuppiShared*); */
#define guppi_shared_get(gs) ((gs)->obj)

void guppi_shared_set (GuppiShared *, GtkObject *);
void guppi_shared_connect (GuppiShared *, GuppiShared *);
void guppi_shared_disconnect (GuppiShared *);

const gchar *guppi_shared_allowed_type (GuppiShared *);


/* Some "ready-made" specializations. */

GuppiShared *guppi_shared_data (void);
GuppiShared *guppi_shared_view_interval (void);
GuppiShared *guppi_shared_axis_markers (void);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_SHARED_H */

/* $Id: guppi-shared.h,v 1.6 2001/01/16 23:36:36 trow Exp $ */
