/* This is auto-generated code.  Edit at your own peril! */

#include <config.h>
#include <guppi-convenient.h>
#include "guppi-scm-plot.h"

static long guppi_style_type_tag;
#define SCM_TO_GUPPI_STYLE(x) (GUPPI_STYLE(SCM_CDR(x)))
#define SCM_GUPPI_STYLE_P(x) (SCM_NIMP(x) && SCM_CAR(x) == guppi_style_type_tag)

gboolean
scm_guppi_style_p(SCM x)
{
    return SCM_GUPPI_STYLE_P(x);
} 

SCM
guppi_style2scm(GuppiStyle* x)
{
    SCM smob;
    if (x == NULL || !GUPPI_IS_STYLE(x))
	return SCM_UNSPECIFIED;
    SCM_DEFER_INTS;
#ifdef USING_GUILE_1_3_X
    SCM_NEWCELL(smob);
    SCM_SETCAR(smob, guppi_style_type_tag);
    SCM_SETCDR(smob, x);
#else
    SCM_NEWSMOB(smob, guppi_style_type_tag, x);
#endif
    guppi_ref(x);
    guppi_sink(x);
    SCM_ALLOW_INTS;

    return smob;
}

GuppiStyle*
scm2guppi_style(SCM x)
{
    g_return_val_if_fail(SCM_GUPPI_STYLE_P(x), NULL);
    return SCM_TO_GUPPI_STYLE(x);
}

static SCM
mark_guppi_style(SCM x)
{
    return SCM_BOOL_F;
}

static scm_sizet
free_guppi_style(SCM x)
{
    GuppiStyle* y = SCM_TO_GUPPI_STYLE(x);
    SCM_DEFER_INTS;
    guppi_unref(y);
    SCM_ALLOW_INTS;

    return 0;
}

static int
print_guppi_style(SCM x, SCM port, scm_print_state* state)
{
    scm_puts("<GuppiStyle>", port);
    return 1;
}

#ifdef USING_GUILE_1_3_X
static struct scm_smobfuns guppi_style_smob_fns = {
    mark_guppi_style, free_guppi_style, print_guppi_style, NULL
};
#endif

static SCM
fn_scm_guppi_style_p(SCM x)
{
    return gh_bool2scm(SCM_GUPPI_STYLE_P(x));
}



gboolean
scm_guppi_seq_style_p(SCM x)
{
  GuppiSeq* foo;
  if (scm_guppi_seq_p(x)) {
    foo = GUPPI_SEQ(scm2guppi_seq(x));
    if (foo != NULL && GUPPI_IS_SEQ_STYLE(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_seq_style2scm(GuppiSeqStyle* x)
{
  return guppi_seq2scm(GUPPI_SEQ(x));
}

GuppiSeqStyle*
scm2guppi_seq_style(SCM x)
{
  return GUPPI_SEQ_STYLE(scm2guppi_seq(x));    
}

static SCM
fn_scm_guppi_seq_style_p(SCM x)
{
  return gh_bool2scm(scm_guppi_seq_style_p(x));
}


static long guppi_color_gradient_type_tag;
#define SCM_TO_GUPPI_COLOR_GRADIENT(x) (GUPPI_COLOR_GRADIENT(SCM_CDR(x)))
#define SCM_GUPPI_COLOR_GRADIENT_P(x) (SCM_NIMP(x) && SCM_CAR(x) == guppi_color_gradient_type_tag)

gboolean
scm_guppi_color_gradient_p(SCM x)
{
    return SCM_GUPPI_COLOR_GRADIENT_P(x);
} 

SCM
guppi_color_gradient2scm(GuppiColorGradient* x)
{
    SCM smob;
    if (x == NULL || !GUPPI_IS_COLOR_GRADIENT(x))
	return SCM_UNSPECIFIED;
    SCM_DEFER_INTS;
#ifdef USING_GUILE_1_3_X
    SCM_NEWCELL(smob);
    SCM_SETCAR(smob, guppi_color_gradient_type_tag);
    SCM_SETCDR(smob, x);
#else
    SCM_NEWSMOB(smob, guppi_color_gradient_type_tag, x);
#endif
    guppi_ref(x);
    guppi_sink(x);
    SCM_ALLOW_INTS;

    return smob;
}

GuppiColorGradient*
scm2guppi_color_gradient(SCM x)
{
    g_return_val_if_fail(SCM_GUPPI_COLOR_GRADIENT_P(x), NULL);
    return SCM_TO_GUPPI_COLOR_GRADIENT(x);
}

static SCM
mark_guppi_color_gradient(SCM x)
{
    return SCM_BOOL_F;
}

static scm_sizet
free_guppi_color_gradient(SCM x)
{
    GuppiColorGradient* y = SCM_TO_GUPPI_COLOR_GRADIENT(x);
    SCM_DEFER_INTS;
    guppi_unref(y);
    SCM_ALLOW_INTS;

    return 0;
}

static int
print_guppi_color_gradient(SCM x, SCM port, scm_print_state* state)
{
    scm_puts("<GuppiColorGradient>", port);
    return 1;
}

#ifdef USING_GUILE_1_3_X
static struct scm_smobfuns guppi_color_gradient_smob_fns = {
    mark_guppi_color_gradient, free_guppi_color_gradient, print_guppi_color_gradient, NULL
};
#endif

static SCM
fn_scm_guppi_color_gradient_p(SCM x)
{
    return gh_bool2scm(SCM_GUPPI_COLOR_GRADIENT_P(x));
}


static long guppi_geometry_type_tag;
#define SCM_TO_GUPPI_GEOMETRY(x) (GUPPI_GEOMETRY(SCM_CDR(x)))
#define SCM_GUPPI_GEOMETRY_P(x) (SCM_NIMP(x) && SCM_CAR(x) == guppi_geometry_type_tag)

gboolean
scm_guppi_geometry_p(SCM x)
{
    return SCM_GUPPI_GEOMETRY_P(x);
} 

SCM
guppi_geometry2scm(GuppiGeometry* x)
{
    SCM smob;
    if (x == NULL || !GUPPI_IS_GEOMETRY(x))
	return SCM_UNSPECIFIED;
    SCM_DEFER_INTS;
#ifdef USING_GUILE_1_3_X
    SCM_NEWCELL(smob);
    SCM_SETCAR(smob, guppi_geometry_type_tag);
    SCM_SETCDR(smob, x);
#else
    SCM_NEWSMOB(smob, guppi_geometry_type_tag, x);
#endif
    guppi_ref(x);
    guppi_sink(x);
    SCM_ALLOW_INTS;

    return smob;
}

GuppiGeometry*
scm2guppi_geometry(SCM x)
{
    g_return_val_if_fail(SCM_GUPPI_GEOMETRY_P(x), NULL);
    return SCM_TO_GUPPI_GEOMETRY(x);
}

static SCM
mark_guppi_geometry(SCM x)
{
    return SCM_BOOL_F;
}

static scm_sizet
free_guppi_geometry(SCM x)
{
    GuppiGeometry* y = SCM_TO_GUPPI_GEOMETRY(x);
    SCM_DEFER_INTS;
    guppi_unref(y);
    SCM_ALLOW_INTS;

    return 0;
}

static int
print_guppi_geometry(SCM x, SCM port, scm_print_state* state)
{
    scm_puts("<GuppiGeometry>", port);
    return 1;
}

#ifdef USING_GUILE_1_3_X
static struct scm_smobfuns guppi_geometry_smob_fns = {
    mark_guppi_geometry, free_guppi_geometry, print_guppi_geometry, NULL
};
#endif

static SCM
fn_scm_guppi_geometry_p(SCM x)
{
    return gh_bool2scm(SCM_GUPPI_GEOMETRY_P(x));
}


static long guppi_layout_type_tag;
#define SCM_TO_GUPPI_LAYOUT(x) (GUPPI_LAYOUT(SCM_CDR(x)))
#define SCM_GUPPI_LAYOUT_P(x) (SCM_NIMP(x) && SCM_CAR(x) == guppi_layout_type_tag)

gboolean
scm_guppi_layout_p(SCM x)
{
    return SCM_GUPPI_LAYOUT_P(x);
} 

SCM
guppi_layout2scm(GuppiLayout* x)
{
    SCM smob;
    if (x == NULL || !GUPPI_IS_LAYOUT(x))
	return SCM_UNSPECIFIED;
    SCM_DEFER_INTS;
#ifdef USING_GUILE_1_3_X
    SCM_NEWCELL(smob);
    SCM_SETCAR(smob, guppi_layout_type_tag);
    SCM_SETCDR(smob, x);
#else
    SCM_NEWSMOB(smob, guppi_layout_type_tag, x);
#endif
    guppi_ref(x);
    guppi_sink(x);
    SCM_ALLOW_INTS;

    return smob;
}

GuppiLayout*
scm2guppi_layout(SCM x)
{
    g_return_val_if_fail(SCM_GUPPI_LAYOUT_P(x), NULL);
    return SCM_TO_GUPPI_LAYOUT(x);
}

static SCM
mark_guppi_layout(SCM x)
{
    return SCM_BOOL_F;
}

static scm_sizet
free_guppi_layout(SCM x)
{
    GuppiLayout* y = SCM_TO_GUPPI_LAYOUT(x);
    SCM_DEFER_INTS;
    guppi_unref(y);
    SCM_ALLOW_INTS;

    return 0;
}

static int
print_guppi_layout(SCM x, SCM port, scm_print_state* state)
{
    scm_puts("<GuppiLayout>", port);
    return 1;
}

#ifdef USING_GUILE_1_3_X
static struct scm_smobfuns guppi_layout_smob_fns = {
    mark_guppi_layout, free_guppi_layout, print_guppi_layout, NULL
};
#endif

static SCM
fn_scm_guppi_layout_p(SCM x)
{
    return gh_bool2scm(SCM_GUPPI_LAYOUT_P(x));
}


static long guppi_element_state_type_tag;
#define SCM_TO_GUPPI_ELEMENT_STATE(x) (GUPPI_ELEMENT_STATE(SCM_CDR(x)))
#define SCM_GUPPI_ELEMENT_STATE_P(x) (SCM_NIMP(x) && SCM_CAR(x) == guppi_element_state_type_tag)

gboolean
scm_guppi_element_state_p(SCM x)
{
    return SCM_GUPPI_ELEMENT_STATE_P(x);
} 

SCM
guppi_element_state2scm(GuppiElementState* x)
{
    SCM smob;
    if (x == NULL || !GUPPI_IS_ELEMENT_STATE(x))
	return SCM_UNSPECIFIED;
    SCM_DEFER_INTS;
#ifdef USING_GUILE_1_3_X
    SCM_NEWCELL(smob);
    SCM_SETCAR(smob, guppi_element_state_type_tag);
    SCM_SETCDR(smob, x);
#else
    SCM_NEWSMOB(smob, guppi_element_state_type_tag, x);
#endif
    guppi_ref(x);
    guppi_sink(x);
    SCM_ALLOW_INTS;

    return smob;
}

GuppiElementState*
scm2guppi_element_state(SCM x)
{
    g_return_val_if_fail(SCM_GUPPI_ELEMENT_STATE_P(x), NULL);
    return SCM_TO_GUPPI_ELEMENT_STATE(x);
}

static SCM
mark_guppi_element_state(SCM x)
{
    return SCM_BOOL_F;
}

static scm_sizet
free_guppi_element_state(SCM x)
{
    GuppiElementState* y = SCM_TO_GUPPI_ELEMENT_STATE(x);
    SCM_DEFER_INTS;
    guppi_unref(y);
    SCM_ALLOW_INTS;

    return 0;
}

static int
print_guppi_element_state(SCM x, SCM port, scm_print_state* state)
{
    scm_puts("<GuppiElementState>", port);
    return 1;
}

#ifdef USING_GUILE_1_3_X
static struct scm_smobfuns guppi_element_state_smob_fns = {
    mark_guppi_element_state, free_guppi_element_state, print_guppi_element_state, NULL
};
#endif

static SCM
fn_scm_guppi_element_state_p(SCM x)
{
    return gh_bool2scm(SCM_GUPPI_ELEMENT_STATE_P(x));
}


static long guppi_element_view_type_tag;
#define SCM_TO_GUPPI_ELEMENT_VIEW(x) (GUPPI_ELEMENT_VIEW(SCM_CDR(x)))
#define SCM_GUPPI_ELEMENT_VIEW_P(x) (SCM_NIMP(x) && SCM_CAR(x) == guppi_element_view_type_tag)

gboolean
scm_guppi_element_view_p(SCM x)
{
    return SCM_GUPPI_ELEMENT_VIEW_P(x);
} 

SCM
guppi_element_view2scm(GuppiElementView* x)
{
    SCM smob;
    if (x == NULL || !GUPPI_IS_ELEMENT_VIEW(x))
	return SCM_UNSPECIFIED;
    SCM_DEFER_INTS;
#ifdef USING_GUILE_1_3_X
    SCM_NEWCELL(smob);
    SCM_SETCAR(smob, guppi_element_view_type_tag);
    SCM_SETCDR(smob, x);
#else
    SCM_NEWSMOB(smob, guppi_element_view_type_tag, x);
#endif
    guppi_ref(x);
    guppi_sink(x);
    SCM_ALLOW_INTS;

    return smob;
}

GuppiElementView*
scm2guppi_element_view(SCM x)
{
    g_return_val_if_fail(SCM_GUPPI_ELEMENT_VIEW_P(x), NULL);
    return SCM_TO_GUPPI_ELEMENT_VIEW(x);
}

static SCM
mark_guppi_element_view(SCM x)
{
    return SCM_BOOL_F;
}

static scm_sizet
free_guppi_element_view(SCM x)
{
    GuppiElementView* y = SCM_TO_GUPPI_ELEMENT_VIEW(x);
    SCM_DEFER_INTS;
    guppi_unref(y);
    SCM_ALLOW_INTS;

    return 0;
}

static int
print_guppi_element_view(SCM x, SCM port, scm_print_state* state)
{
    scm_puts("<GuppiElementView>", port);
    return 1;
}

#ifdef USING_GUILE_1_3_X
static struct scm_smobfuns guppi_element_view_smob_fns = {
    mark_guppi_element_view, free_guppi_element_view, print_guppi_element_view, NULL
};
#endif

static SCM
fn_scm_guppi_element_view_p(SCM x)
{
    return gh_bool2scm(SCM_GUPPI_ELEMENT_VIEW_P(x));
}



gboolean
scm_guppi_group_state_p(SCM x)
{
  GuppiElementState* foo;
  if (scm_guppi_element_state_p(x)) {
    foo = GUPPI_ELEMENT_STATE(scm2guppi_element_state(x));
    if (foo != NULL && GUPPI_IS_GROUP_STATE(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_group_state2scm(GuppiGroupState* x)
{
  return guppi_element_state2scm(GUPPI_ELEMENT_STATE(x));
}

GuppiGroupState*
scm2guppi_group_state(SCM x)
{
  return GUPPI_GROUP_STATE(scm2guppi_element_state(x));    
}

static SCM
fn_scm_guppi_group_state_p(SCM x)
{
  return gh_bool2scm(scm_guppi_group_state_p(x));
}



gboolean
scm_guppi_group_view_p(SCM x)
{
  GuppiElementView* foo;
  if (scm_guppi_element_view_p(x)) {
    foo = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(x));
    if (foo != NULL && GUPPI_IS_GROUP_VIEW(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_group_view2scm(GuppiGroupView* x)
{
  return guppi_element_view2scm(GUPPI_ELEMENT_VIEW(x));
}

GuppiGroupView*
scm2guppi_group_view(SCM x)
{
  return GUPPI_GROUP_VIEW(scm2guppi_element_view(x));    
}

static SCM
fn_scm_guppi_group_view_p(SCM x)
{
  return gh_bool2scm(scm_guppi_group_view_p(x));
}



gboolean
scm_guppi_root_group_state_p(SCM x)
{
  GuppiGroupState* foo;
  if (scm_guppi_group_state_p(x)) {
    foo = GUPPI_GROUP_STATE(scm2guppi_group_state(x));
    if (foo != NULL && GUPPI_IS_ROOT_GROUP_STATE(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_root_group_state2scm(GuppiRootGroupState* x)
{
  return guppi_group_state2scm(GUPPI_GROUP_STATE(x));
}

GuppiRootGroupState*
scm2guppi_root_group_state(SCM x)
{
  return GUPPI_ROOT_GROUP_STATE(scm2guppi_group_state(x));    
}

static SCM
fn_scm_guppi_root_group_state_p(SCM x)
{
  return gh_bool2scm(scm_guppi_root_group_state_p(x));
}



gboolean
scm_guppi_root_group_view_p(SCM x)
{
  GuppiGroupView* foo;
  if (scm_guppi_group_view_p(x)) {
    foo = GUPPI_GROUP_VIEW(scm2guppi_group_view(x));
    if (foo != NULL && GUPPI_IS_ROOT_GROUP_VIEW(foo))
      return TRUE;
  }
  return FALSE;
}

SCM
guppi_root_group_view2scm(GuppiRootGroupView* x)
{
  return guppi_group_view2scm(GUPPI_GROUP_VIEW(x));
}

GuppiRootGroupView*
scm2guppi_root_group_view(SCM x)
{
  return GUPPI_ROOT_GROUP_VIEW(scm2guppi_group_view(x));    
}

static SCM
fn_scm_guppi_root_group_view_p(SCM x)
{
  return gh_bool2scm(scm_guppi_root_group_view_p(x));
}


static const gchar* s_scm_guppi_style_new = "guppi-style-new";
static SCM
fn_scm_guppi_style_new()
{
  GuppiStyle* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_style_new();
  s_retval = guppi_style2scm(GUPPI_STYLE(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_style_stock = "guppi-style-stock";
static SCM
fn_scm_guppi_style_stock(SCM s_i, SCM s_which_collection)
{
  gint c_i;
  double c_which_collection;
  GuppiStyle* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(gh_exact_p(s_i), s_i, SCM_ARG1, (gchar*)s_scm_guppi_style_stock);
  SCM_ASSERT(gh_number_p(s_which_collection), s_which_collection, SCM_ARG2, (gchar*)s_scm_guppi_style_stock);
  c_i = gh_scm2int(s_i);
  c_which_collection = gh_scm2double(s_which_collection);
  c_retval = guppi_style_stock(c_i, c_which_collection);
  s_retval = guppi_style2scm(GUPPI_STYLE(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_style_marker_size1 = "guppi-style-marker-size1";
static SCM
fn_scm_guppi_style_marker_size1(SCM s_s)
{
  GuppiStyle* c_s;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_marker_size1);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_retval = guppi_style_marker_size1(c_s);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_style_marker_size2 = "guppi-style-marker-size2";
static SCM
fn_scm_guppi_style_marker_size2(SCM s_s)
{
  GuppiStyle* c_s;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_marker_size2);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_retval = guppi_style_marker_size2(c_s);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_style_color = "guppi-style-color";
static SCM
fn_scm_guppi_style_color(SCM s_s)
{
  GuppiStyle* c_s;
  guint32 c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_color);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_retval = guppi_style_color(c_s);
  s_retval = color2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_style_color_dim = "guppi-style-color-dim";
static SCM
fn_scm_guppi_style_color_dim(SCM s_s)
{
  GuppiStyle* c_s;
  guint32 c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_color_dim);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_retval = guppi_style_color_dim(c_s);
  s_retval = color2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_style_color_bright = "guppi-style-color-bright";
static SCM
fn_scm_guppi_style_color_bright(SCM s_s)
{
  GuppiStyle* c_s;
  guint32 c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_color_bright);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_retval = guppi_style_color_bright(c_s);
  s_retval = color2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_style_line_width = "guppi-style-line-width";
static SCM
fn_scm_guppi_style_line_width(SCM s_s)
{
  GuppiStyle* c_s;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_line_width);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_retval = guppi_style_line_width(c_s);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_style_set_marker_size1 = "guppi-style-set-marker-size1";
static SCM
fn_scm_guppi_style_set_marker_size1(SCM s_s, SCM s_x)
{
  GuppiStyle* c_s;
  double c_x;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_set_marker_size1);
  SCM_ASSERT(gh_number_p(s_x), s_x, SCM_ARG2, (gchar*)s_scm_guppi_style_set_marker_size1);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_x = gh_scm2double(s_x);
  guppi_style_set_marker_size1(c_s, c_x);
  return s_retval;
}

static const gchar* s_scm_guppi_style_set_marker_size2 = "guppi-style-set-marker-size2";
static SCM
fn_scm_guppi_style_set_marker_size2(SCM s_s, SCM s_x)
{
  GuppiStyle* c_s;
  double c_x;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_set_marker_size2);
  SCM_ASSERT(gh_number_p(s_x), s_x, SCM_ARG2, (gchar*)s_scm_guppi_style_set_marker_size2);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_x = gh_scm2double(s_x);
  guppi_style_set_marker_size2(c_s, c_x);
  return s_retval;
}

static const gchar* s_scm_guppi_style_set_color = "guppi-style-set-color";
static SCM
fn_scm_guppi_style_set_color(SCM s_s, SCM s_x)
{
  GuppiStyle* c_s;
  guint32 c_x;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_set_color);
  SCM_ASSERT(scm_color_p(s_x), s_x, SCM_ARG2, (gchar*)s_scm_guppi_style_set_color);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_x = scm2color(s_x);
  guppi_style_set_color(c_s, c_x);
  return s_retval;
}

static const gchar* s_scm_guppi_style_set_color_dim = "guppi-style-set-color-dim";
static SCM
fn_scm_guppi_style_set_color_dim(SCM s_s, SCM s_x)
{
  GuppiStyle* c_s;
  guint32 c_x;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_set_color_dim);
  SCM_ASSERT(scm_color_p(s_x), s_x, SCM_ARG2, (gchar*)s_scm_guppi_style_set_color_dim);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_x = scm2color(s_x);
  guppi_style_set_color_dim(c_s, c_x);
  return s_retval;
}

static const gchar* s_scm_guppi_style_set_color_bright = "guppi-style-set-color-bright";
static SCM
fn_scm_guppi_style_set_color_bright(SCM s_s, SCM s_x)
{
  GuppiStyle* c_s;
  guint32 c_x;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_set_color_bright);
  SCM_ASSERT(scm_color_p(s_x), s_x, SCM_ARG2, (gchar*)s_scm_guppi_style_set_color_bright);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_x = scm2color(s_x);
  guppi_style_set_color_bright(c_s, c_x);
  return s_retval;
}

static const gchar* s_scm_guppi_style_set_line_width = "guppi-style-set-line-width";
static SCM
fn_scm_guppi_style_set_line_width(SCM s_s, SCM s_x)
{
  GuppiStyle* c_s;
  double c_x;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_set_line_width);
  SCM_ASSERT(gh_number_p(s_x), s_x, SCM_ARG2, (gchar*)s_scm_guppi_style_set_line_width);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  c_x = gh_scm2double(s_x);
  guppi_style_set_line_width(c_s, c_x);
  return s_retval;
}

static const gchar* s_scm_guppi_style_freeze = "guppi-style-freeze";
static SCM
fn_scm_guppi_style_freeze(SCM s_s)
{
  GuppiStyle* c_s;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_freeze);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  guppi_style_freeze(c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_style_thaw = "guppi-style-thaw";
static SCM
fn_scm_guppi_style_thaw(SCM s_s)
{
  GuppiStyle* c_s;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_thaw);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  guppi_style_thaw(c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_style_changed = "guppi-style-changed";
static SCM
fn_scm_guppi_style_changed(SCM s_s)
{
  GuppiStyle* c_s;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_changed);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  guppi_style_changed(c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_style_changed_delayed = "guppi-style-changed-delayed";
static SCM
fn_scm_guppi_style_changed_delayed(SCM s_s)
{
  GuppiStyle* c_s;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_changed_delayed);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  guppi_style_changed_delayed(c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_style_flush_changes = "guppi-style-flush-changes";
static SCM
fn_scm_guppi_style_flush_changes(SCM s_s)
{
  GuppiStyle* c_s;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_flush_changes);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  guppi_style_flush_changes(c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_style_edit_window = "guppi-style-edit-window";
static SCM
fn_scm_guppi_style_edit_window(SCM s_s)
{
  GuppiStyle* c_s;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_style_p(s_s), s_s, SCM_ARG1, (gchar*)s_scm_guppi_style_edit_window);
  c_s = GUPPI_STYLE(scm2guppi_style(s_s));
  guppi_style_edit_window(c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_style_new = "guppi-seq-style-new";
static SCM
fn_scm_guppi_seq_style_new()
{
  GuppiData* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_seq_style_new();
  s_retval = guppi_data2scm(GUPPI_DATA(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_seq_style_get = "guppi-seq-style-get";
static SCM
fn_scm_guppi_seq_style_get(SCM s_seq, SCM s_i)
{
  GuppiSeqStyle* c_seq;
  gint c_i;
  GuppiStyle* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_style_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_style_get);
  SCM_ASSERT(gh_exact_p(s_i), s_i, SCM_ARG2, (gchar*)s_scm_guppi_seq_style_get);
  c_seq = GUPPI_SEQ_STYLE(scm2guppi_seq_style(s_seq));
  c_i = gh_scm2int(s_i);
  c_retval = guppi_seq_style_get(c_seq, c_i);
  s_retval = guppi_style2scm(GUPPI_STYLE(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_seq_style_set = "guppi-seq-style-set";
static SCM
fn_scm_guppi_seq_style_set(SCM s_seq, SCM s_i, SCM s_sty)
{
  GuppiSeqStyle* c_seq;
  gint c_i;
  GuppiStyle* c_sty;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_style_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_style_set);
  SCM_ASSERT(gh_exact_p(s_i), s_i, SCM_ARG2, (gchar*)s_scm_guppi_seq_style_set);
  SCM_ASSERT(scm_guppi_style_p(s_sty), s_sty, SCM_ARG3, (gchar*)s_scm_guppi_seq_style_set);
  c_seq = GUPPI_SEQ_STYLE(scm2guppi_seq_style(s_seq));
  c_i = gh_scm2int(s_i);
  c_sty = GUPPI_STYLE(scm2guppi_style(s_sty));
  guppi_seq_style_set(c_seq, c_i, c_sty);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_style_prepend = "guppi-seq-style-prepend";
static SCM
fn_scm_guppi_seq_style_prepend(SCM s_seq, SCM s_sty)
{
  GuppiSeqStyle* c_seq;
  GuppiStyle* c_sty;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_style_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_style_prepend);
  SCM_ASSERT(scm_guppi_style_p(s_sty), s_sty, SCM_ARG2, (gchar*)s_scm_guppi_seq_style_prepend);
  c_seq = GUPPI_SEQ_STYLE(scm2guppi_seq_style(s_seq));
  c_sty = GUPPI_STYLE(scm2guppi_style(s_sty));
  guppi_seq_style_prepend(c_seq, c_sty);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_style_append = "guppi-seq-style-append";
static SCM
fn_scm_guppi_seq_style_append(SCM s_seq, SCM s_sty)
{
  GuppiSeqStyle* c_seq;
  GuppiStyle* c_sty;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_style_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_style_append);
  SCM_ASSERT(scm_guppi_style_p(s_sty), s_sty, SCM_ARG2, (gchar*)s_scm_guppi_seq_style_append);
  c_seq = GUPPI_SEQ_STYLE(scm2guppi_seq_style(s_seq));
  c_sty = GUPPI_STYLE(scm2guppi_style(s_sty));
  guppi_seq_style_append(c_seq, c_sty);
  return s_retval;
}

static const gchar* s_scm_guppi_seq_style_insert = "guppi-seq-style-insert";
static SCM
fn_scm_guppi_seq_style_insert(SCM s_seq, SCM s_i, SCM s_sty)
{
  GuppiSeqStyle* c_seq;
  gint c_i;
  GuppiStyle* c_sty;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_seq_style_p(s_seq), s_seq, SCM_ARG1, (gchar*)s_scm_guppi_seq_style_insert);
  SCM_ASSERT(gh_exact_p(s_i), s_i, SCM_ARG2, (gchar*)s_scm_guppi_seq_style_insert);
  SCM_ASSERT(scm_guppi_style_p(s_sty), s_sty, SCM_ARG3, (gchar*)s_scm_guppi_seq_style_insert);
  c_seq = GUPPI_SEQ_STYLE(scm2guppi_seq_style(s_seq));
  c_i = gh_scm2int(s_i);
  c_sty = GUPPI_STYLE(scm2guppi_style(s_sty));
  guppi_seq_style_insert(c_seq, c_i, c_sty);
  return s_retval;
}

static const gchar* s_scm_guppi_color_gradient_new = "guppi-color-gradient-new";
static SCM
fn_scm_guppi_color_gradient_new()
{
  GuppiColorGradient* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_color_gradient_new();
  s_retval = guppi_color_gradient2scm(GUPPI_COLOR_GRADIENT(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_color_gradient_value = "guppi-color-gradient-value";
static SCM
fn_scm_guppi_color_gradient_value(SCM s_cg, SCM s_t)
{
  GuppiColorGradient* c_cg;
  double c_t;
  guint32 c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_color_gradient_p(s_cg), s_cg, SCM_ARG1, (gchar*)s_scm_guppi_color_gradient_value);
  SCM_ASSERT(gh_number_p(s_t), s_t, SCM_ARG2, (gchar*)s_scm_guppi_color_gradient_value);
  c_cg = GUPPI_COLOR_GRADIENT(scm2guppi_color_gradient(s_cg));
  c_t = gh_scm2double(s_t);
  c_retval = guppi_color_gradient_value(c_cg, c_t);
  s_retval = color2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_color_gradient_set2 = "guppi-color-gradient-set2";
static SCM
fn_scm_guppi_color_gradient_set2(SCM s_cg, SCM s_x, SCM s_y)
{
  GuppiColorGradient* c_cg;
  guint32 c_x;
  guint32 c_y;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_color_gradient_p(s_cg), s_cg, SCM_ARG1, (gchar*)s_scm_guppi_color_gradient_set2);
  SCM_ASSERT(scm_color_p(s_x), s_x, SCM_ARG2, (gchar*)s_scm_guppi_color_gradient_set2);
  SCM_ASSERT(scm_color_p(s_y), s_y, SCM_ARG3, (gchar*)s_scm_guppi_color_gradient_set2);
  c_cg = GUPPI_COLOR_GRADIENT(scm2guppi_color_gradient(s_cg));
  c_x = scm2color(s_x);
  c_y = scm2color(s_y);
  guppi_color_gradient_set2(c_cg, c_x, c_y);
  return s_retval;
}

static const gchar* s_scm_guppi_color_gradient_set_fade_in = "guppi-color-gradient-set-fade-in";
static SCM
fn_scm_guppi_color_gradient_set_fade_in(SCM s_cg, SCM s_x)
{
  GuppiColorGradient* c_cg;
  guint32 c_x;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_color_gradient_p(s_cg), s_cg, SCM_ARG1, (gchar*)s_scm_guppi_color_gradient_set_fade_in);
  SCM_ASSERT(scm_color_p(s_x), s_x, SCM_ARG2, (gchar*)s_scm_guppi_color_gradient_set_fade_in);
  c_cg = GUPPI_COLOR_GRADIENT(scm2guppi_color_gradient(s_cg));
  c_x = scm2color(s_x);
  guppi_color_gradient_set_fade_in(c_cg, c_x);
  return s_retval;
}

static const gchar* s_scm_guppi_color_gradient_set_fade_out = "guppi-color-gradient-set-fade-out";
static SCM
fn_scm_guppi_color_gradient_set_fade_out(SCM s_cg, SCM s_x)
{
  GuppiColorGradient* c_cg;
  guint32 c_x;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_color_gradient_p(s_cg), s_cg, SCM_ARG1, (gchar*)s_scm_guppi_color_gradient_set_fade_out);
  SCM_ASSERT(scm_color_p(s_x), s_x, SCM_ARG2, (gchar*)s_scm_guppi_color_gradient_set_fade_out);
  c_cg = GUPPI_COLOR_GRADIENT(scm2guppi_color_gradient(s_cg));
  c_x = scm2color(s_x);
  guppi_color_gradient_set_fade_out(c_cg, c_x);
  return s_retval;
}

static const gchar* s_scm_guppi_color_gradient_set_fire = "guppi-color-gradient-set-fire";
static SCM
fn_scm_guppi_color_gradient_set_fire(SCM s_cg, SCM s_v, SCM s_a)
{
  GuppiColorGradient* c_cg;
  double c_v;
  double c_a;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_color_gradient_p(s_cg), s_cg, SCM_ARG1, (gchar*)s_scm_guppi_color_gradient_set_fire);
  SCM_ASSERT(gh_number_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_color_gradient_set_fire);
  SCM_ASSERT(gh_number_p(s_a), s_a, SCM_ARG3, (gchar*)s_scm_guppi_color_gradient_set_fire);
  c_cg = GUPPI_COLOR_GRADIENT(scm2guppi_color_gradient(s_cg));
  c_v = gh_scm2double(s_v);
  c_a = gh_scm2double(s_a);
  guppi_color_gradient_set_fire(c_cg, c_v, c_a);
  return s_retval;
}

static const gchar* s_scm_guppi_color_gradient_set_ice = "guppi-color-gradient-set-ice";
static SCM
fn_scm_guppi_color_gradient_set_ice(SCM s_cg, SCM s_v, SCM s_a)
{
  GuppiColorGradient* c_cg;
  double c_v;
  double c_a;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_color_gradient_p(s_cg), s_cg, SCM_ARG1, (gchar*)s_scm_guppi_color_gradient_set_ice);
  SCM_ASSERT(gh_number_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_color_gradient_set_ice);
  SCM_ASSERT(gh_number_p(s_a), s_a, SCM_ARG3, (gchar*)s_scm_guppi_color_gradient_set_ice);
  c_cg = GUPPI_COLOR_GRADIENT(scm2guppi_color_gradient(s_cg));
  c_v = gh_scm2double(s_v);
  c_a = gh_scm2double(s_a);
  guppi_color_gradient_set_ice(c_cg, c_v, c_a);
  return s_retval;
}

static const gchar* s_scm_guppi_color_gradient_set_thermal = "guppi-color-gradient-set-thermal";
static SCM
fn_scm_guppi_color_gradient_set_thermal(SCM s_cg, SCM s_v, SCM s_a)
{
  GuppiColorGradient* c_cg;
  double c_v;
  double c_a;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_color_gradient_p(s_cg), s_cg, SCM_ARG1, (gchar*)s_scm_guppi_color_gradient_set_thermal);
  SCM_ASSERT(gh_number_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_color_gradient_set_thermal);
  SCM_ASSERT(gh_number_p(s_a), s_a, SCM_ARG3, (gchar*)s_scm_guppi_color_gradient_set_thermal);
  c_cg = GUPPI_COLOR_GRADIENT(scm2guppi_color_gradient(s_cg));
  c_v = gh_scm2double(s_v);
  c_a = gh_scm2double(s_a);
  guppi_color_gradient_set_thermal(c_cg, c_v, c_a);
  return s_retval;
}

static const gchar* s_scm_guppi_color_gradient_set_spectrum = "guppi-color-gradient-set-spectrum";
static SCM
fn_scm_guppi_color_gradient_set_spectrum(SCM s_cg, SCM s_v, SCM s_a)
{
  GuppiColorGradient* c_cg;
  double c_v;
  double c_a;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_color_gradient_p(s_cg), s_cg, SCM_ARG1, (gchar*)s_scm_guppi_color_gradient_set_spectrum);
  SCM_ASSERT(gh_number_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_color_gradient_set_spectrum);
  SCM_ASSERT(gh_number_p(s_a), s_a, SCM_ARG3, (gchar*)s_scm_guppi_color_gradient_set_spectrum);
  c_cg = GUPPI_COLOR_GRADIENT(scm2guppi_color_gradient(s_cg));
  c_v = gh_scm2double(s_v);
  c_a = gh_scm2double(s_a);
  guppi_color_gradient_set_spectrum(c_cg, c_v, c_a);
  return s_retval;
}

static const gchar* s_scm_guppi_geometry_new = "guppi-geometry-new";
static SCM
fn_scm_guppi_geometry_new()
{
  GuppiGeometry* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_geometry_new();
  s_retval = guppi_geometry2scm(GUPPI_GEOMETRY(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_geometry_left = "guppi-geometry-left";
static SCM
fn_scm_guppi_geometry_left(SCM s_g)
{
  GuppiGeometry* c_g;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_geometry_p(s_g), s_g, SCM_ARG1, (gchar*)s_scm_guppi_geometry_left);
  c_g = GUPPI_GEOMETRY(scm2guppi_geometry(s_g));
  c_retval = guppi_geometry_left(c_g);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_geometry_right = "guppi-geometry-right";
static SCM
fn_scm_guppi_geometry_right(SCM s_g)
{
  GuppiGeometry* c_g;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_geometry_p(s_g), s_g, SCM_ARG1, (gchar*)s_scm_guppi_geometry_right);
  c_g = GUPPI_GEOMETRY(scm2guppi_geometry(s_g));
  c_retval = guppi_geometry_right(c_g);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_geometry_top = "guppi-geometry-top";
static SCM
fn_scm_guppi_geometry_top(SCM s_g)
{
  GuppiGeometry* c_g;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_geometry_p(s_g), s_g, SCM_ARG1, (gchar*)s_scm_guppi_geometry_top);
  c_g = GUPPI_GEOMETRY(scm2guppi_geometry(s_g));
  c_retval = guppi_geometry_top(c_g);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_geometry_bottom = "guppi-geometry-bottom";
static SCM
fn_scm_guppi_geometry_bottom(SCM s_g)
{
  GuppiGeometry* c_g;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_geometry_p(s_g), s_g, SCM_ARG1, (gchar*)s_scm_guppi_geometry_bottom);
  c_g = GUPPI_GEOMETRY(scm2guppi_geometry(s_g));
  c_retval = guppi_geometry_bottom(c_g);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_geometry_set_position = "guppi-geometry-set-position";
static SCM
fn_scm_guppi_geometry_set_position(SCM s_g, SCM s_l, SCM s_r, SCM s_t, SCM s_b)
{
  GuppiGeometry* c_g;
  double c_l;
  double c_r;
  double c_t;
  double c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_geometry_p(s_g), s_g, SCM_ARG1, (gchar*)s_scm_guppi_geometry_set_position);
  SCM_ASSERT(gh_number_p(s_l), s_l, SCM_ARG2, (gchar*)s_scm_guppi_geometry_set_position);
  SCM_ASSERT(gh_number_p(s_r), s_r, SCM_ARG3, (gchar*)s_scm_guppi_geometry_set_position);
  SCM_ASSERT(gh_number_p(s_t), s_t, SCM_ARG4, (gchar*)s_scm_guppi_geometry_set_position);
  SCM_ASSERT(gh_number_p(s_b), s_b, SCM_ARG5, (gchar*)s_scm_guppi_geometry_set_position);
  c_g = GUPPI_GEOMETRY(scm2guppi_geometry(s_g));
  c_l = gh_scm2double(s_l);
  c_r = gh_scm2double(s_r);
  c_t = gh_scm2double(s_t);
  c_b = gh_scm2double(s_b);
  guppi_geometry_set_position(c_g, c_l, c_r, c_t, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_geometry_natural_width = "guppi-geometry-natural-width";
static SCM
fn_scm_guppi_geometry_natural_width(SCM s_g)
{
  GuppiGeometry* c_g;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_geometry_p(s_g), s_g, SCM_ARG1, (gchar*)s_scm_guppi_geometry_natural_width);
  c_g = GUPPI_GEOMETRY(scm2guppi_geometry(s_g));
  c_retval = guppi_geometry_natural_width(c_g);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_geometry_natural_height = "guppi-geometry-natural-height";
static SCM
fn_scm_guppi_geometry_natural_height(SCM s_g)
{
  GuppiGeometry* c_g;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_geometry_p(s_g), s_g, SCM_ARG1, (gchar*)s_scm_guppi_geometry_natural_height);
  c_g = GUPPI_GEOMETRY(scm2guppi_geometry(s_g));
  c_retval = guppi_geometry_natural_height(c_g);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_geometry_calc_natural_size = "guppi-geometry-calc-natural-size";
static SCM
fn_scm_guppi_geometry_calc_natural_size(SCM s_g)
{
  GuppiGeometry* c_g;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_geometry_p(s_g), s_g, SCM_ARG1, (gchar*)s_scm_guppi_geometry_calc_natural_size);
  c_g = GUPPI_GEOMETRY(scm2guppi_geometry(s_g));
  guppi_geometry_calc_natural_size(c_g);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_new = "guppi-layout-new";
static SCM
fn_scm_guppi_layout_new()
{
  GuppiLayout* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_layout_new();
  s_retval = guppi_layout2scm(GUPPI_LAYOUT(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_layout_natural_width = "guppi-layout-natural-width";
static SCM
fn_scm_guppi_layout_natural_width(SCM s_lay, SCM s_geom)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_natural_width);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_natural_width);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  guppi_layout_natural_width(c_lay, c_geom);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_natural_height = "guppi-layout-natural-height";
static SCM
fn_scm_guppi_layout_natural_height(SCM s_lay, SCM s_geom)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_natural_height);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_natural_height);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  guppi_layout_natural_height(c_lay, c_geom);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_left_edge_relative = "guppi-layout-left-edge-relative";
static SCM
fn_scm_guppi_layout_left_edge_relative(SCM s_lay, SCM s_geom, SCM s_percentage)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_left_edge_relative);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_left_edge_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_layout_left_edge_relative);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_percentage = gh_scm2double(s_percentage);
  guppi_layout_left_edge_relative(c_lay, c_geom, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_right_edge_relative = "guppi-layout-right-edge-relative";
static SCM
fn_scm_guppi_layout_right_edge_relative(SCM s_lay, SCM s_geom, SCM s_percentage)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_right_edge_relative);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_right_edge_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_layout_right_edge_relative);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_percentage = gh_scm2double(s_percentage);
  guppi_layout_right_edge_relative(c_lay, c_geom, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_top_edge_relative = "guppi-layout-top-edge-relative";
static SCM
fn_scm_guppi_layout_top_edge_relative(SCM s_lay, SCM s_geom, SCM s_percentage)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_top_edge_relative);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_top_edge_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_layout_top_edge_relative);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_percentage = gh_scm2double(s_percentage);
  guppi_layout_top_edge_relative(c_lay, c_geom, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_bottom_edge_relative = "guppi-layout-bottom-edge-relative";
static SCM
fn_scm_guppi_layout_bottom_edge_relative(SCM s_lay, SCM s_geom, SCM s_percentage)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_bottom_edge_relative);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_bottom_edge_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_layout_bottom_edge_relative);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_percentage = gh_scm2double(s_percentage);
  guppi_layout_bottom_edge_relative(c_lay, c_geom, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_flush_left = "guppi-layout-flush-left";
static SCM
fn_scm_guppi_layout_flush_left(SCM s_lay, SCM s_geom, SCM s_margin)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_flush_left);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_flush_left);
  SCM_ASSERT(gh_number_p(s_margin), s_margin, SCM_ARG3, (gchar*)s_scm_guppi_layout_flush_left);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_margin = gh_scm2double(s_margin);
  guppi_layout_flush_left(c_lay, c_geom, c_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_flush_right = "guppi-layout-flush-right";
static SCM
fn_scm_guppi_layout_flush_right(SCM s_lay, SCM s_geom, SCM s_margin)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_flush_right);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_flush_right);
  SCM_ASSERT(gh_number_p(s_margin), s_margin, SCM_ARG3, (gchar*)s_scm_guppi_layout_flush_right);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_margin = gh_scm2double(s_margin);
  guppi_layout_flush_right(c_lay, c_geom, c_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_flush_top = "guppi-layout-flush-top";
static SCM
fn_scm_guppi_layout_flush_top(SCM s_lay, SCM s_geom, SCM s_margin)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_flush_top);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_flush_top);
  SCM_ASSERT(gh_number_p(s_margin), s_margin, SCM_ARG3, (gchar*)s_scm_guppi_layout_flush_top);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_margin = gh_scm2double(s_margin);
  guppi_layout_flush_top(c_lay, c_geom, c_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_flush_bottom = "guppi-layout-flush-bottom";
static SCM
fn_scm_guppi_layout_flush_bottom(SCM s_lay, SCM s_geom, SCM s_margin)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_flush_bottom);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_flush_bottom);
  SCM_ASSERT(gh_number_p(s_margin), s_margin, SCM_ARG3, (gchar*)s_scm_guppi_layout_flush_bottom);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_margin = gh_scm2double(s_margin);
  guppi_layout_flush_bottom(c_lay, c_geom, c_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_width_relative = "guppi-layout-width-relative";
static SCM
fn_scm_guppi_layout_width_relative(SCM s_lay, SCM s_geom, SCM s_percentage)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_width_relative);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_width_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_layout_width_relative);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_percentage = gh_scm2double(s_percentage);
  guppi_layout_width_relative(c_lay, c_geom, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_height_relative = "guppi-layout-height-relative";
static SCM
fn_scm_guppi_layout_height_relative(SCM s_lay, SCM s_geom, SCM s_percentage)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_height_relative);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_height_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_layout_height_relative);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_percentage = gh_scm2double(s_percentage);
  guppi_layout_height_relative(c_lay, c_geom, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_center_horizontally = "guppi-layout-center-horizontally";
static SCM
fn_scm_guppi_layout_center_horizontally(SCM s_lay, SCM s_geom)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_center_horizontally);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_center_horizontally);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  guppi_layout_center_horizontally(c_lay, c_geom);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_center_vertically = "guppi-layout-center-vertically";
static SCM
fn_scm_guppi_layout_center_vertically(SCM s_lay, SCM s_geom)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_center_vertically);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_center_vertically);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  guppi_layout_center_vertically(c_lay, c_geom);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_horizontal_fill = "guppi-layout-horizontal-fill";
static SCM
fn_scm_guppi_layout_horizontal_fill(SCM s_lay, SCM s_geom, SCM s_l_margin, SCM s_r_margin)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_l_margin;
  double c_r_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_horizontal_fill);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_horizontal_fill);
  SCM_ASSERT(gh_number_p(s_l_margin), s_l_margin, SCM_ARG3, (gchar*)s_scm_guppi_layout_horizontal_fill);
  SCM_ASSERT(gh_number_p(s_r_margin), s_r_margin, SCM_ARG4, (gchar*)s_scm_guppi_layout_horizontal_fill);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_l_margin = gh_scm2double(s_l_margin);
  c_r_margin = gh_scm2double(s_r_margin);
  guppi_layout_horizontal_fill(c_lay, c_geom, c_l_margin, c_r_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_vertical_fill = "guppi-layout-vertical-fill";
static SCM
fn_scm_guppi_layout_vertical_fill(SCM s_lay, SCM s_geom, SCM s_l_margin, SCM s_r_margin)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_geom;
  double c_l_margin;
  double c_r_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_vertical_fill);
  SCM_ASSERT(scm_guppi_geometry_p(s_geom), s_geom, SCM_ARG2, (gchar*)s_scm_guppi_layout_vertical_fill);
  SCM_ASSERT(gh_number_p(s_l_margin), s_l_margin, SCM_ARG3, (gchar*)s_scm_guppi_layout_vertical_fill);
  SCM_ASSERT(gh_number_p(s_r_margin), s_r_margin, SCM_ARG4, (gchar*)s_scm_guppi_layout_vertical_fill);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_geom = GUPPI_GEOMETRY(scm2guppi_geometry(s_geom));
  c_l_margin = gh_scm2double(s_l_margin);
  c_r_margin = gh_scm2double(s_r_margin);
  guppi_layout_vertical_fill(c_lay, c_geom, c_l_margin, c_r_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_aligned_left_edge = "guppi-layout-aligned-left-edge";
static SCM
fn_scm_guppi_layout_aligned_left_edge(SCM s_lay, SCM s_a, SCM s_b)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_aligned_left_edge);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_aligned_left_edge);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_aligned_left_edge);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  guppi_layout_aligned_left_edge(c_lay, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_aligned_right_edge = "guppi-layout-aligned-right-edge";
static SCM
fn_scm_guppi_layout_aligned_right_edge(SCM s_lay, SCM s_a, SCM s_b)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_aligned_right_edge);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_aligned_right_edge);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_aligned_right_edge);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  guppi_layout_aligned_right_edge(c_lay, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_aligned_top_edge = "guppi-layout-aligned-top-edge";
static SCM
fn_scm_guppi_layout_aligned_top_edge(SCM s_lay, SCM s_a, SCM s_b)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_aligned_top_edge);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_aligned_top_edge);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_aligned_top_edge);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  guppi_layout_aligned_top_edge(c_lay, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_aligned_bottom_edge = "guppi-layout-aligned-bottom-edge";
static SCM
fn_scm_guppi_layout_aligned_bottom_edge(SCM s_lay, SCM s_a, SCM s_b)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_aligned_bottom_edge);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_aligned_bottom_edge);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_aligned_bottom_edge);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  guppi_layout_aligned_bottom_edge(c_lay, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_horizontally_adjacent = "guppi-layout-horizontally-adjacent";
static SCM
fn_scm_guppi_layout_horizontally_adjacent(SCM s_lay, SCM s_left, SCM s_right, SCM s_gap)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_left;
  GuppiGeometry* c_right;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_horizontally_adjacent);
  SCM_ASSERT(scm_guppi_geometry_p(s_left), s_left, SCM_ARG2, (gchar*)s_scm_guppi_layout_horizontally_adjacent);
  SCM_ASSERT(scm_guppi_geometry_p(s_right), s_right, SCM_ARG3, (gchar*)s_scm_guppi_layout_horizontally_adjacent);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG4, (gchar*)s_scm_guppi_layout_horizontally_adjacent);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_left = GUPPI_GEOMETRY(scm2guppi_geometry(s_left));
  c_right = GUPPI_GEOMETRY(scm2guppi_geometry(s_right));
  c_gap = gh_scm2double(s_gap);
  guppi_layout_horizontally_adjacent(c_lay, c_left, c_right, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_vertically_adjacent = "guppi-layout-vertically-adjacent";
static SCM
fn_scm_guppi_layout_vertically_adjacent(SCM s_lay, SCM s_top, SCM s_bot, SCM s_gap)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_top;
  GuppiGeometry* c_bot;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_vertically_adjacent);
  SCM_ASSERT(scm_guppi_geometry_p(s_top), s_top, SCM_ARG2, (gchar*)s_scm_guppi_layout_vertically_adjacent);
  SCM_ASSERT(scm_guppi_geometry_p(s_bot), s_bot, SCM_ARG3, (gchar*)s_scm_guppi_layout_vertically_adjacent);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG4, (gchar*)s_scm_guppi_layout_vertically_adjacent);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_top = GUPPI_GEOMETRY(scm2guppi_geometry(s_top));
  c_bot = GUPPI_GEOMETRY(scm2guppi_geometry(s_bot));
  c_gap = gh_scm2double(s_gap);
  guppi_layout_vertically_adjacent(c_lay, c_top, c_bot, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_hbox2 = "guppi-layout-hbox2";
static SCM
fn_scm_guppi_layout_hbox2(SCM s_lay, SCM s_left, SCM s_right, SCM s_gap)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_left;
  GuppiGeometry* c_right;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_hbox2);
  SCM_ASSERT(scm_guppi_geometry_p(s_left), s_left, SCM_ARG2, (gchar*)s_scm_guppi_layout_hbox2);
  SCM_ASSERT(scm_guppi_geometry_p(s_right), s_right, SCM_ARG3, (gchar*)s_scm_guppi_layout_hbox2);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG4, (gchar*)s_scm_guppi_layout_hbox2);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_left = GUPPI_GEOMETRY(scm2guppi_geometry(s_left));
  c_right = GUPPI_GEOMETRY(scm2guppi_geometry(s_right));
  c_gap = gh_scm2double(s_gap);
  guppi_layout_hbox2(c_lay, c_left, c_right, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_hbox3 = "guppi-layout-hbox3";
static SCM
fn_scm_guppi_layout_hbox3(SCM s_lay, SCM s_left, SCM s_center, SCM s_right, SCM s_gap)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_left;
  GuppiGeometry* c_center;
  GuppiGeometry* c_right;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_hbox3);
  SCM_ASSERT(scm_guppi_geometry_p(s_left), s_left, SCM_ARG2, (gchar*)s_scm_guppi_layout_hbox3);
  SCM_ASSERT(scm_guppi_geometry_p(s_center), s_center, SCM_ARG3, (gchar*)s_scm_guppi_layout_hbox3);
  SCM_ASSERT(scm_guppi_geometry_p(s_right), s_right, SCM_ARG4, (gchar*)s_scm_guppi_layout_hbox3);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG5, (gchar*)s_scm_guppi_layout_hbox3);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_left = GUPPI_GEOMETRY(scm2guppi_geometry(s_left));
  c_center = GUPPI_GEOMETRY(scm2guppi_geometry(s_center));
  c_right = GUPPI_GEOMETRY(scm2guppi_geometry(s_right));
  c_gap = gh_scm2double(s_gap);
  guppi_layout_hbox3(c_lay, c_left, c_center, c_right, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_vbox2 = "guppi-layout-vbox2";
static SCM
fn_scm_guppi_layout_vbox2(SCM s_lay, SCM s_upper, SCM s_lower, SCM s_gap)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_upper;
  GuppiGeometry* c_lower;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_vbox2);
  SCM_ASSERT(scm_guppi_geometry_p(s_upper), s_upper, SCM_ARG2, (gchar*)s_scm_guppi_layout_vbox2);
  SCM_ASSERT(scm_guppi_geometry_p(s_lower), s_lower, SCM_ARG3, (gchar*)s_scm_guppi_layout_vbox2);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG4, (gchar*)s_scm_guppi_layout_vbox2);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_upper = GUPPI_GEOMETRY(scm2guppi_geometry(s_upper));
  c_lower = GUPPI_GEOMETRY(scm2guppi_geometry(s_lower));
  c_gap = gh_scm2double(s_gap);
  guppi_layout_vbox2(c_lay, c_upper, c_lower, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_vbox3 = "guppi-layout-vbox3";
static SCM
fn_scm_guppi_layout_vbox3(SCM s_lay, SCM s_upper, SCM s_center, SCM s_lower, SCM s_gap)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_upper;
  GuppiGeometry* c_center;
  GuppiGeometry* c_lower;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_vbox3);
  SCM_ASSERT(scm_guppi_geometry_p(s_upper), s_upper, SCM_ARG2, (gchar*)s_scm_guppi_layout_vbox3);
  SCM_ASSERT(scm_guppi_geometry_p(s_center), s_center, SCM_ARG3, (gchar*)s_scm_guppi_layout_vbox3);
  SCM_ASSERT(scm_guppi_geometry_p(s_lower), s_lower, SCM_ARG4, (gchar*)s_scm_guppi_layout_vbox3);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG5, (gchar*)s_scm_guppi_layout_vbox3);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_upper = GUPPI_GEOMETRY(scm2guppi_geometry(s_upper));
  c_center = GUPPI_GEOMETRY(scm2guppi_geometry(s_center));
  c_lower = GUPPI_GEOMETRY(scm2guppi_geometry(s_lower));
  c_gap = gh_scm2double(s_gap);
  guppi_layout_vbox3(c_lay, c_upper, c_center, c_lower, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_width_ratio = "guppi-layout-width-ratio";
static SCM
fn_scm_guppi_layout_width_ratio(SCM s_lay, SCM s_a, SCM s_b, SCM s_ratio)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  double c_ratio;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_width_ratio);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_width_ratio);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_width_ratio);
  SCM_ASSERT(gh_number_p(s_ratio), s_ratio, SCM_ARG4, (gchar*)s_scm_guppi_layout_width_ratio);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  c_ratio = gh_scm2double(s_ratio);
  guppi_layout_width_ratio(c_lay, c_a, c_b, c_ratio);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_height_ratio = "guppi-layout-height-ratio";
static SCM
fn_scm_guppi_layout_height_ratio(SCM s_lay, SCM s_a, SCM s_b, SCM s_ratio)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  double c_ratio;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_height_ratio);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_height_ratio);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_height_ratio);
  SCM_ASSERT(gh_number_p(s_ratio), s_ratio, SCM_ARG4, (gchar*)s_scm_guppi_layout_height_ratio);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  c_ratio = gh_scm2double(s_ratio);
  guppi_layout_height_ratio(c_lay, c_a, c_b, c_ratio);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_same_width = "guppi-layout-same-width";
static SCM
fn_scm_guppi_layout_same_width(SCM s_lay, SCM s_a, SCM s_b)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_same_width);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_same_width);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_same_width);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  guppi_layout_same_width(c_lay, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_same_height = "guppi-layout-same-height";
static SCM
fn_scm_guppi_layout_same_height(SCM s_lay, SCM s_a, SCM s_b)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_same_height);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_same_height);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_same_height);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  guppi_layout_same_height(c_lay, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_width_equals_height = "guppi-layout-width-equals-height";
static SCM
fn_scm_guppi_layout_width_equals_height(SCM s_lay, SCM s_a, SCM s_b)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_width_equals_height);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_width_equals_height);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_width_equals_height);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  guppi_layout_width_equals_height(c_lay, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_same_size = "guppi-layout-same-size";
static SCM
fn_scm_guppi_layout_same_size(SCM s_lay, SCM s_a, SCM s_b)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_same_size);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_same_size);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_same_size);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  guppi_layout_same_size(c_lay, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_same_place = "guppi-layout-same-place";
static SCM
fn_scm_guppi_layout_same_place(SCM s_lay, SCM s_a, SCM s_b)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_same_place);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_same_place);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_same_place);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  guppi_layout_same_place(c_lay, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_same_x_center = "guppi-layout-same-x-center";
static SCM
fn_scm_guppi_layout_same_x_center(SCM s_lay, SCM s_a, SCM s_b)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_same_x_center);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_same_x_center);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_same_x_center);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  guppi_layout_same_x_center(c_lay, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_same_y_center = "guppi-layout-same-y-center";
static SCM
fn_scm_guppi_layout_same_y_center(SCM s_lay, SCM s_a, SCM s_b)
{
  GuppiLayout* c_lay;
  GuppiGeometry* c_a;
  GuppiGeometry* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_same_y_center);
  SCM_ASSERT(scm_guppi_geometry_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_layout_same_y_center);
  SCM_ASSERT(scm_guppi_geometry_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_layout_same_y_center);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  c_a = GUPPI_GEOMETRY(scm2guppi_geometry(s_a));
  c_b = GUPPI_GEOMETRY(scm2guppi_geometry(s_b));
  guppi_layout_same_y_center(c_lay, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_layout_calc = "guppi-layout-calc";
static SCM
fn_scm_guppi_layout_calc(SCM s_lay)
{
  GuppiLayout* c_lay;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_layout_p(s_lay), s_lay, SCM_ARG1, (gchar*)s_scm_guppi_layout_calc);
  c_lay = GUPPI_LAYOUT(scm2guppi_layout(s_lay));
  guppi_layout_calc(c_lay);
  return s_retval;
}

static const gchar* s_scm_guppi_element_state_newv = "guppi-element-state-newv";
static SCM
fn_scm_guppi_element_state_newv(SCM s_type_name, SCM s_rest)
{
  gchar* c_type_name;
  GtkArg* c_rest;
  GuppiElementState* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  guint rest_len;
  SCM_ASSERT(gh_string_p(s_type_name), s_type_name, SCM_ARG1, (gchar*)s_scm_guppi_element_state_newv);
  SCM_ASSERT(gh_list_p(s_rest), s_rest, SCM_ARG2, (gchar*)s_scm_guppi_element_state_newv);
  c_type_name = gh_scm2newstr(s_type_name, NULL);
  c_rest = scm2argv(s_rest, &rest_len);
  c_retval = guppi_element_state_newv(c_type_name, rest_len, c_rest);
  s_retval = guppi_element_state2scm(GUPPI_ELEMENT_STATE(c_retval));
  free((gpointer)c_type_name);
  guppi_argv_free(c_rest, rest_len);
  return s_retval;
}

static const gchar* s_scm_guppi_element_state_label = "guppi-element-state-label";
static SCM
fn_scm_guppi_element_state_label(SCM s_state)
{
  GuppiElementState* c_state;
  const gchar* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_state_p(s_state), s_state, SCM_ARG1, (gchar*)s_scm_guppi_element_state_label);
  c_state = GUPPI_ELEMENT_STATE(scm2guppi_element_state(s_state));
  c_retval = guppi_element_state_label(c_state);
  s_retval = gh_str02scm((gchar*)c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_element_state_set_label = "guppi-element-state-set-label";
static SCM
fn_scm_guppi_element_state_set_label(SCM s_state, SCM s_s)
{
  GuppiElementState* c_state;
  gchar* c_s;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_state_p(s_state), s_state, SCM_ARG1, (gchar*)s_scm_guppi_element_state_set_label);
  SCM_ASSERT(gh_string_p(s_s), s_s, SCM_ARG2, (gchar*)s_scm_guppi_element_state_set_label);
  c_state = GUPPI_ELEMENT_STATE(scm2guppi_element_state(s_state));
  c_s = gh_scm2newstr(s_s, NULL);
  guppi_element_state_set_label(c_state, c_s);
  free((gpointer)c_s);
  return s_retval;
}

static const gchar* s_scm_guppi_element_state_make_view = "guppi-element-state-make-view";
static SCM
fn_scm_guppi_element_state_make_view(SCM s_state)
{
  GuppiElementState* c_state;
  GuppiElementView* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_state_p(s_state), s_state, SCM_ARG1, (gchar*)s_scm_guppi_element_state_make_view);
  c_state = GUPPI_ELEMENT_STATE(scm2guppi_element_state(s_state));
  c_retval = guppi_element_state_make_view(c_state);
  s_retval = guppi_element_view2scm(GUPPI_ELEMENT_VIEW(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_element_state_connect = "guppi-element-state-connect";
static SCM
fn_scm_guppi_element_state_connect(SCM s_s1, SCM s_str1, SCM s_s2, SCM s_str2)
{
  GuppiElementState* c_s1;
  gchar* c_str1;
  GuppiElementState* c_s2;
  gchar* c_str2;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_state_p(s_s1), s_s1, SCM_ARG1, (gchar*)s_scm_guppi_element_state_connect);
  SCM_ASSERT(gh_string_p(s_str1), s_str1, SCM_ARG2, (gchar*)s_scm_guppi_element_state_connect);
  SCM_ASSERT(scm_guppi_element_state_p(s_s2), s_s2, SCM_ARG3, (gchar*)s_scm_guppi_element_state_connect);
  SCM_ASSERT(gh_string_p(s_str2), s_str2, SCM_ARG4, (gchar*)s_scm_guppi_element_state_connect);
  c_s1 = GUPPI_ELEMENT_STATE(scm2guppi_element_state(s_s1));
  c_str1 = gh_scm2newstr(s_str1, NULL);
  c_s2 = GUPPI_ELEMENT_STATE(scm2guppi_element_state(s_s2));
  c_str2 = gh_scm2newstr(s_str2, NULL);
  guppi_element_state_connect(c_s1, c_str1, c_s2, c_str2);
  free((gpointer)c_str1);
  free((gpointer)c_str2);
  return s_retval;
}

static const gchar* s_scm_guppi_element_state_spew_xml = "guppi-element-state-spew-xml";
static SCM
fn_scm_guppi_element_state_spew_xml(SCM s_state)
{
  GuppiElementState* c_state;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_state_p(s_state), s_state, SCM_ARG1, (gchar*)s_scm_guppi_element_state_spew_xml);
  c_state = GUPPI_ELEMENT_STATE(scm2guppi_element_state(s_state));
  guppi_element_state_spew_xml(c_state);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_state = "guppi-element-view-state";
static SCM
fn_scm_guppi_element_view_state(SCM s_v)
{
  GuppiElementView* c_v;
  GuppiElementState* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_state);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_retval = guppi_element_view_state(c_v);
  s_retval = guppi_element_state2scm(GUPPI_ELEMENT_STATE(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_set_x_axis_marker_type = "guppi-element-view-set-x-axis-marker-type";
static SCM
fn_scm_guppi_element_view_set_x_axis_marker_type(SCM s_v, SCM s_t)
{
  GuppiElementView* c_v;
  gint c_t;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_set_x_axis_marker_type);
  SCM_ASSERT(gh_exact_p(s_t), s_t, SCM_ARG2, (gchar*)s_scm_guppi_element_view_set_x_axis_marker_type);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_t = gh_scm2int(s_t);
  guppi_element_view_set_x_axis_marker_type(c_v, c_t);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_set_y_axis_marker_type = "guppi-element-view-set-y-axis-marker-type";
static SCM
fn_scm_guppi_element_view_set_y_axis_marker_type(SCM s_v, SCM s_t)
{
  GuppiElementView* c_v;
  gint c_t;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_set_y_axis_marker_type);
  SCM_ASSERT(gh_exact_p(s_t), s_t, SCM_ARG2, (gchar*)s_scm_guppi_element_view_set_y_axis_marker_type);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_t = gh_scm2int(s_t);
  guppi_element_view_set_y_axis_marker_type(c_v, c_t);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_connect = "guppi-element-view-connect";
static SCM
fn_scm_guppi_element_view_connect(SCM s_v1, SCM s_s1, SCM s_v2, SCM s_s2)
{
  GuppiElementView* c_v1;
  gchar* c_s1;
  GuppiElementView* c_v2;
  gchar* c_s2;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v1), s_v1, SCM_ARG1, (gchar*)s_scm_guppi_element_view_connect);
  SCM_ASSERT(gh_string_p(s_s1), s_s1, SCM_ARG2, (gchar*)s_scm_guppi_element_view_connect);
  SCM_ASSERT(scm_guppi_element_view_p(s_v2), s_v2, SCM_ARG3, (gchar*)s_scm_guppi_element_view_connect);
  SCM_ASSERT(gh_string_p(s_s2), s_s2, SCM_ARG4, (gchar*)s_scm_guppi_element_view_connect);
  c_v1 = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v1));
  c_s1 = gh_scm2newstr(s_s1, NULL);
  c_v2 = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v2));
  c_s2 = gh_scm2newstr(s_s2, NULL);
  guppi_element_view_connect(c_v1, c_s1, c_v2, c_s2);
  free((gpointer)c_s1);
  free((gpointer)c_s2);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_set_preferred_x_view = "guppi-element-view-set-preferred-x-view";
static SCM
fn_scm_guppi_element_view_set_preferred_x_view(SCM s_v)
{
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_set_preferred_x_view);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_element_view_set_preferred_x_view(c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_set_preferred_y_view = "guppi-element-view-set-preferred-y-view";
static SCM
fn_scm_guppi_element_view_set_preferred_y_view(SCM s_v)
{
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_set_preferred_y_view);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_element_view_set_preferred_y_view(c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_set_preferred_view = "guppi-element-view-set-preferred-view";
static SCM
fn_scm_guppi_element_view_set_preferred_view(SCM s_v)
{
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_set_preferred_view);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_element_view_set_preferred_view(c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_force_preferred_x_view = "guppi-element-view-force-preferred-x-view";
static SCM
fn_scm_guppi_element_view_force_preferred_x_view(SCM s_v, SCM s_q)
{
  GuppiElementView* c_v;
  gboolean c_q;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_force_preferred_x_view);
  SCM_ASSERT(gh_boolean_p(s_q), s_q, SCM_ARG2, (gchar*)s_scm_guppi_element_view_force_preferred_x_view);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_q = gh_scm2bool(s_q);
  guppi_element_view_force_preferred_x_view(c_v, c_q);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_force_preferred_y_view = "guppi-element-view-force-preferred-y-view";
static SCM
fn_scm_guppi_element_view_force_preferred_y_view(SCM s_v, SCM s_q)
{
  GuppiElementView* c_v;
  gboolean c_q;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_force_preferred_y_view);
  SCM_ASSERT(gh_boolean_p(s_q), s_q, SCM_ARG2, (gchar*)s_scm_guppi_element_view_force_preferred_y_view);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_q = gh_scm2bool(s_q);
  guppi_element_view_force_preferred_y_view(c_v, c_q);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_force_preferred_view = "guppi-element-view-force-preferred-view";
static SCM
fn_scm_guppi_element_view_force_preferred_view(SCM s_v, SCM s_q)
{
  GuppiElementView* c_v;
  gboolean c_q;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_force_preferred_view);
  SCM_ASSERT(gh_boolean_p(s_q), s_q, SCM_ARG2, (gchar*)s_scm_guppi_element_view_force_preferred_view);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_q = gh_scm2bool(s_q);
  guppi_element_view_force_preferred_view(c_v, c_q);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_print_ps_to_file = "guppi-element-view-print-ps-to-file";
static SCM
fn_scm_guppi_element_view_print_ps_to_file(SCM s_v, SCM s_filename)
{
  GuppiElementView* c_v;
  gchar* c_filename;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_print_ps_to_file);
  SCM_ASSERT(gh_string_p(s_filename), s_filename, SCM_ARG2, (gchar*)s_scm_guppi_element_view_print_ps_to_file);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_filename = gh_scm2newstr(s_filename, NULL);
  guppi_element_view_print_ps_to_file(c_v, c_filename);
  free((gpointer)c_filename);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_freeze = "guppi-element-view-freeze";
static SCM
fn_scm_guppi_element_view_freeze(SCM s_v)
{
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_freeze);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_element_view_freeze(c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_thaw = "guppi-element-view-thaw";
static SCM
fn_scm_guppi_element_view_thaw(SCM s_v)
{
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_thaw);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_element_view_thaw(c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_element_view_spew_xml = "guppi-element-view-spew-xml";
static SCM
fn_scm_guppi_element_view_spew_xml(SCM s_v)
{
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG1, (gchar*)s_scm_guppi_element_view_spew_xml);
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_element_view_spew_xml(c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_group_state_new = "guppi-group-state-new";
static SCM
fn_scm_guppi_group_state_new()
{
  GuppiElementState* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_group_state_new();
  s_retval = guppi_element_state2scm(GUPPI_ELEMENT_STATE(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_has = "guppi-group-view-has";
static SCM
fn_scm_guppi_group_view_has(SCM s_grp, SCM s_v)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  gboolean c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_has);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_has);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_retval = guppi_group_view_has(c_grp, c_v);
  s_retval = gh_bool2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_add = "guppi-group-view-add";
static SCM
fn_scm_guppi_group_view_add(SCM s_grp, SCM s_v)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_add);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_add);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_group_view_add(c_grp, c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_remove = "guppi-group-view-remove";
static SCM
fn_scm_guppi_group_view_remove(SCM s_grp, SCM s_v)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_remove);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_remove);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_group_view_remove(c_grp, c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_replace = "guppi-group-view-replace";
static SCM
fn_scm_guppi_group_view_replace(SCM s_grp, SCM s_v_old, SCM s_v_new)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v_old;
  GuppiElementView* c_v_new;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_replace);
  SCM_ASSERT(scm_guppi_element_view_p(s_v_old), s_v_old, SCM_ARG2, (gchar*)s_scm_guppi_group_view_replace);
  SCM_ASSERT(scm_guppi_element_view_p(s_v_new), s_v_new, SCM_ARG3, (gchar*)s_scm_guppi_group_view_replace);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v_old = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v_old));
  c_v_new = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v_new));
  guppi_group_view_replace(c_grp, c_v_old, c_v_new);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_commit_changes = "guppi-group-view-commit-changes";
static SCM
fn_scm_guppi_group_view_commit_changes(SCM s_grp)
{
  GuppiGroupView* c_grp;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_commit_changes);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  guppi_group_view_commit_changes(c_grp);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_commit_all_changes = "guppi-group-view-commit-all-changes";
static SCM
fn_scm_guppi_group_view_commit_all_changes(SCM s_grp)
{
  GuppiGroupView* c_grp;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_commit_all_changes);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  guppi_group_view_commit_all_changes(c_grp);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_natural_width = "guppi-group-view-layout-natural-width";
static SCM
fn_scm_guppi_group_view_layout_natural_width(SCM s_grp, SCM s_v)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_natural_width);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_natural_width);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_group_view_layout_natural_width(c_grp, c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_natural_height = "guppi-group-view-layout-natural-height";
static SCM
fn_scm_guppi_group_view_layout_natural_height(SCM s_grp, SCM s_v)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_natural_height);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_natural_height);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_group_view_layout_natural_height(c_grp, c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_left_edge_relative = "guppi-group-view-layout-left-edge-relative";
static SCM
fn_scm_guppi_group_view_layout_left_edge_relative(SCM s_grp, SCM s_v, SCM s_percentage)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_left_edge_relative);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_left_edge_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_left_edge_relative);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_percentage = gh_scm2double(s_percentage);
  guppi_group_view_layout_left_edge_relative(c_grp, c_v, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_right_edge_relative = "guppi-group-view-layout-right-edge-relative";
static SCM
fn_scm_guppi_group_view_layout_right_edge_relative(SCM s_grp, SCM s_v, SCM s_percentage)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_right_edge_relative);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_right_edge_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_right_edge_relative);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_percentage = gh_scm2double(s_percentage);
  guppi_group_view_layout_right_edge_relative(c_grp, c_v, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_top_edge_relative = "guppi-group-view-layout-top-edge-relative";
static SCM
fn_scm_guppi_group_view_layout_top_edge_relative(SCM s_grp, SCM s_v, SCM s_percentage)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_top_edge_relative);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_top_edge_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_top_edge_relative);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_percentage = gh_scm2double(s_percentage);
  guppi_group_view_layout_top_edge_relative(c_grp, c_v, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_bottom_edge_relative = "guppi-group-view-layout-bottom-edge-relative";
static SCM
fn_scm_guppi_group_view_layout_bottom_edge_relative(SCM s_grp, SCM s_v, SCM s_percentage)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_bottom_edge_relative);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_bottom_edge_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_bottom_edge_relative);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_percentage = gh_scm2double(s_percentage);
  guppi_group_view_layout_bottom_edge_relative(c_grp, c_v, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_flush_left = "guppi-group-view-layout-flush-left";
static SCM
fn_scm_guppi_group_view_layout_flush_left(SCM s_grp, SCM s_v, SCM s_margin)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_flush_left);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_flush_left);
  SCM_ASSERT(gh_number_p(s_margin), s_margin, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_flush_left);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_margin = gh_scm2double(s_margin);
  guppi_group_view_layout_flush_left(c_grp, c_v, c_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_flush_right = "guppi-group-view-layout-flush-right";
static SCM
fn_scm_guppi_group_view_layout_flush_right(SCM s_grp, SCM s_v, SCM s_margin)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_flush_right);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_flush_right);
  SCM_ASSERT(gh_number_p(s_margin), s_margin, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_flush_right);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_margin = gh_scm2double(s_margin);
  guppi_group_view_layout_flush_right(c_grp, c_v, c_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_flush_top = "guppi-group-view-layout-flush-top";
static SCM
fn_scm_guppi_group_view_layout_flush_top(SCM s_grp, SCM s_v, SCM s_margin)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_flush_top);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_flush_top);
  SCM_ASSERT(gh_number_p(s_margin), s_margin, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_flush_top);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_margin = gh_scm2double(s_margin);
  guppi_group_view_layout_flush_top(c_grp, c_v, c_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_flush_bottom = "guppi-group-view-layout-flush-bottom";
static SCM
fn_scm_guppi_group_view_layout_flush_bottom(SCM s_grp, SCM s_v, SCM s_margin)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_flush_bottom);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_flush_bottom);
  SCM_ASSERT(gh_number_p(s_margin), s_margin, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_flush_bottom);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_margin = gh_scm2double(s_margin);
  guppi_group_view_layout_flush_bottom(c_grp, c_v, c_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_width_relative = "guppi-group-view-layout-width-relative";
static SCM
fn_scm_guppi_group_view_layout_width_relative(SCM s_grp, SCM s_v, SCM s_percentage)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_width_relative);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_width_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_width_relative);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_percentage = gh_scm2double(s_percentage);
  guppi_group_view_layout_width_relative(c_grp, c_v, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_height_relative = "guppi-group-view-layout-height-relative";
static SCM
fn_scm_guppi_group_view_layout_height_relative(SCM s_grp, SCM s_v, SCM s_percentage)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_percentage;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_height_relative);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_height_relative);
  SCM_ASSERT(gh_number_p(s_percentage), s_percentage, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_height_relative);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_percentage = gh_scm2double(s_percentage);
  guppi_group_view_layout_height_relative(c_grp, c_v, c_percentage);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_center_horizontally = "guppi-group-view-layout-center-horizontally";
static SCM
fn_scm_guppi_group_view_layout_center_horizontally(SCM s_grp, SCM s_v)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_center_horizontally);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_center_horizontally);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_group_view_layout_center_horizontally(c_grp, c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_center_vertically = "guppi-group-view-layout-center-vertically";
static SCM
fn_scm_guppi_group_view_layout_center_vertically(SCM s_grp, SCM s_v)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_center_vertically);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_center_vertically);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  guppi_group_view_layout_center_vertically(c_grp, c_v);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_horizontal_fill = "guppi-group-view-layout-horizontal-fill";
static SCM
fn_scm_guppi_group_view_layout_horizontal_fill(SCM s_grp, SCM s_v, SCM s_l_margin, SCM s_r_margin)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_l_margin;
  double c_r_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_horizontal_fill);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_horizontal_fill);
  SCM_ASSERT(gh_number_p(s_l_margin), s_l_margin, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_horizontal_fill);
  SCM_ASSERT(gh_number_p(s_r_margin), s_r_margin, SCM_ARG4, (gchar*)s_scm_guppi_group_view_layout_horizontal_fill);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_l_margin = gh_scm2double(s_l_margin);
  c_r_margin = gh_scm2double(s_r_margin);
  guppi_group_view_layout_horizontal_fill(c_grp, c_v, c_l_margin, c_r_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_vertical_fill = "guppi-group-view-layout-vertical-fill";
static SCM
fn_scm_guppi_group_view_layout_vertical_fill(SCM s_grp, SCM s_v, SCM s_l_margin, SCM s_r_margin)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_v;
  double c_l_margin;
  double c_r_margin;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_vertical_fill);
  SCM_ASSERT(scm_guppi_element_view_p(s_v), s_v, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_vertical_fill);
  SCM_ASSERT(gh_number_p(s_l_margin), s_l_margin, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_vertical_fill);
  SCM_ASSERT(gh_number_p(s_r_margin), s_r_margin, SCM_ARG4, (gchar*)s_scm_guppi_group_view_layout_vertical_fill);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_v = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_v));
  c_l_margin = gh_scm2double(s_l_margin);
  c_r_margin = gh_scm2double(s_r_margin);
  guppi_group_view_layout_vertical_fill(c_grp, c_v, c_l_margin, c_r_margin);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_aligned_left_edge = "guppi-group-view-layout-aligned-left-edge";
static SCM
fn_scm_guppi_group_view_layout_aligned_left_edge(SCM s_grp, SCM s_a, SCM s_b)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_aligned_left_edge);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_aligned_left_edge);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_aligned_left_edge);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  guppi_group_view_layout_aligned_left_edge(c_grp, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_aligned_right_edge = "guppi-group-view-layout-aligned-right-edge";
static SCM
fn_scm_guppi_group_view_layout_aligned_right_edge(SCM s_grp, SCM s_a, SCM s_b)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_aligned_right_edge);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_aligned_right_edge);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_aligned_right_edge);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  guppi_group_view_layout_aligned_right_edge(c_grp, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_aligned_top_edge = "guppi-group-view-layout-aligned-top-edge";
static SCM
fn_scm_guppi_group_view_layout_aligned_top_edge(SCM s_grp, SCM s_a, SCM s_b)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_aligned_top_edge);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_aligned_top_edge);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_aligned_top_edge);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  guppi_group_view_layout_aligned_top_edge(c_grp, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_aligned_bottom_edge = "guppi-group-view-layout-aligned-bottom-edge";
static SCM
fn_scm_guppi_group_view_layout_aligned_bottom_edge(SCM s_grp, SCM s_a, SCM s_b)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_aligned_bottom_edge);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_aligned_bottom_edge);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_aligned_bottom_edge);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  guppi_group_view_layout_aligned_bottom_edge(c_grp, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_horizontally_adjacent = "guppi-group-view-layout-horizontally-adjacent";
static SCM
fn_scm_guppi_group_view_layout_horizontally_adjacent(SCM s_grp, SCM s_left, SCM s_right, SCM s_gap)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_left;
  GuppiElementView* c_right;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_horizontally_adjacent);
  SCM_ASSERT(scm_guppi_element_view_p(s_left), s_left, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_horizontally_adjacent);
  SCM_ASSERT(scm_guppi_element_view_p(s_right), s_right, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_horizontally_adjacent);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG4, (gchar*)s_scm_guppi_group_view_layout_horizontally_adjacent);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_left = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_left));
  c_right = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_right));
  c_gap = gh_scm2double(s_gap);
  guppi_group_view_layout_horizontally_adjacent(c_grp, c_left, c_right, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_vertically_adjacent = "guppi-group-view-layout-vertically-adjacent";
static SCM
fn_scm_guppi_group_view_layout_vertically_adjacent(SCM s_grp, SCM s_top, SCM s_bot, SCM s_gap)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_top;
  GuppiElementView* c_bot;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_vertically_adjacent);
  SCM_ASSERT(scm_guppi_element_view_p(s_top), s_top, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_vertically_adjacent);
  SCM_ASSERT(scm_guppi_element_view_p(s_bot), s_bot, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_vertically_adjacent);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG4, (gchar*)s_scm_guppi_group_view_layout_vertically_adjacent);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_top = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_top));
  c_bot = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_bot));
  c_gap = gh_scm2double(s_gap);
  guppi_group_view_layout_vertically_adjacent(c_grp, c_top, c_bot, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_hbox2 = "guppi-group-view-layout-hbox2";
static SCM
fn_scm_guppi_group_view_layout_hbox2(SCM s_grp, SCM s_left, SCM s_right, SCM s_gap)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_left;
  GuppiElementView* c_right;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_hbox2);
  SCM_ASSERT(scm_guppi_element_view_p(s_left), s_left, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_hbox2);
  SCM_ASSERT(scm_guppi_element_view_p(s_right), s_right, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_hbox2);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG4, (gchar*)s_scm_guppi_group_view_layout_hbox2);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_left = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_left));
  c_right = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_right));
  c_gap = gh_scm2double(s_gap);
  guppi_group_view_layout_hbox2(c_grp, c_left, c_right, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_hbox3 = "guppi-group-view-layout-hbox3";
static SCM
fn_scm_guppi_group_view_layout_hbox3(SCM s_grp, SCM s_left, SCM s_center, SCM s_right, SCM s_gap)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_left;
  GuppiElementView* c_center;
  GuppiElementView* c_right;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_hbox3);
  SCM_ASSERT(scm_guppi_element_view_p(s_left), s_left, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_hbox3);
  SCM_ASSERT(scm_guppi_element_view_p(s_center), s_center, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_hbox3);
  SCM_ASSERT(scm_guppi_element_view_p(s_right), s_right, SCM_ARG4, (gchar*)s_scm_guppi_group_view_layout_hbox3);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG5, (gchar*)s_scm_guppi_group_view_layout_hbox3);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_left = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_left));
  c_center = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_center));
  c_right = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_right));
  c_gap = gh_scm2double(s_gap);
  guppi_group_view_layout_hbox3(c_grp, c_left, c_center, c_right, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_vbox2 = "guppi-group-view-layout-vbox2";
static SCM
fn_scm_guppi_group_view_layout_vbox2(SCM s_grp, SCM s_upper, SCM s_lower, SCM s_gap)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_upper;
  GuppiElementView* c_lower;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_vbox2);
  SCM_ASSERT(scm_guppi_element_view_p(s_upper), s_upper, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_vbox2);
  SCM_ASSERT(scm_guppi_element_view_p(s_lower), s_lower, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_vbox2);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG4, (gchar*)s_scm_guppi_group_view_layout_vbox2);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_upper = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_upper));
  c_lower = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_lower));
  c_gap = gh_scm2double(s_gap);
  guppi_group_view_layout_vbox2(c_grp, c_upper, c_lower, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_vbox3 = "guppi-group-view-layout-vbox3";
static SCM
fn_scm_guppi_group_view_layout_vbox3(SCM s_grp, SCM s_upper, SCM s_center, SCM s_lower, SCM s_gap)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_upper;
  GuppiElementView* c_center;
  GuppiElementView* c_lower;
  double c_gap;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_vbox3);
  SCM_ASSERT(scm_guppi_element_view_p(s_upper), s_upper, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_vbox3);
  SCM_ASSERT(scm_guppi_element_view_p(s_center), s_center, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_vbox3);
  SCM_ASSERT(scm_guppi_element_view_p(s_lower), s_lower, SCM_ARG4, (gchar*)s_scm_guppi_group_view_layout_vbox3);
  SCM_ASSERT(gh_number_p(s_gap), s_gap, SCM_ARG5, (gchar*)s_scm_guppi_group_view_layout_vbox3);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_upper = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_upper));
  c_center = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_center));
  c_lower = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_lower));
  c_gap = gh_scm2double(s_gap);
  guppi_group_view_layout_vbox3(c_grp, c_upper, c_center, c_lower, c_gap);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_width_ratio = "guppi-group-view-layout-width-ratio";
static SCM
fn_scm_guppi_group_view_layout_width_ratio(SCM s_grp, SCM s_a, SCM s_b, SCM s_ratio)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  double c_ratio;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_width_ratio);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_width_ratio);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_width_ratio);
  SCM_ASSERT(gh_number_p(s_ratio), s_ratio, SCM_ARG4, (gchar*)s_scm_guppi_group_view_layout_width_ratio);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  c_ratio = gh_scm2double(s_ratio);
  guppi_group_view_layout_width_ratio(c_grp, c_a, c_b, c_ratio);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_height_ratio = "guppi-group-view-layout-height-ratio";
static SCM
fn_scm_guppi_group_view_layout_height_ratio(SCM s_grp, SCM s_a, SCM s_b, SCM s_ratio)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  double c_ratio;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_height_ratio);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_height_ratio);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_height_ratio);
  SCM_ASSERT(gh_number_p(s_ratio), s_ratio, SCM_ARG4, (gchar*)s_scm_guppi_group_view_layout_height_ratio);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  c_ratio = gh_scm2double(s_ratio);
  guppi_group_view_layout_height_ratio(c_grp, c_a, c_b, c_ratio);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_same_width = "guppi-group-view-layout-same-width";
static SCM
fn_scm_guppi_group_view_layout_same_width(SCM s_grp, SCM s_a, SCM s_b)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_same_width);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_same_width);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_same_width);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  guppi_group_view_layout_same_width(c_grp, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_same_height = "guppi-group-view-layout-same-height";
static SCM
fn_scm_guppi_group_view_layout_same_height(SCM s_grp, SCM s_a, SCM s_b)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_same_height);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_same_height);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_same_height);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  guppi_group_view_layout_same_height(c_grp, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_width_equals_height = "guppi-group-view-layout-width-equals-height";
static SCM
fn_scm_guppi_group_view_layout_width_equals_height(SCM s_grp, SCM s_a, SCM s_b)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_width_equals_height);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_width_equals_height);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_width_equals_height);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  guppi_group_view_layout_width_equals_height(c_grp, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_same_size = "guppi-group-view-layout-same-size";
static SCM
fn_scm_guppi_group_view_layout_same_size(SCM s_grp, SCM s_a, SCM s_b)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_same_size);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_same_size);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_same_size);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  guppi_group_view_layout_same_size(c_grp, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_same_place = "guppi-group-view-layout-same-place";
static SCM
fn_scm_guppi_group_view_layout_same_place(SCM s_grp, SCM s_a, SCM s_b)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_same_place);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_same_place);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_same_place);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  guppi_group_view_layout_same_place(c_grp, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_same_x_center = "guppi-group-view-layout-same-x-center";
static SCM
fn_scm_guppi_group_view_layout_same_x_center(SCM s_grp, SCM s_a, SCM s_b)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_same_x_center);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_same_x_center);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_same_x_center);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  guppi_group_view_layout_same_x_center(c_grp, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_group_view_layout_same_y_center = "guppi-group-view-layout-same-y-center";
static SCM
fn_scm_guppi_group_view_layout_same_y_center(SCM s_grp, SCM s_a, SCM s_b)
{
  GuppiGroupView* c_grp;
  GuppiElementView* c_a;
  GuppiElementView* c_b;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_group_view_layout_same_y_center);
  SCM_ASSERT(scm_guppi_element_view_p(s_a), s_a, SCM_ARG2, (gchar*)s_scm_guppi_group_view_layout_same_y_center);
  SCM_ASSERT(scm_guppi_element_view_p(s_b), s_b, SCM_ARG3, (gchar*)s_scm_guppi_group_view_layout_same_y_center);
  c_grp = GUPPI_GROUP_VIEW(scm2guppi_group_view(s_grp));
  c_a = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_a));
  c_b = GUPPI_ELEMENT_VIEW(scm2guppi_element_view(s_b));
  guppi_group_view_layout_same_y_center(c_grp, c_a, c_b);
  return s_retval;
}

static const gchar* s_scm_guppi_root_group_state_new = "guppi-root-group-state-new";
static SCM
fn_scm_guppi_root_group_state_new()
{
  GuppiElementState* c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  c_retval = guppi_root_group_state_new();
  s_retval = guppi_element_state2scm(GUPPI_ELEMENT_STATE(c_retval));
  return s_retval;
}

static const gchar* s_scm_guppi_root_group_view_set_size = "guppi-root-group-view-set-size";
static SCM
fn_scm_guppi_root_group_view_set_size(SCM s_grp, SCM s_width, SCM s_height)
{
  GuppiRootGroupView* c_grp;
  double c_width;
  double c_height;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_root_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_root_group_view_set_size);
  SCM_ASSERT(gh_number_p(s_width), s_width, SCM_ARG2, (gchar*)s_scm_guppi_root_group_view_set_size);
  SCM_ASSERT(gh_number_p(s_height), s_height, SCM_ARG3, (gchar*)s_scm_guppi_root_group_view_set_size);
  c_grp = GUPPI_ROOT_GROUP_VIEW(scm2guppi_root_group_view(s_grp));
  c_width = gh_scm2double(s_width);
  c_height = gh_scm2double(s_height);
  guppi_root_group_view_set_size(c_grp, c_width, c_height);
  return s_retval;
}

static const gchar* s_scm_guppi_root_group_view_width = "guppi-root-group-view-width";
static SCM
fn_scm_guppi_root_group_view_width(SCM s_grp)
{
  GuppiRootGroupView* c_grp;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_root_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_root_group_view_width);
  c_grp = GUPPI_ROOT_GROUP_VIEW(scm2guppi_root_group_view(s_grp));
  c_retval = guppi_root_group_view_width(c_grp);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_root_group_view_height = "guppi-root-group-view-height";
static SCM
fn_scm_guppi_root_group_view_height(SCM s_grp)
{
  GuppiRootGroupView* c_grp;
  double c_retval;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_root_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_root_group_view_height);
  c_grp = GUPPI_ROOT_GROUP_VIEW(scm2guppi_root_group_view(s_grp));
  c_retval = guppi_root_group_view_height(c_grp);
  s_retval = gh_double2scm(c_retval);
  return s_retval;
}

static const gchar* s_scm_guppi_root_group_view_show_in_window = "guppi-root-group-view-show-in-window";
static SCM
fn_scm_guppi_root_group_view_show_in_window(SCM s_grp)
{
  GuppiRootGroupView* c_grp;
  SCM s_retval = SCM_UNSPECIFIED;
  SCM_ASSERT(scm_guppi_root_group_view_p(s_grp), s_grp, SCM_ARG1, (gchar*)s_scm_guppi_root_group_view_show_in_window);
  c_grp = GUPPI_ROOT_GROUP_VIEW(scm2guppi_root_group_view(s_grp));
  guppi_root_group_view_show_in_window(c_grp);
  return s_retval;
}


void
guppi_scm_plot_init(void)
{
  static gboolean init = FALSE;

  if (!guppi_guile_is_active())
    return;

  g_return_if_fail(init == FALSE);
  init = TRUE; /* brace matching hack } */

#ifdef USING_GUILE_1_3_X
  guppi_style_type_tag = scm_newsmob(&guppi_style_smob_fns);
#else
  guppi_style_type_tag = scm_make_smob_type("GuppiStyle", 1);
  scm_set_smob_mark(guppi_style_type_tag, mark_guppi_style);
  scm_set_smob_free(guppi_style_type_tag, free_guppi_style);
  scm_set_smob_print(guppi_style_type_tag, print_guppi_style);
#endif

  scm_make_gsubr("guppi-style?", 1, 0, 0, fn_scm_guppi_style_p);
  scm_make_gsubr("guppi-seq-style?", 1, 0, 0, fn_scm_guppi_seq_style_p);
#ifdef USING_GUILE_1_3_X
  guppi_color_gradient_type_tag = scm_newsmob(&guppi_color_gradient_smob_fns);
#else
  guppi_color_gradient_type_tag = scm_make_smob_type("GuppiColorGradient", 1);
  scm_set_smob_mark(guppi_color_gradient_type_tag, mark_guppi_color_gradient);
  scm_set_smob_free(guppi_color_gradient_type_tag, free_guppi_color_gradient);
  scm_set_smob_print(guppi_color_gradient_type_tag, print_guppi_color_gradient);
#endif

  scm_make_gsubr("guppi-color-gradient?", 1, 0, 0, fn_scm_guppi_color_gradient_p);
#ifdef USING_GUILE_1_3_X
  guppi_geometry_type_tag = scm_newsmob(&guppi_geometry_smob_fns);
#else
  guppi_geometry_type_tag = scm_make_smob_type("GuppiGeometry", 1);
  scm_set_smob_mark(guppi_geometry_type_tag, mark_guppi_geometry);
  scm_set_smob_free(guppi_geometry_type_tag, free_guppi_geometry);
  scm_set_smob_print(guppi_geometry_type_tag, print_guppi_geometry);
#endif

  scm_make_gsubr("guppi-geometry?", 1, 0, 0, fn_scm_guppi_geometry_p);
#ifdef USING_GUILE_1_3_X
  guppi_layout_type_tag = scm_newsmob(&guppi_layout_smob_fns);
#else
  guppi_layout_type_tag = scm_make_smob_type("GuppiLayout", 1);
  scm_set_smob_mark(guppi_layout_type_tag, mark_guppi_layout);
  scm_set_smob_free(guppi_layout_type_tag, free_guppi_layout);
  scm_set_smob_print(guppi_layout_type_tag, print_guppi_layout);
#endif

  scm_make_gsubr("guppi-layout?", 1, 0, 0, fn_scm_guppi_layout_p);
#ifdef USING_GUILE_1_3_X
  guppi_element_state_type_tag = scm_newsmob(&guppi_element_state_smob_fns);
#else
  guppi_element_state_type_tag = scm_make_smob_type("GuppiElementState", 1);
  scm_set_smob_mark(guppi_element_state_type_tag, mark_guppi_element_state);
  scm_set_smob_free(guppi_element_state_type_tag, free_guppi_element_state);
  scm_set_smob_print(guppi_element_state_type_tag, print_guppi_element_state);
#endif

  scm_make_gsubr("guppi-element-state?", 1, 0, 0, fn_scm_guppi_element_state_p);
#ifdef USING_GUILE_1_3_X
  guppi_element_view_type_tag = scm_newsmob(&guppi_element_view_smob_fns);
#else
  guppi_element_view_type_tag = scm_make_smob_type("GuppiElementView", 1);
  scm_set_smob_mark(guppi_element_view_type_tag, mark_guppi_element_view);
  scm_set_smob_free(guppi_element_view_type_tag, free_guppi_element_view);
  scm_set_smob_print(guppi_element_view_type_tag, print_guppi_element_view);
#endif

  scm_make_gsubr("guppi-element-view?", 1, 0, 0, fn_scm_guppi_element_view_p);
  scm_make_gsubr("guppi-group-state?", 1, 0, 0, fn_scm_guppi_group_state_p);
  scm_make_gsubr("guppi-group-view?", 1, 0, 0, fn_scm_guppi_group_view_p);
  scm_make_gsubr("guppi-root-group-state?", 1, 0, 0, fn_scm_guppi_root_group_state_p);
  scm_make_gsubr("guppi-root-group-view?", 1, 0, 0, fn_scm_guppi_root_group_view_p);
  scm_make_gsubr((gchar*)s_scm_guppi_style_new, 0, 0, 0, fn_scm_guppi_style_new);
  scm_make_gsubr((gchar*)s_scm_guppi_style_stock, 2, 0, 0, fn_scm_guppi_style_stock);
  scm_make_gsubr((gchar*)s_scm_guppi_style_marker_size1, 1, 0, 0, fn_scm_guppi_style_marker_size1);
  scm_make_gsubr((gchar*)s_scm_guppi_style_marker_size2, 1, 0, 0, fn_scm_guppi_style_marker_size2);
  scm_make_gsubr((gchar*)s_scm_guppi_style_color, 1, 0, 0, fn_scm_guppi_style_color);
  scm_make_gsubr((gchar*)s_scm_guppi_style_color_dim, 1, 0, 0, fn_scm_guppi_style_color_dim);
  scm_make_gsubr((gchar*)s_scm_guppi_style_color_bright, 1, 0, 0, fn_scm_guppi_style_color_bright);
  scm_make_gsubr((gchar*)s_scm_guppi_style_line_width, 1, 0, 0, fn_scm_guppi_style_line_width);
  scm_make_gsubr((gchar*)s_scm_guppi_style_set_marker_size1, 2, 0, 0, fn_scm_guppi_style_set_marker_size1);
  scm_make_gsubr((gchar*)s_scm_guppi_style_set_marker_size2, 2, 0, 0, fn_scm_guppi_style_set_marker_size2);
  scm_make_gsubr((gchar*)s_scm_guppi_style_set_color, 2, 0, 0, fn_scm_guppi_style_set_color);
  scm_make_gsubr((gchar*)s_scm_guppi_style_set_color_dim, 2, 0, 0, fn_scm_guppi_style_set_color_dim);
  scm_make_gsubr((gchar*)s_scm_guppi_style_set_color_bright, 2, 0, 0, fn_scm_guppi_style_set_color_bright);
  scm_make_gsubr((gchar*)s_scm_guppi_style_set_line_width, 2, 0, 0, fn_scm_guppi_style_set_line_width);
  scm_make_gsubr((gchar*)s_scm_guppi_style_freeze, 1, 0, 0, fn_scm_guppi_style_freeze);
  scm_make_gsubr((gchar*)s_scm_guppi_style_thaw, 1, 0, 0, fn_scm_guppi_style_thaw);
  scm_make_gsubr((gchar*)s_scm_guppi_style_changed, 1, 0, 0, fn_scm_guppi_style_changed);
  scm_make_gsubr((gchar*)s_scm_guppi_style_changed_delayed, 1, 0, 0, fn_scm_guppi_style_changed_delayed);
  scm_make_gsubr((gchar*)s_scm_guppi_style_flush_changes, 1, 0, 0, fn_scm_guppi_style_flush_changes);
  scm_make_gsubr((gchar*)s_scm_guppi_style_edit_window, 1, 0, 0, fn_scm_guppi_style_edit_window);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_style_new, 0, 0, 0, fn_scm_guppi_seq_style_new);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_style_get, 2, 0, 0, fn_scm_guppi_seq_style_get);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_style_set, 3, 0, 0, fn_scm_guppi_seq_style_set);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_style_prepend, 2, 0, 0, fn_scm_guppi_seq_style_prepend);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_style_append, 2, 0, 0, fn_scm_guppi_seq_style_append);
  scm_make_gsubr((gchar*)s_scm_guppi_seq_style_insert, 3, 0, 0, fn_scm_guppi_seq_style_insert);
  scm_make_gsubr((gchar*)s_scm_guppi_color_gradient_new, 0, 0, 0, fn_scm_guppi_color_gradient_new);
  scm_make_gsubr((gchar*)s_scm_guppi_color_gradient_value, 2, 0, 0, fn_scm_guppi_color_gradient_value);
  scm_make_gsubr((gchar*)s_scm_guppi_color_gradient_set2, 3, 0, 0, fn_scm_guppi_color_gradient_set2);
  scm_make_gsubr((gchar*)s_scm_guppi_color_gradient_set_fade_in, 2, 0, 0, fn_scm_guppi_color_gradient_set_fade_in);
  scm_make_gsubr((gchar*)s_scm_guppi_color_gradient_set_fade_out, 2, 0, 0, fn_scm_guppi_color_gradient_set_fade_out);
  scm_make_gsubr((gchar*)s_scm_guppi_color_gradient_set_fire, 3, 0, 0, fn_scm_guppi_color_gradient_set_fire);
  scm_make_gsubr((gchar*)s_scm_guppi_color_gradient_set_ice, 3, 0, 0, fn_scm_guppi_color_gradient_set_ice);
  scm_make_gsubr((gchar*)s_scm_guppi_color_gradient_set_thermal, 3, 0, 0, fn_scm_guppi_color_gradient_set_thermal);
  scm_make_gsubr((gchar*)s_scm_guppi_color_gradient_set_spectrum, 3, 0, 0, fn_scm_guppi_color_gradient_set_spectrum);
  scm_make_gsubr((gchar*)s_scm_guppi_geometry_new, 0, 0, 0, fn_scm_guppi_geometry_new);
  scm_make_gsubr((gchar*)s_scm_guppi_geometry_left, 1, 0, 0, fn_scm_guppi_geometry_left);
  scm_make_gsubr((gchar*)s_scm_guppi_geometry_right, 1, 0, 0, fn_scm_guppi_geometry_right);
  scm_make_gsubr((gchar*)s_scm_guppi_geometry_top, 1, 0, 0, fn_scm_guppi_geometry_top);
  scm_make_gsubr((gchar*)s_scm_guppi_geometry_bottom, 1, 0, 0, fn_scm_guppi_geometry_bottom);
  scm_make_gsubr((gchar*)s_scm_guppi_geometry_set_position, 5, 0, 0, fn_scm_guppi_geometry_set_position);
  scm_make_gsubr((gchar*)s_scm_guppi_geometry_natural_width, 1, 0, 0, fn_scm_guppi_geometry_natural_width);
  scm_make_gsubr((gchar*)s_scm_guppi_geometry_natural_height, 1, 0, 0, fn_scm_guppi_geometry_natural_height);
  scm_make_gsubr((gchar*)s_scm_guppi_geometry_calc_natural_size, 1, 0, 0, fn_scm_guppi_geometry_calc_natural_size);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_new, 0, 0, 0, fn_scm_guppi_layout_new);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_natural_width, 2, 0, 0, fn_scm_guppi_layout_natural_width);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_natural_height, 2, 0, 0, fn_scm_guppi_layout_natural_height);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_left_edge_relative, 3, 0, 0, fn_scm_guppi_layout_left_edge_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_right_edge_relative, 3, 0, 0, fn_scm_guppi_layout_right_edge_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_top_edge_relative, 3, 0, 0, fn_scm_guppi_layout_top_edge_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_bottom_edge_relative, 3, 0, 0, fn_scm_guppi_layout_bottom_edge_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_flush_left, 3, 0, 0, fn_scm_guppi_layout_flush_left);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_flush_right, 3, 0, 0, fn_scm_guppi_layout_flush_right);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_flush_top, 3, 0, 0, fn_scm_guppi_layout_flush_top);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_flush_bottom, 3, 0, 0, fn_scm_guppi_layout_flush_bottom);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_width_relative, 3, 0, 0, fn_scm_guppi_layout_width_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_height_relative, 3, 0, 0, fn_scm_guppi_layout_height_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_center_horizontally, 2, 0, 0, fn_scm_guppi_layout_center_horizontally);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_center_vertically, 2, 0, 0, fn_scm_guppi_layout_center_vertically);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_horizontal_fill, 4, 0, 0, fn_scm_guppi_layout_horizontal_fill);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_vertical_fill, 4, 0, 0, fn_scm_guppi_layout_vertical_fill);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_aligned_left_edge, 3, 0, 0, fn_scm_guppi_layout_aligned_left_edge);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_aligned_right_edge, 3, 0, 0, fn_scm_guppi_layout_aligned_right_edge);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_aligned_top_edge, 3, 0, 0, fn_scm_guppi_layout_aligned_top_edge);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_aligned_bottom_edge, 3, 0, 0, fn_scm_guppi_layout_aligned_bottom_edge);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_horizontally_adjacent, 4, 0, 0, fn_scm_guppi_layout_horizontally_adjacent);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_vertically_adjacent, 4, 0, 0, fn_scm_guppi_layout_vertically_adjacent);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_hbox2, 4, 0, 0, fn_scm_guppi_layout_hbox2);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_hbox3, 5, 0, 0, fn_scm_guppi_layout_hbox3);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_vbox2, 4, 0, 0, fn_scm_guppi_layout_vbox2);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_vbox3, 5, 0, 0, fn_scm_guppi_layout_vbox3);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_width_ratio, 4, 0, 0, fn_scm_guppi_layout_width_ratio);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_height_ratio, 4, 0, 0, fn_scm_guppi_layout_height_ratio);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_same_width, 3, 0, 0, fn_scm_guppi_layout_same_width);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_same_height, 3, 0, 0, fn_scm_guppi_layout_same_height);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_width_equals_height, 3, 0, 0, fn_scm_guppi_layout_width_equals_height);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_same_size, 3, 0, 0, fn_scm_guppi_layout_same_size);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_same_place, 3, 0, 0, fn_scm_guppi_layout_same_place);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_same_x_center, 3, 0, 0, fn_scm_guppi_layout_same_x_center);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_same_y_center, 3, 0, 0, fn_scm_guppi_layout_same_y_center);
  scm_make_gsubr((gchar*)s_scm_guppi_layout_calc, 1, 0, 0, fn_scm_guppi_layout_calc);
  scm_make_gsubr((gchar*)s_scm_guppi_element_state_newv, 1, 0, 1, fn_scm_guppi_element_state_newv);
  scm_make_gsubr((gchar*)s_scm_guppi_element_state_label, 1, 0, 0, fn_scm_guppi_element_state_label);
  scm_make_gsubr((gchar*)s_scm_guppi_element_state_set_label, 2, 0, 0, fn_scm_guppi_element_state_set_label);
  scm_make_gsubr((gchar*)s_scm_guppi_element_state_make_view, 1, 0, 0, fn_scm_guppi_element_state_make_view);
  scm_make_gsubr((gchar*)s_scm_guppi_element_state_connect, 4, 0, 0, fn_scm_guppi_element_state_connect);
  scm_make_gsubr((gchar*)s_scm_guppi_element_state_spew_xml, 1, 0, 0, fn_scm_guppi_element_state_spew_xml);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_state, 1, 0, 0, fn_scm_guppi_element_view_state);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_set_x_axis_marker_type, 2, 0, 0, fn_scm_guppi_element_view_set_x_axis_marker_type);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_set_y_axis_marker_type, 2, 0, 0, fn_scm_guppi_element_view_set_y_axis_marker_type);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_connect, 4, 0, 0, fn_scm_guppi_element_view_connect);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_set_preferred_x_view, 1, 0, 0, fn_scm_guppi_element_view_set_preferred_x_view);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_set_preferred_y_view, 1, 0, 0, fn_scm_guppi_element_view_set_preferred_y_view);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_set_preferred_view, 1, 0, 0, fn_scm_guppi_element_view_set_preferred_view);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_force_preferred_x_view, 2, 0, 0, fn_scm_guppi_element_view_force_preferred_x_view);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_force_preferred_y_view, 2, 0, 0, fn_scm_guppi_element_view_force_preferred_y_view);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_force_preferred_view, 2, 0, 0, fn_scm_guppi_element_view_force_preferred_view);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_print_ps_to_file, 2, 0, 0, fn_scm_guppi_element_view_print_ps_to_file);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_freeze, 1, 0, 0, fn_scm_guppi_element_view_freeze);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_thaw, 1, 0, 0, fn_scm_guppi_element_view_thaw);
  scm_make_gsubr((gchar*)s_scm_guppi_element_view_spew_xml, 1, 0, 0, fn_scm_guppi_element_view_spew_xml);
  scm_make_gsubr((gchar*)s_scm_guppi_group_state_new, 0, 0, 0, fn_scm_guppi_group_state_new);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_has, 2, 0, 0, fn_scm_guppi_group_view_has);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_add, 2, 0, 0, fn_scm_guppi_group_view_add);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_remove, 2, 0, 0, fn_scm_guppi_group_view_remove);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_replace, 3, 0, 0, fn_scm_guppi_group_view_replace);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_commit_changes, 1, 0, 0, fn_scm_guppi_group_view_commit_changes);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_commit_all_changes, 1, 0, 0, fn_scm_guppi_group_view_commit_all_changes);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_natural_width, 2, 0, 0, fn_scm_guppi_group_view_layout_natural_width);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_natural_height, 2, 0, 0, fn_scm_guppi_group_view_layout_natural_height);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_left_edge_relative, 3, 0, 0, fn_scm_guppi_group_view_layout_left_edge_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_right_edge_relative, 3, 0, 0, fn_scm_guppi_group_view_layout_right_edge_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_top_edge_relative, 3, 0, 0, fn_scm_guppi_group_view_layout_top_edge_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_bottom_edge_relative, 3, 0, 0, fn_scm_guppi_group_view_layout_bottom_edge_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_flush_left, 3, 0, 0, fn_scm_guppi_group_view_layout_flush_left);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_flush_right, 3, 0, 0, fn_scm_guppi_group_view_layout_flush_right);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_flush_top, 3, 0, 0, fn_scm_guppi_group_view_layout_flush_top);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_flush_bottom, 3, 0, 0, fn_scm_guppi_group_view_layout_flush_bottom);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_width_relative, 3, 0, 0, fn_scm_guppi_group_view_layout_width_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_height_relative, 3, 0, 0, fn_scm_guppi_group_view_layout_height_relative);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_center_horizontally, 2, 0, 0, fn_scm_guppi_group_view_layout_center_horizontally);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_center_vertically, 2, 0, 0, fn_scm_guppi_group_view_layout_center_vertically);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_horizontal_fill, 4, 0, 0, fn_scm_guppi_group_view_layout_horizontal_fill);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_vertical_fill, 4, 0, 0, fn_scm_guppi_group_view_layout_vertical_fill);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_aligned_left_edge, 3, 0, 0, fn_scm_guppi_group_view_layout_aligned_left_edge);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_aligned_right_edge, 3, 0, 0, fn_scm_guppi_group_view_layout_aligned_right_edge);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_aligned_top_edge, 3, 0, 0, fn_scm_guppi_group_view_layout_aligned_top_edge);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_aligned_bottom_edge, 3, 0, 0, fn_scm_guppi_group_view_layout_aligned_bottom_edge);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_horizontally_adjacent, 4, 0, 0, fn_scm_guppi_group_view_layout_horizontally_adjacent);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_vertically_adjacent, 4, 0, 0, fn_scm_guppi_group_view_layout_vertically_adjacent);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_hbox2, 4, 0, 0, fn_scm_guppi_group_view_layout_hbox2);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_hbox3, 5, 0, 0, fn_scm_guppi_group_view_layout_hbox3);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_vbox2, 4, 0, 0, fn_scm_guppi_group_view_layout_vbox2);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_vbox3, 5, 0, 0, fn_scm_guppi_group_view_layout_vbox3);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_width_ratio, 4, 0, 0, fn_scm_guppi_group_view_layout_width_ratio);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_height_ratio, 4, 0, 0, fn_scm_guppi_group_view_layout_height_ratio);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_same_width, 3, 0, 0, fn_scm_guppi_group_view_layout_same_width);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_same_height, 3, 0, 0, fn_scm_guppi_group_view_layout_same_height);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_width_equals_height, 3, 0, 0, fn_scm_guppi_group_view_layout_width_equals_height);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_same_size, 3, 0, 0, fn_scm_guppi_group_view_layout_same_size);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_same_place, 3, 0, 0, fn_scm_guppi_group_view_layout_same_place);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_same_x_center, 3, 0, 0, fn_scm_guppi_group_view_layout_same_x_center);
  scm_make_gsubr((gchar*)s_scm_guppi_group_view_layout_same_y_center, 3, 0, 0, fn_scm_guppi_group_view_layout_same_y_center);
  scm_make_gsubr((gchar*)s_scm_guppi_root_group_state_new, 0, 0, 0, fn_scm_guppi_root_group_state_new);
  scm_make_gsubr((gchar*)s_scm_guppi_root_group_view_set_size, 3, 0, 0, fn_scm_guppi_root_group_view_set_size);
  scm_make_gsubr((gchar*)s_scm_guppi_root_group_view_width, 1, 0, 0, fn_scm_guppi_root_group_view_width);
  scm_make_gsubr((gchar*)s_scm_guppi_root_group_view_height, 1, 0, 0, fn_scm_guppi_root_group_view_height);
  scm_make_gsubr((gchar*)s_scm_guppi_root_group_view_show_in_window, 1, 0, 0, fn_scm_guppi_root_group_view_show_in_window);
}
