/* This is -*- C -*- */
/* $Id: guppi-root-group-view.c,v 1.6 2001/01/16 23:36:34 trow Exp $ */

/*
 * guppi-root-group-view.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#include <libgnome/gnome-i18n.h>

#include <guppi-useful.h>
#include "guppi-root-group-state.h"
#include "guppi-root-group-view.h"
#include "guppi-root-group-item.h"
#include "guppi-plot-window.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_root_group_view_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_root_group_view_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_root_group_view_destroy (GtkObject * obj)
{
  GuppiRootGroupView *view = GUPPI_ROOT_GROUP_VIEW (obj);

  if (view->configure_window) {
    gtk_widget_destroy (view->configure_window);
    view->configure_window = NULL;
    view->configure = NULL;
  }

  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_root_group_view_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/*****************************************************************************/

static void
state_changed (GuppiElementView * view)
{
  if (GUPPI_ELEMENT_VIEW_CLASS (parent_class)->state_changed)
    (GUPPI_ELEMENT_VIEW_CLASS (parent_class)->state_changed) (view);
}

static void
view_init (GuppiElementView * view)
{

}

static GuppiConfigItem *
assemble_config_tree (GuppiElementView * view,
		      GuppiConfigItem * state_tree,
		      GuppiConfigItem * view_tree)
{
  if (view_tree)
    guppi_config_item_append (view_tree, state_tree);
  return view_tree;
}

static void
changed_structure (GuppiElementView * view)
{
  GuppiRootGroupView *root_view = GUPPI_ROOT_GROUP_VIEW (view);

  if (root_view->configure)
    guppi_configure_set_item_tree (root_view->configure,
				   guppi_element_view_config_tree (view));
}

static void
guppi_root_group_view_class_init (GuppiRootGroupViewClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiElementViewClass *view_class = GUPPI_ELEMENT_VIEW_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_GROUP_VIEW);

  object_class->get_arg = guppi_root_group_view_get_arg;
  object_class->set_arg = guppi_root_group_view_set_arg;
  object_class->destroy = guppi_root_group_view_destroy;
  object_class->finalize = guppi_root_group_view_finalize;

  view_class->canvas_item_type = GUPPI_TYPE_ROOT_GROUP_ITEM;
  view_class->state_changed = state_changed;
  view_class->view_init = view_init;
  view_class->assemble_config_tree = assemble_config_tree;
  view_class->changed_structure = changed_structure;

}

/*****************************************************************************/

static void
guppi_root_group_view_init (GuppiRootGroupView * obj)
{
  GuppiGeometry *geom =
    guppi_element_view_geometry (GUPPI_ELEMENT_VIEW (obj));

  obj->width = guppi_in2pt (5);
  obj->height = guppi_in2pt (4);

  guppi_geometry_set_position (geom, 0, obj->width, 0, obj->height);
}

GtkType guppi_root_group_view_get_type (void)
{
  static GtkType guppi_root_group_view_type = 0;
  if (!guppi_root_group_view_type) {
    static const GtkTypeInfo guppi_root_group_view_info = {
      "GuppiRootGroupView",
      sizeof (GuppiRootGroupView),
      sizeof (GuppiRootGroupViewClass),
      (GtkClassInitFunc) guppi_root_group_view_class_init,
      (GtkObjectInitFunc) guppi_root_group_view_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_root_group_view_type =
      gtk_type_unique (GUPPI_TYPE_GROUP_VIEW, &guppi_root_group_view_info);
  }
  return guppi_root_group_view_type;
}

/*****************************************************************************/

void
guppi_root_group_view_set_size (GuppiRootGroupView * view, double w, double h)
{
  g_return_if_fail (view != NULL && GUPPI_IS_ROOT_GROUP_VIEW (view));
  g_return_if_fail (w >= 0 && h >= 0);

  if (view->width != w || view->height != h) {

    GuppiGeometry *geom =
      guppi_element_view_geometry (GUPPI_ELEMENT_VIEW (view));

    view->width = w;
    view->height = h;

    guppi_geometry_set_position (geom, 0, view->width, 0, view->height);

    guppi_element_view_changed_delayed (GUPPI_ELEMENT_VIEW (view));
  }
}

double
guppi_root_group_view_width (GuppiRootGroupView * view)
{
  g_return_val_if_fail (view != NULL && GUPPI_IS_ROOT_GROUP_VIEW (view), 0);
  return view->width;
}

double
guppi_root_group_view_height (GuppiRootGroupView * view)
{
  g_return_val_if_fail (view != NULL && GUPPI_IS_ROOT_GROUP_VIEW (view), 0);
  return view->height;
}

/*****************************************************************************/

static gint
delete_event_cb (GtkWidget * w, GdkEventAny * ev, gpointer ptr)
{
  GuppiRootGroupView *view = GUPPI_ROOT_GROUP_VIEW (ptr);

  view->configure_window = NULL;
  view->configure = NULL;
  return FALSE;
}

void
guppi_root_group_view_show_configure_window (GuppiRootGroupView * view)
{
  if (view->configure_window) {

    gdk_window_show (view->configure_window->window);
    gdk_window_raise (view->configure_window->window);

  } else {
    
    GtkWidget *box = gtk_vbox_new (FALSE, 0);
    GtkWidget *b = gnome_stock_button (GNOME_STOCK_BUTTON_CLOSE);

    view->configure_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (view->configure_window),
			  _("Configure Plot"));

    gtk_container_add (GTK_CONTAINER (view->configure_window), box);

    gtk_box_pack_start (GTK_BOX (box),
			GTK_WIDGET (guppi_root_group_view_configurer (view)),
			TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (box), b, FALSE, FALSE, 0);
    
    gtk_signal_connect_object (GTK_OBJECT (b),
			       "clicked",
			       GTK_SIGNAL_FUNC (guppi_root_group_view_hide_configure_window),
			       GTK_OBJECT (view));

    gtk_signal_connect (GTK_OBJECT (view->configure_window),
			"delete_event",
			GTK_SIGNAL_FUNC (delete_event_cb),
			view);

    gtk_widget_show_all (view->configure_window);
  }
}

void
guppi_root_group_view_hide_configure_window (GuppiRootGroupView * view)
{
  if (view->configure_window)
    gdk_window_hide (view->configure_window->window);
}

GuppiConfigure *
guppi_root_group_view_configurer (GuppiRootGroupView * view)
{
  GuppiConfigItem *item_tree;

  g_return_val_if_fail (view != NULL
			&& GUPPI_IS_ROOT_GROUP_VIEW (view), NULL);

  if (view->configure == NULL) {
    view->configure = GUPPI_CONFIGURE (guppi_configure_new ());
    item_tree = guppi_element_view_config_tree (GUPPI_ELEMENT_VIEW (view));
    guppi_configure_set_item_tree (view->configure, item_tree);
  }

  return view->configure;
}

void
guppi_root_group_view_show_in_window (GuppiRootGroupView * grp)
{
  GtkWidget *w;

  g_return_if_fail (grp && GUPPI_IS_ROOT_GROUP_VIEW (grp));

  /* We commit any changes, just for convenience... */
  guppi_group_view_commit_all_changes (GUPPI_GROUP_VIEW (grp));

  w = guppi_plot_window_new (grp);
  gtk_widget_show_all (w);
}


/* $Id: guppi-root-group-view.c,v 1.6 2001/01/16 23:36:34 trow Exp $ */
