/* This is -*- C -*- */
/* $Id: guppi-element-state.h,v 1.14 2001/01/16 23:36:26 trow Exp $ */

/*
 * guppi-element-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_ELEMENT_STATE_H
#define _INC_GUPPI_ELEMENT_STATE_H

/* #include <gnome.h> */
#include <guppi-unique-id.h>
#include <guppi-config-item.h>
#include <guppi-output-xml.h>
#include <guppi-attributes-xml.h>
#include "guppi-shared-hash.h"
#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

/* forward defs */
struct _GuppiElementView;

typedef struct _GuppiElementState GuppiElementState;
typedef struct _GuppiElementStateClass GuppiElementStateClass;

struct _GuppiElementState {
  GtkObject parent;
  gpointer opaque_internals;
};

struct _GuppiElementStateClass {
  GtkObjectClass parent_class;

  const gchar *name;
  const gchar *plug_in_code;

  /* --- VTable --- */

  GtkType view_type;
  struct _GuppiElementView *(*make_view) (GuppiElementState *);
  GuppiConfigItem *(*config_tree) (GuppiElementState *);

  /* XML output */
  void (*write_xml_attributes) (GuppiElementState *, GuppiOutputXML *);
  void (*write_xml_other) (GuppiElementState *, GuppiOutputXML *);

  /* XML input */
  void (*prepare_xml_attributes) (GuppiAttributesXML *);
  void (*init_xml_object) (GuppiElementState *, GuppiAttributesXML *);

  /* Signals */
  void (*changed) (GuppiElementState *);
  void (*changed_size) (GuppiElementState *);
};

#define GUPPI_TYPE_ELEMENT_STATE (guppi_element_state_get_type())
#define GUPPI_ELEMENT_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_ELEMENT_STATE,GuppiElementState))
#define GUPPI_ELEMENT_STATE0(obj) ((obj) ? (GUPPI_ELEMENT_STATE(obj)) : NULL)
#define GUPPI_ELEMENT_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_ELEMENT_STATE,GuppiElementStateClass))
#define GUPPI_IS_ELEMENT_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_ELEMENT_STATE))
#define GUPPI_IS_ELEMENT_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_ELEMENT_STATE(obj)))
#define GUPPI_IS_ELEMENT_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_ELEMENT_STATE))

GtkType guppi_element_state_get_type (void);

GuppiElementState *guppi_element_state_new (const gchar * type,
					    const gchar * first_arg_name,
					    ...);
GuppiElementState *guppi_element_state_newv (const gchar * type, guint nargs,
					     GtkArg * args);

guppi_uniq_t guppi_element_state_unique_id (GuppiElementState *);

const gchar *guppi_element_state_label (GuppiElementState *);
void guppi_element_state_set_label (GuppiElementState *, const gchar *);

struct _GuppiElementView *guppi_element_state_make_view (GuppiElementState *);


void guppi_element_state_add_shared (GuppiElementState *,
				     const gchar * key, GuppiShared *);
void guppi_element_state_set_shared (GuppiElementState *,
				     const gchar * key, gpointer obj_or_null);
GtkObject *guppi_element_state_get_shared (GuppiElementState *,
					   const gchar * key);


void guppi_element_state_connect (GuppiElementState * s1, const gchar * key1,
				  GuppiElementState * s2, const gchar * key2);


void guppi_element_state_changed (GuppiElementState *);
void guppi_element_state_changed_delayed (GuppiElementState *);
void guppi_element_state_changed_size (GuppiElementState *);

void guppi_element_state_connect_to_object (GuppiElementState *,
					    const gchar * signal_name,
					    GtkObject *);
void guppi_element_state_disconnect_from_object (GuppiElementState *,
						 GtkObject *);

void guppi_element_state_write_xml (GuppiElementState *, GuppiOutputXML *);
void guppi_element_state_spew_xml (GuppiElementState *);

GuppiContextXML *guppi_element_state_read_xml_context (void (*)(GuppiElementState *, gpointer), gpointer user_data);


END_GUPPI_DECLS

#endif /* _INC_GUPPI_ELEMENT_STATE_H */

/* $Id: guppi-element-state.h,v 1.14 2001/01/16 23:36:26 trow Exp $ */
