/* $Id: guppi-data-ui-init.c,v 1.1 2000/10/15 22:03:04 trow Exp $ */

/*
 * guppi-data-ui-init.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>

#include <guppi-scripting.h>

#include <guppi-guile.h>
#include "guppi-scm-data-ui.h"

#ifdef HAVE_PYTHON
#include <guppi-python.h>
#include "guppi-python-data-ui.h"
#endif

#include "guppi-data-ui-init.h"

void
guppi_data_ui_init (void)
{
  if (guppi_supports_guile () && guppi_guile_is_active ())
    guppi_scm_data_ui_init ();

#ifdef HAVE_PYTHON
  if (guppi_supports_python () && guppi_python_is_active ())
    guppi_python_data_ui_init ();
#endif
}




/* $Id: guppi-data-ui-init.c,v 1.1 2000/10/15 22:03:04 trow Exp $ */
