/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-date-series-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATE_SERIES_IMPL_H
#define _INC_GUPPI_DATE_SERIES_IMPL_H

/* #include <gnome.h> */
#include <guppi-defs.h>
#include "guppi-date-indexed-impl.h"

BEGIN_GUPPI_DECLS

typedef struct _GuppiDateSeriesImpl GuppiDateSeriesImpl;
typedef struct _GuppiDateSeriesImplClass GuppiDateSeriesImplClass;

struct _GuppiDateSeriesImpl {
  GuppiDateIndexedImpl parent;
};

struct _GuppiDateSeriesImplClass {
  GuppiDateIndexedImplClass parent_class;

  double (*get) (GuppiDateSeriesImpl *, GDate *);
  void (*set) (GuppiDateSeriesImpl *, GDate *, double);
  void (*unset) (GuppiDateSeriesImpl *, GDate *);
  gboolean (*get_many) (GuppiDateSeriesImpl *, GDate *, gint, double *,
			gint *retval);
  gboolean (*get_range) (GuppiDateSeriesImpl *, GDate *, GDate *,
			 double *timecode, double *buffer, gint bufsize,
			 gint *retval);
  gboolean (*get_bounds) (GuppiDateSeriesImpl *, GDate *, GDate *,
			  double *, double *,
			  gboolean *retval);
};

#define GUPPI_TYPE_DATE_SERIES_IMPL (guppi_date_series_impl_get_type ())
#define GUPPI_DATE_SERIES_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_DATE_SERIES_IMPL,GuppiDateSeriesImpl))
#define GUPPI_DATE_SERIES_IMPL0(obj) ((obj) ? (GUPPI_DATE_SERIES_IMPL(obj)) : NULL)
#define GUPPI_DATE_SERIES_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_DATE_SERIES_IMPL,GuppiDateSeriesImplClass))
#define GUPPI_IS_DATE_SERIES_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_DATE_SERIES_IMPL))
#define GUPPI_IS_DATE_SERIES_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_DATE_SERIES_IMPL(obj)))
#define GUPPI_IS_DATE_SERIES_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_DATE_SERIES_IMPL))

GtkType guppi_date_series_impl_get_type (void);

GtkObject *guppi_date_series_impl_new (void);



END_GUPPI_DECLS

#endif /* _INC_GUPPI_DATE_SERIES_IMPL_H */

/* $Id: guppi-date-series-impl.h,v 1.3 2001/01/16 23:36:12 trow Exp $ */
