/* This is -*- C -*- */
/* $Id: guppi-data.h,v 1.19 2001/01/16 23:36:12 trow Exp $ */

/*
 * guppi-data.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATA_H
#define _INC_GUPPI_DATA_H

/* #include <gtk/gtk.h> */
#include <guppi-unique-id.h>
#include "guppi-data-impl.h"
#include <guppi-attributes-xml.h>
#include <guppi-context-xml.h>
#include <guppi-output-xml.h>
#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiData GuppiData;
typedef struct _GuppiDataClass GuppiDataClass;
typedef struct _GuppiDataOp GuppiDataOp;

struct _GuppiDataOp {
  void (*op) (GuppiData *, GuppiDataOp *);
};

struct _GuppiData {
  GtkObject parent;

  guppi_uniq_t id;
  gchar *label;
  gboolean read_only;

  GuppiDataImpl *impl;
  gpointer pending_ops;
};

struct _GuppiDataClass {
  GtkObjectClass parent_class;

  const gchar *type_name;
  const gchar *type_name_for_impl_lookup;
  GtkType impl_type;

  /* XML Output */
  void (*write_xml_attributes) (GuppiData *, GuppiOutputXML *out);
  void (*write_xml_content) (GuppiData *, GuppiOutputXML *out);

  /* XML Input */
  void (*prepare_xml_attributes) (GuppiAttributesXML *);
  GuppiData *(*create_xml_object) (GuppiAttributesXML *);
  void (*init_xml_object) (GuppiData *, GuppiAttributesXML *);
  GuppiContextXML *(*content_xml_context) (GuppiData *, GuppiAttributesXML *);

  /* Menu Hook */
  void (*build_menu) (GuppiData *, GtkMenu *, gpointer data_tree);

  /* Info Display Hook */
  GtkWidget *(*info_display) (GuppiData *);

  /* signals */
  void (*changed) (GuppiData *);
  void (*changed_label) (GuppiData *, const gchar *);
  void (*changed_subdata) (GuppiData *);
};

#define GUPPI_TYPE_DATA (guppi_data_get_type())
#define GUPPI_DATA(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_DATA,GuppiData))
#define GUPPI_DATA0(obj) ((obj) ? (GUPPI_DATA(obj)) : NULL)
#define GUPPI_DATA_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_DATA,GuppiDataClass))
#define GUPPI_IS_DATA(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_DATA))
#define GUPPI_IS_DATA0(obj) (((obj) == NULL) || (GUPPI_IS_DATA(obj)))
#define GUPPI_IS_DATA_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_DATA))

GtkType guppi_data_get_type (void);

GuppiData *guppi_data_new_by_type (GtkType type, GtkType impl_type,
				   const gchar * first_arg_name, ...);
GuppiData *guppi_data_newv_by_type (GtkType type, GtkType impl_type,
				    guint nargs, GtkArg * args);

GuppiData *guppi_data_new (GtkType type,
			   const gchar * impl_name,
			   const gchar * first_arg_name, ...);
GuppiData *guppi_data_newv (GtkType type,
			    const gchar * impl_name,
			    guint nargs, GtkArg * args);


GuppiDataImpl *guppi_data_impl (GuppiData *);

const gchar *guppi_data_get_type_name (const GuppiData *);
const gchar *guppi_data_get_impl_name (const GuppiData *);

guppi_uniq_t guppi_data_unique_id (GuppiData *);

#define guppi_data_label(x) guppi_data_get_label(x)

const gchar *guppi_data_get_label (const GuppiData *);
void guppi_data_set_label (GuppiData *, const gchar *);

gboolean guppi_data_is_read_only (GuppiData *);
gboolean guppi_data_can_change (GuppiData *);

void guppi_data_add_pending_op (GuppiData *, GuppiDataOp *);
void guppi_data_changed (GuppiData *);

/* If you just want to get a GuppiData object to emit a generic
 * "changed" signal, call this.
 */
void guppi_data_touch (GuppiData *);
void guppi_data_touch_subdata (GuppiData *);

GuppiData *guppi_data_copy (const GuppiData *);
gint guppi_data_get_size_in_bytes (GuppiData *);
void guppi_data_get_size_info (GuppiData *, gchar *, gsize);

void guppi_data_write_xml (GuppiData *, GuppiOutputXML *output);
void guppi_data_spew_xml (GuppiData *);

GuppiContextXML *guppi_data_read_xml_context (void (*)(GuppiData *, gpointer),
					      gpointer user_data);
					      
GuppiData *guppi_data_read_xml_file (const gchar *filename);
gboolean guppi_data_identify_xml_file (const gchar *filename);

gboolean guppi_data_has_subdata (GuppiData *);
gint guppi_data_subdata_count (GuppiData *);
void guppi_data_foreach_subdata (GuppiData *,
				 void (*fn) (GuppiData *, gpointer),
				 gpointer user_data);

void guppi_data_build_menu (GuppiData *, GtkMenu *, gpointer data_tree);
GtkWidget *guppi_data_info_display (GuppiData *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_DATA_H */

/* $Id: guppi-data.h,v 1.19 2001/01/16 23:36:12 trow Exp $ */
