/* This is -*- C -*- */
/* $Id: guppi-data-impl.h,v 1.15 2001/01/16 23:36:12 trow Exp $ */

/*
 * guppi-data-impl.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_DATA_IMPL_H
#define _INC_GUPPI_DATA_IMPL_H

/* #include <gtk/gtk.h> */
#include <gtk/gtkmenu.h>

#include <guppi-output-xml.h>
#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

struct _GuppiData; /* forward decl */
typedef struct _GuppiDataImpl GuppiDataImpl;

struct _GuppiDataImpl {
  GtkObject parent;
};

typedef struct {
  GtkObjectClass parent_class;

  gboolean read_only;

  const gchar *impl_name;

  /* signals */
  void (*changed) (GuppiDataImpl *);
  void (*changed_subdata) (GuppiDataImpl *);

  /* virtual functions */
  GuppiDataImpl *(*copy) (GuppiDataImpl *);
  gint (*get_size_in_bytes) (GuppiDataImpl *);
  void (*get_size_info) (GuppiDataImpl *, gchar *, gsize);

  void (*write_xml) (GuppiDataImpl *, GuppiOutputXML *);
  
  void (*build_menu) (GuppiDataImpl *, GtkMenu *, gpointer data_tree);
  GtkWidget *(*info_display) (GuppiDataImpl *);

  void (*foreach_subdata) (GuppiDataImpl *, 
			   void (*fn) (struct _GuppiData *, gpointer),
			   gpointer user_data);
			   

} GuppiDataImplClass;

#define GUPPI_TYPE_DATA_IMPL (guppi_data_impl_get_type())
#define GUPPI_DATA_IMPL(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_DATA_IMPL,GuppiDataImpl))
#define GUPPI_DATA_IMPL0(obj) ((obj) ? (GUPPI_DATA_IMPL(obj)) : NULL)
#define GUPPI_DATA_IMPL_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_DATA_IMPL,GuppiDataImplClass))
#define GUPPI_IS_DATA_IMPL(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_DATA_IMPL))
#define GUPPI_IS_DATA_IMPL0(obj) (((obj) == NULL) || (GUPPI_IS_DATA_IMPL(obj)))
#define GUPPI_IS_DATA_IMPL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_DATA_IMPL))

GtkType guppi_data_impl_get_type (void);

const gchar *guppi_data_impl_get_impl_name (GuppiDataImpl *);

void guppi_data_impl_changed (GuppiDataImpl *);
void guppi_data_impl_changed_subdata (GuppiDataImpl *);
void guppi_data_impl_touch (GuppiDataImpl *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_DATA_IMPL_H */

/* $Id: guppi-data-impl.h,v 1.15 2001/01/16 23:36:12 trow Exp $ */
