/* This is -*- C -*- */
/* $Id: guppi-seq-date-core-impl.c,v 1.7 2001/01/16 23:35:51 trow Exp $ */

/*
 * guppi-seq-date-core-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
/* #include <gnome.h> */
#include <guppi-convenient.h>
#include <guppi-data-impl-plug-in.h>
#include "guppi-seq-date-core-impl.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_seq_date_core_impl_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_date_core_impl_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_date_core_impl_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_seq_date_core_impl_finalize (GtkObject * obj)
{
  GuppiSeqDateCoreImpl *impl = GUPPI_SEQ_DATE_CORE_IMPL (obj);

  guppi_unref0 (impl->garray);

  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/*****************************************************************************/

static GDate *
v_seq_date_get (GuppiSeqDateImpl * impl, gint i)
{
  GuppiSeqDateCoreImpl *core = GUPPI_SEQ_DATE_CORE_IMPL (impl);
  GDate *data;
  data = (GDate *) guppi_garray_data (core->garray);
  i -= core->index_basis;
  return &data[i];
}

static void
v_seq_date_set (GuppiSeqDateImpl * impl, gint i, GDate * dt)
{
  GuppiSeqDateCoreImpl *core = GUPPI_SEQ_DATE_CORE_IMPL (impl);
  GDate *data;
  data = (GDate *) guppi_garray_data (core->garray);
  data[i - core->index_basis] = *dt;
  guppi_seq_impl_set_missing (GUPPI_SEQ_IMPL (impl), i, FALSE);
}

static void
v_seq_date_insert (GuppiSeqDateImpl * impl, gint i, GDate * dt)
{
  GuppiSeqDateCoreImpl *core = GUPPI_SEQ_DATE_CORE_IMPL (impl);
  GDate *data;
  gint j;

  if (core->size == 0)
    core->index_basis = i;

  i -= core->index_basis;

  if (guppi_garray_size (core->garray) <= core->size)
    guppi_garray_set_size (core->garray, MAX (20, 2 * core->size));

  data = (GDate *) guppi_garray_data (core->garray);
  for (j = core->size - 1; i <= j; --j)
    data[j + 1] = data[j];
  data[i] = *dt;
  ++core->size;

  guppi_seq_impl_insert_missing (GUPPI_SEQ_IMPL (impl), i + core->index_basis,
				 FALSE, 1);
}

static void
v_seq_size_hint (GuppiSeqImpl * impl, gsize n)
{
  GuppiSeqDateCoreImpl *core = GUPPI_SEQ_DATE_CORE_IMPL (impl);

  if (guppi_garray_size (core->garray) < n)
    guppi_garray_set_size (core->garray, n);
}

static void
v_seq_get_bounds (const GuppiSeqImpl * impl, gint * min, gint * max)
{
  const GuppiSeqDateCoreImpl *core = GUPPI_SEQ_DATE_CORE_IMPL (impl);

  if (min)
    *min = core->index_basis;

  if (max)
    *max = core->index_basis - 1 + core->size;
}

static void
v_seq_shift_indices (GuppiSeqImpl * impl, gint delta)
{
  GuppiSeqDateCoreImpl *core = GUPPI_SEQ_DATE_CORE_IMPL (impl);
  core->index_basis += delta;
}

static void
v_seq_insert_missing (GuppiSeqImpl * impl, gint i)
{
  GDate dt;
  v_seq_date_insert (GUPPI_SEQ_DATE_IMPL (impl), i, &dt);
  guppi_seq_impl_set_missing (impl, i, TRUE);
}

static void
v_seq_delete_many (GuppiSeqImpl * impl, gint i, gsize N)
{
  GuppiSeqDateCoreImpl *core = GUPPI_SEQ_DATE_CORE_IMPL (impl);
  GDate *data;
  gint j;

  data = (GDate *) guppi_garray_data (core->garray);
  i -= core->index_basis;

  for (j = i; j + N < core->size; ++j)
    data[j] = data[j + N];

  core->size -= N;

  guppi_seq_impl_delete_missing (impl, i + core->index_basis, N);
}

static GuppiDataImpl *
v_data_copy (GuppiDataImpl * impl)
{
  g_assert_not_reached ();
  return NULL;
}

static gint
v_data_size_in_bytes (GuppiDataImpl * impl)
{
  GuppiSeqDateCoreImpl *core = GUPPI_SEQ_DATE_CORE_IMPL (impl);
  return guppi_garray_size (core->garray) * sizeof (GDate) +
    sizeof (GuppiSeqDateCoreImpl);
}

static void
guppi_seq_date_core_impl_class_init (GuppiSeqDateCoreImplClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiSeqDateImplClass *impl_class = GUPPI_SEQ_DATE_IMPL_CLASS (klass);
  GuppiSeqImplClass *seq_class = GUPPI_SEQ_IMPL_CLASS (klass);
  GuppiDataImplClass *data_class = GUPPI_DATA_IMPL_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_SEQ_DATE_IMPL);

  impl_class->get = v_seq_date_get;
  impl_class->set = v_seq_date_set;
  impl_class->insert = v_seq_date_insert;

  seq_class->size_hint = v_seq_size_hint;
  seq_class->get_bounds = v_seq_get_bounds;
  seq_class->shift_indices = v_seq_shift_indices;
  seq_class->insert_missing = v_seq_insert_missing;
  seq_class->delete_many = v_seq_delete_many;

  data_class->copy = v_data_copy;
  data_class->get_size_in_bytes = v_data_size_in_bytes;

  object_class->get_arg = guppi_seq_date_core_impl_get_arg;
  object_class->set_arg = guppi_seq_date_core_impl_set_arg;
  object_class->destroy = guppi_seq_date_core_impl_destroy;
  object_class->finalize = guppi_seq_date_core_impl_finalize;

}

static void
guppi_seq_date_core_impl_init (GuppiSeqDateCoreImpl * obj)
{
  obj->index_basis = 0;
  obj->size = 0;
  obj->garray = guppi_garray_new (sizeof (GDate));
}

GtkType guppi_seq_date_core_impl_get_type (void)
{
  static GtkType guppi_seq_date_core_impl_type = 0;
  if (!guppi_seq_date_core_impl_type) {
    static const GtkTypeInfo guppi_seq_date_core_impl_info = {
      "GuppiSeqDateCoreImpl",
      sizeof (GuppiSeqDateCoreImpl),
      sizeof (GuppiSeqDateCoreImplClass),
      (GtkClassInitFunc) guppi_seq_date_core_impl_class_init,
      (GtkObjectInitFunc) guppi_seq_date_core_impl_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_seq_date_core_impl_type =
      gtk_type_unique (GUPPI_TYPE_SEQ_DATE_IMPL,
		       &guppi_seq_date_core_impl_info);
  }
  return guppi_seq_date_core_impl_type;
}

/****************************************************************************/

static GuppiDataImpl *
make_impl (void)
{
  return
    GUPPI_DATA_IMPL (guppi_type_new (guppi_seq_date_core_impl_get_type ()));
}

GuppiPlugIn *guppi_plug_in (void);

GuppiPlugIn *
guppi_plug_in (void)
{
  GuppiPlugIn *pi;
  GuppiDataImplPlugIn *dimpi;

  pi = guppi_data_impl_plug_in_new ();
  dimpi = GUPPI_DATA_IMPL_PLUG_IN (pi);

  pi->magic_number = GUPPI_PLUG_IN_MAGIC_NUMBER;
  dimpi->impl_constructor = make_impl;

  return pi;
}


/* $Id: guppi-seq-date-core-impl.c,v 1.7 2001/01/16 23:35:51 trow Exp $ */
