/* This is -*- C -*- */
/* $Id: guppi-raster-text.c,v 1.7 2000/12/17 05:24:57 trow Exp $ */

/*
 * guppi-raster-text.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-convenient.h>
#include "guppi-raster-text.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_raster_text_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_raster_text_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_raster_text_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_raster_text_finalize (GtkObject * obj)
{
  GuppiRasterText *grt = GUPPI_RASTER_TEXT (obj);

  guppi_finalized (obj);

  guppi_free (grt->text);
  grt->text = NULL;

  guppi_unref0 (grt->font);
  guppi_unref0 (grt->template);

  if (parent_class->finalize)
    parent_class->finalize (obj);
}

static void
guppi_raster_text_class_init (GuppiRasterTextClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;

  parent_class = gtk_type_class (GTK_TYPE_OBJECT);

  object_class->get_arg = guppi_raster_text_get_arg;
  object_class->set_arg = guppi_raster_text_set_arg;
  object_class->destroy = guppi_raster_text_destroy;
  object_class->finalize = guppi_raster_text_finalize;

}

static void
guppi_raster_text_init (GuppiRasterText * obj)
{

}

GtkType guppi_raster_text_get_type (void)
{
  static GtkType guppi_raster_text_type = 0;
  if (!guppi_raster_text_type) {
    static const GtkTypeInfo guppi_raster_text_info = {
      "GuppiRasterText",
      sizeof (GuppiRasterText),
      sizeof (GuppiRasterTextClass),
      (GtkClassInitFunc) guppi_raster_text_class_init,
      (GtkObjectInitFunc) guppi_raster_text_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_raster_text_type =
      gtk_type_unique (GTK_TYPE_OBJECT, &guppi_raster_text_info);
  }
  return guppi_raster_text_type;
}

GuppiRasterText *
guppi_raster_text_new (void)
{
  return GUPPI_RASTER_TEXT (guppi_type_new (guppi_raster_text_get_type ()));
}

gboolean
guppi_raster_text_rasterize_full (GuppiRasterText * grt,
				  const gchar * text,
				  GnomeFont * font, double scale,
				  double theta,
				  gboolean filled, double outline_width)
{
  g_return_val_if_fail (grt != NULL, FALSE);
  g_return_val_if_fail (text != NULL, FALSE);
  g_return_val_if_fail (font != NULL, FALSE);
  g_return_val_if_fail (scale >= 0, FALSE);

  if (grt->template == NULL ||
      grt->font != font ||
      grt->scale != scale ||
      grt->theta != theta ||
      grt->filled != filled ||
      (!grt->filled && grt->outline_width != outline_width) ||
      (grt->text != NULL && strcmp (grt->text, text))) {

    guppi_free (grt->text);
    grt->text = guppi_strdup (text);

    if (grt->font != font) {
      guppi_unref (grt->font);
      grt->font = font;
      guppi_ref (grt->font);
    }

    grt->scale = scale;
    grt->theta = theta;
    grt->filled = filled;
    grt->outline_width = outline_width;

    guppi_unref (grt->template);

    grt->template = guppi_alpha_template_text_general (grt->font,
						       grt->scale,
						       grt->text,
						       grt->theta,
						       grt->filled,
						       grt->outline_width);

    return TRUE;
  }

  return FALSE;
}

gboolean
guppi_raster_text_rasterize_again (GuppiRasterText * grt, const gchar * text)
{
  g_return_val_if_fail (grt != NULL, FALSE);
  g_return_val_if_fail (text != NULL, FALSE);
  g_return_val_if_fail (grt->text != NULL, FALSE);

  return guppi_raster_text_rasterize_full (grt,
					   text,
					   grt->font,
					   grt->scale,
					   grt->theta,
					   grt->filled, grt->outline_width);
}



/* $Id: guppi-raster-text.c,v 1.7 2000/12/17 05:24:57 trow Exp $ */
