/* This is -*- C -*- */
/* $Id: guppi-seq-scalar-impl.c,v 1.10 2000/12/14 20:23:04 trow Exp $ */

/*
 * guppi-seq-scalar-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <stdlib.h>
#include <math.h>
#include <guppi-memory.h>
#include "guppi-seq-scalar-impl.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_seq_scalar_impl_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_scalar_impl_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_seq_scalar_impl_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_seq_scalar_impl_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/*****************************************************************************/

/* Some handy default methods */

static gboolean
v_seq_validate (const GuppiSeqImpl *impl, const gchar *str,
		gchar *error_msg, gsize errlen)
{
  return TRUE;
}

static void
v_seq_get (const GuppiSeqImpl * impl, gint i, gchar * buf, gsize len)
{
  GuppiSeqScalarImpl *ssimpl = GUPPI_SEQ_SCALAR_IMPL (impl);
  GuppiSeqScalarImplClass *klass;
  double x;

  klass = GUPPI_SEQ_SCALAR_IMPL_CLASS (GTK_OBJECT (impl)->klass);

  x = klass->get (ssimpl, i);
  g_snprintf (buf, len, "%f", x);
}

static void
v_seq_set (GuppiSeqImpl * impl, gint i, const gchar * buf)
{
  GuppiSeqScalarImpl *ssimpl = GUPPI_SEQ_SCALAR_IMPL (impl);
  GuppiSeqScalarImplClass *klass;
  klass = GUPPI_SEQ_SCALAR_IMPL_CLASS (GTK_OBJECT (impl)->klass);
  klass->set (ssimpl, i, atof (buf));
}

static void
v_seq_insert (GuppiSeqImpl * impl, gint i, const gchar * buf)
{
  GuppiSeqScalarImpl *ssimpl = GUPPI_SEQ_SCALAR_IMPL (impl);
  GuppiSeqScalarImplClass *klass;
  double x = atof (buf);

  klass = GUPPI_SEQ_SCALAR_IMPL_CLASS (GTK_OBJECT (impl)->klass);

  if (klass->insert)
    klass->insert (ssimpl, i, x);
  else
    klass->insert_many (ssimpl, i, &x, 0, 1);
}


/*****************************************************************************/

static void
guppi_seq_scalar_impl_class_init (GuppiSeqScalarImplClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiSeqImplClass *seq_impl_class = GUPPI_SEQ_IMPL_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_SEQ_IMPL);

  object_class->get_arg = guppi_seq_scalar_impl_get_arg;
  object_class->set_arg = guppi_seq_scalar_impl_set_arg;
  object_class->destroy = guppi_seq_scalar_impl_destroy;
  object_class->finalize = guppi_seq_scalar_impl_finalize;

  seq_impl_class->validate = v_seq_validate;
  seq_impl_class->get = v_seq_get;
  seq_impl_class->set = v_seq_set;
  seq_impl_class->insert = v_seq_insert;

}

static void
guppi_seq_scalar_impl_init (GuppiSeqScalarImpl * obj)
{

}

GtkType guppi_seq_scalar_impl_get_type (void)
{
  static GtkType guppi_seq_scalar_impl_type = 0;
  if (!guppi_seq_scalar_impl_type) {
    static const GtkTypeInfo guppi_seq_scalar_impl_info = {
      "GuppiSeqScalarImpl",
      sizeof (GuppiSeqScalarImpl),
      sizeof (GuppiSeqScalarImplClass),
      (GtkClassInitFunc) guppi_seq_scalar_impl_class_init,
      (GtkObjectInitFunc) guppi_seq_scalar_impl_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_seq_scalar_impl_type =
      gtk_type_unique (GUPPI_TYPE_SEQ_IMPL, &guppi_seq_scalar_impl_info);
  }
  return guppi_seq_scalar_impl_type;
}

GtkObject *
guppi_seq_scalar_impl_new (void)
{
  return GTK_OBJECT (guppi_type_new (guppi_seq_scalar_impl_get_type ()));
}



/* $Id: guppi-seq-scalar-impl.c,v 1.10 2000/12/14 20:23:04 trow Exp $ */
