/* This is -*- C -*- */
/* $Id: guppi-text-view.c,v 1.8 2000/10/20 01:21:35 trow Exp $ */

/*
 * guppi-text-view.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-metrics.h>
#include "guppi-text-item.h"
#include "guppi-text-print.h"
#include "guppi-text-view.h"
#include "guppi-text-state.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_text_view_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_text_view_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_text_view_destroy (GtkObject * obj)
{
  if (parent_class->destroy)
    parent_class->destroy (obj);
}

static void
guppi_text_view_finalize (GtkObject * obj)
{
  if (parent_class->finalize)
    parent_class->finalize (obj);
}

/*****************************************************************************/

static GuppiCanvasItem *
make_canvas_item (GuppiElementView * view, GnomeCanvas * canvas,
		  GnomeCanvasGroup * group)
{
  GnomeCanvasItem *gci;

  gci = gnome_canvas_item_new (group, GUPPI_TYPE_TEXT_ITEM, NULL);

  return GUPPI_CANVAS_ITEM (gci);
}

static void
state_changed (GuppiElementView * view)
{
  /* If we changed, try to recalculate our natural sizes. */
  guppi_geometry_calc_natural_size (guppi_element_view_geometry (view));
}

/*****************************************************************************/

static void
guppi_text_view_class_init (GuppiTextViewClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;
  GuppiElementViewClass *view_class = GUPPI_ELEMENT_VIEW_CLASS (klass);

  parent_class = gtk_type_class (GUPPI_TYPE_ELEMENT_VIEW);

  object_class->get_arg = guppi_text_view_get_arg;
  object_class->set_arg = guppi_text_view_set_arg;
  object_class->destroy = guppi_text_view_destroy;
  object_class->finalize = guppi_text_view_finalize;

  view_class->make_canvas_item = make_canvas_item;
  view_class->print_type = GUPPI_TYPE_TEXT_PRINT;
  view_class->state_changed = state_changed;
}

static double
calc_width (gpointer user_data)
{
  GuppiElementView *gev = GUPPI_ELEMENT_VIEW (user_data);
  GuppiTextState *state = GUPPI_TEXT_STATE (guppi_element_view_state (gev));
  GnomeFont *font = guppi_text_state_font (state);

  double w = 0;

  if (guppi_text_state_text (state) != NULL) {
    w = gnome_font_get_width_string (font, guppi_text_state_text (state));
    w += guppi_text_state_left_margin (state);
    w += guppi_text_state_right_margin (state);

    if (guppi_text_state_outline (state))
      w += 2 * guppi_text_state_outline_width (state);
  }

  return w;
}

static double
calc_height (gpointer user_data)
{
  GuppiElementView *gev = GUPPI_ELEMENT_VIEW (user_data);
  GuppiTextState *state = GUPPI_TEXT_STATE (guppi_element_view_state (gev));
  GnomeFont *font = guppi_text_state_font (state);

  double h = 0;

  if (guppi_text_state_text (state) != NULL) {
    h = gnome_font_get_ascender (font) + gnome_font_get_descender (font);
    h += guppi_text_state_top_margin (state);
    h += guppi_text_state_bottom_margin (state);

    if (guppi_text_state_outline (state))
      h += 2 * guppi_text_state_outline_width (state);
  }

  return h;
}

static void
guppi_text_view_init (GuppiTextView * obj)
{
  GuppiElementView *view = GUPPI_ELEMENT_VIEW (obj);
  GuppiGeometry *geom = guppi_element_view_geometry (view);

  guppi_geometry_set_width_callback (geom, calc_width);
  guppi_geometry_set_height_callback (geom, calc_height);
}

GtkType guppi_text_view_get_type (void)
{
  static GtkType guppi_text_view_type = 0;
  if (!guppi_text_view_type) {
    static const GtkTypeInfo guppi_text_view_info = {
      "GuppiTextView",
      sizeof (GuppiTextView),
      sizeof (GuppiTextViewClass),
      (GtkClassInitFunc) guppi_text_view_class_init,
      (GtkObjectInitFunc) guppi_text_view_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_text_view_type =
      gtk_type_unique (GUPPI_TYPE_ELEMENT_VIEW, &guppi_text_view_info);
  }
  return guppi_text_view_type;
}


/* $Id: guppi-text-view.c,v 1.8 2000/10/20 01:21:35 trow Exp $ */
