/* This is -*- C -*- */
/* $Id: guppi-pie-view.h,v 1.4 2000/10/27 18:22:48 trow Exp $ */

/*
 * guppi-pie-view.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_PIE_VIEW_H
#define _INC_GUPPI_PIE_VIEW_H

#include <gnome.h>
#include <guppi-defs.h>
#include <guppi-element-view.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiPieView GuppiPieView;
typedef struct _GuppiPieViewClass GuppiPieViewClass;

struct _GuppiPieView {
  GuppiElementView parent;
};

struct _GuppiPieViewClass {
  GuppiElementViewClass parent_class;
};

#define GUPPI_TYPE_PIE_VIEW (guppi_pie_view_get_type())
#define GUPPI_PIE_VIEW(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_PIE_VIEW,GuppiPieView))
#define GUPPI_PIE_VIEW0(obj) ((obj) ? (GUPPI_PIE_VIEW(obj)) : NULL)
#define GUPPI_PIE_VIEW_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_PIE_VIEW,GuppiPieViewClass))
#define GUPPI_IS_PIE_VIEW(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_PIE_VIEW))
#define GUPPI_IS_PIE_VIEW0(obj) (((obj) == NULL) || (GUPPI_IS_PIE_VIEW(obj)))
#define GUPPI_IS_PIE_VIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_PIE_VIEW))

GtkType guppi_pie_view_get_type (void);

double guppi_pie_view_max_radius (GuppiPieView *);
double guppi_pie_view_effective_radius (GuppiPieView *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_PIE_VIEW_H */

/* $Id: guppi-pie-view.h,v 1.4 2000/10/27 18:22:48 trow Exp $ */
