/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-output-xml.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_OUTPUT_XML_H
#define _INC_GUPPI_OUTPUT_XML_H

#include <gtk/gtk.h>
#include <zlib.h>
#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

typedef struct _GuppiOutputXML GuppiOutputXML;
typedef struct _GuppiOutputXMLClass GuppiOutputXMLClass;

struct _GuppiOutputXML {
  GtkObject parent;

  gboolean own_fd;
  gint fd;
  gzFile zfd;

  gboolean topmatter;
  GList *tag_stack;
  gint indent;
};

struct _GuppiOutputXMLClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_OUTPUT_XML (guppi_output_xml_get_type ())
#define GUPPI_OUTPUT_XML(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_OUTPUT_XML,GuppiOutputXML))
#define GUPPI_OUTPUT_XML0(obj) ((obj) ? (GUPPI_OUTPUT_XML(obj)) : NULL)
#define GUPPI_OUTPUT_XML_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_OUTPUT_XML,GuppiOutputXMLClass))
#define GUPPI_IS_OUTPUT_XML(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_OUTPUT_XML))
#define GUPPI_IS_OUTPUT_XML0(obj) (((obj) == NULL) || (GUPPI_IS_OUTPUT_XML(obj)))
#define GUPPI_IS_OUTPUT_XML_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_OUTPUT_XML))

GtkType guppi_output_xml_get_type (void);

GuppiOutputXML *guppi_output_xml_new (void);

void guppi_output_xml_open_file (GuppiOutputXML * out,
				 const gchar * filename);
void guppi_output_xml_open_fd (GuppiOutputXML * out, gint fd);
void guppi_output_xml_close (GuppiOutputXML * out);


void guppi_output_xml_print (GuppiOutputXML * out, const gchar * str);
void guppi_output_xml_printf (GuppiOutputXML * out,
			      const gchar * format_str, ...);
void guppi_output_xml_vprintf (GuppiOutputXML * out,
			       const gchar * format_str, va_list args);

void guppi_output_xml_element (GuppiOutputXML * out,
			       const gchar * tag, const gchar * body);

void guppi_output_xml_elementf (GuppiOutputXML * out,
			       const gchar * tag,
				const gchar * body_format, ...);

void guppi_output_xml_tag (GuppiOutputXML * out, const gchar * tag);
void guppi_output_xml_tagf (GuppiOutputXML * out,
			    const gchar * tag,
			    const gchar * attr_format, ...);
void guppi_output_xml_end_tag (GuppiOutputXML * out);
void guppi_output_xml_end_tag_check (GuppiOutputXML * out,
				     const gchar *expected_tag);
void guppi_output_xml_empty_tag (GuppiOutputXML * out,
				 const gchar * empty_tag);
void guppi_output_xml_empty_tagf (GuppiOutputXML * out,
				  const gchar * tag,
				  const gchar * attr_format, ...);
void guppi_output_xml_comment (GuppiOutputXML * out,
			       const gchar * comment_text);



void guppi_output_xml_attribute_start (GuppiOutputXML *out, const gchar *name);
void guppi_output_xml_attribute_end (GuppiOutputXML *out);

void guppi_output_xml_attribute (GuppiOutputXML *out,
				 const gchar *name,
				 const gchar *value);

void guppi_output_xml_attributef (GuppiOutputXML *out,
				  const gchar *name,
				  const gchar *value_format, ...);
END_GUPPI_DECLS

#endif /* _INC_GUPPI_OUTPUT_XML_H */

/* $Id: guppi-output-xml.h,v 1.6 2000/11/22 21:42:51 trow Exp $ */
