/* This is -*- C -*- */
/* $Id: guppi-shared-hash.h,v 1.7 2000/10/27 18:23:00 trow Exp $ */

/*
 * guppi-shared-hash.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SHARED_HASH_H
#define _INC_GUPPI_SHARED_HASH_H

#include <gnome.h>
#include "guppi-shared.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

/* Some canonized shared-data keys */
#define SHARED_DATA "misc-data"
#define SHARED_X_DATA "x-data"
#define SHARED_Y_DATA "y-data"
#define SHARED_WT_DATA "wt-data"
#define SHARED_STYLE_DATA "style-data"
#define SHARED_LABEL_DATA "label-data"
#define SHARED_ELEMENT_LABEL_DATA "element-label-data"
#define SHARED_COLOR_DATA "color-data"
#define SHARED_SIZE1_DATA "size1-data"
#define SHARED_SIZE2_DATA "size2-data"
#define SHARED_DOFI_DATA "dofi-data"
#define SHARED_X_VIEW "x-view"
#define SHARED_Y_VIEW "y-view"
#define SHARED_X_MARKERS "x-markers"
#define SHARED_Y_MARKERS "y-markers"
typedef struct _GuppiSharedHash GuppiSharedHash;
typedef struct _GuppiSharedHashClass GuppiSharedHashClass;

struct _GuppiSharedHash {
  GtkObject parent;

  GHashTable *hash;
  GuppiSharedHash *chain;

  GuppiShared *shared_viewport;
};

struct _GuppiSharedHashClass {
  GtkObjectClass parent_class;
};

#define GUPPI_TYPE_SHARED_HASH (guppi_shared_hash_get_type())
#define GUPPI_SHARED_HASH(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SHARED_HASH,GuppiSharedHash))
#define GUPPI_SHARED_HASH0(obj) ((obj) ? (GUPPI_SHARED_HASH(obj)) : NULL)
#define GUPPI_SHARED_HASH_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SHARED_HASH,GuppiSharedHashClass))
#define GUPPI_IS_SHARED_HASH(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SHARED_HASH))
#define GUPPI_IS_SHARED_HASH0(obj) (((obj) == NULL) || (GUPPI_IS_SHARED_HASH(obj)))
#define GUPPI_IS_SHARED_HASH_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SHARED_HASH))

GtkType guppi_shared_hash_get_type (void);

GuppiSharedHash *guppi_shared_hash_new (void);

void guppi_shared_hash_chain (GuppiSharedHash *, GuppiSharedHash *);

void guppi_shared_hash_add (GuppiSharedHash *, const gchar * key,
			    GuppiShared *);
GuppiShared *guppi_shared_hash_extract (GuppiSharedHash *, const gchar *);

gboolean guppi_shared_hash_test (GuppiSharedHash *, const gchar * key);
GtkObject *guppi_shared_hash_get (GuppiSharedHash *, const gchar * key);
void guppi_shared_hash_set (GuppiSharedHash *, const gchar * key,
			    GtkObject *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_SHARED_HASH_H */

/* $Id: guppi-shared-hash.h,v 1.7 2000/10/27 18:23:00 trow Exp $ */
