
/* This is -*- C -*- */
/* $Id: guppi-element-view.h,v 1.22 2000/12/12 03:47:48 trow Exp $ */

/*
 * guppi-element-view.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_ELEMENT_VIEW_H
#define _INC_GUPPI_ELEMENT_VIEW_H

#include <gnome.h>
#include <libgnomeprint/gnome-print.h>
#include <guppi-config-item.h>
#include "guppi-element-state.h"
#include "guppi-geometry.h"
#include "guppi-view-interval.h"
#include "guppi-axis-markers.h"

#include <guppi-defs.h>

BEGIN_GUPPI_DECLS 

struct _GuppiStyle;
struct _GuppiCanvasItem;
struct _GuppiElementPrint;

typedef struct _GuppiElementView GuppiElementView;
typedef struct _GuppiElementViewClass GuppiElementViewClass;

struct _GuppiElementView {
  GtkObject parent;
  gpointer opaque_internals;
};

struct _GuppiElementViewClass {
  GtkObjectClass parent_class;

  /* VTable */
  GtkType canvas_item_type;
  struct _GuppiCanvasItem *(*make_canvas_item) (GuppiElementView *,
						GnomeCanvas *,
						GnomeCanvasGroup *);

  GtkType print_type;
  struct _GuppiElementPrint *(*make_print) (GuppiElementView *,
					    GnomePrintContext *);

  void (*state_changed) (GuppiElementView *);
  void (*x_interval_changed) (GuppiElementView *);
  void (*y_interval_changed) (GuppiElementView *);

  void (*get_style_bounds) (GuppiElementView *, gint *, gint *);
  struct _GuppiStyle *(*get_style) (GuppiElementView *, gint);

  /* Init function called after view is constructed and has parent state
     attached. */
  void (*view_init) (GuppiElementView *);

  void (*update_x_axis_markers) (GuppiElementView *, GuppiAxisMarkers *,
				 double x0, double x1);
  void (*update_y_axis_markers) (GuppiElementView *, GuppiAxisMarkers *,
				 double y0, double y1);

  gboolean (*preferred_x_range) (GuppiElementView *, double *, double *);
  gboolean (*preferred_y_range) (GuppiElementView *, double *, double *);

  GuppiConfigItem *(*config_tree) (GuppiElementView *);
  GuppiConfigItem *(*assemble_config_tree) (GuppiElementView *,
					    GuppiConfigItem * view_tree,
					    GuppiConfigItem * state_tree);

  void (*print) (GuppiElementView *, GnomePrintContext *);
  void (*write_xml_attributes) (GuppiElementView *, GuppiOutputXML *);
  void (*write_xml_other) (GuppiElementView *, GuppiOutputXML *);

  /* Signals */
  void (*changed) (GuppiElementView *);
  void (*changed_size) (GuppiElementView *);
  void (*changed_structure) (GuppiElementView *);
};

#define GUPPI_TYPE_ELEMENT_VIEW (guppi_element_view_get_type())
#define GUPPI_ELEMENT_VIEW(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_ELEMENT_VIEW,GuppiElementView))
#define GUPPI_ELEMENT_VIEW0(obj) ((obj) ? (GUPPI_ELEMENT_VIEW(obj)) : NULL)
#define GUPPI_ELEMENT_VIEW_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_ELEMENT_VIEW,GuppiElementViewClass))
#define GUPPI_IS_ELEMENT_VIEW(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_ELEMENT_VIEW))
#define GUPPI_IS_ELEMENT_VIEW0(obj) (((obj) == NULL) || (GUPPI_IS_ELEMENT_VIEW(obj)))
#define GUPPI_IS_ELEMENT_VIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_ELEMENT_VIEW))

GtkType guppi_element_view_get_type (void);

GuppiElementState *guppi_element_view_state (GuppiElementView *);
GuppiGeometry *guppi_element_view_geometry (GuppiElementView *);

guppi_uniq_t guppi_element_view_unique_id (GuppiElementView *);

GuppiViewInterval *guppi_element_view_x_view_interval (GuppiElementView *);
GuppiViewInterval *guppi_element_view_y_view_interval (GuppiElementView *);

gint guppi_element_view_x_axis_marker_type (GuppiElementView *);
gint guppi_element_view_y_axis_marker_type (GuppiElementView *);
void guppi_element_view_set_x_axis_marker_type (GuppiElementView *, gint code);
void guppi_element_view_set_y_axis_marker_type (GuppiElementView *, gint code);

GuppiAxisMarkers *guppi_element_view_x_axis_markers (GuppiElementView *);
GuppiAxisMarkers *guppi_element_view_y_axis_markers (GuppiElementView *);

void guppi_element_view_set_state (GuppiElementView *, GuppiElementState *);

void guppi_element_view_get_bbox_vp (GuppiElementView *,
				     double *x0, double *y0,
				     double *x1, double *y1);
void guppi_element_view_get_bbox_pt (GuppiElementView *,
				     double *x0, double *y0,
				     double *x1, double *y1);

#define guppi_element_view_valid_x_vp(gev, x) \
(guppi_view_interval_valid(guppi_element_view_x_view_interval(gev), (x)))

#define guppi_element_view_valid_y_vp(gev, y) \
(guppi_view_interval_valid(guppi_element_view_y_view_interval(gev), (y)))

#define guppi_element_view_valid_vp(gev, x, y) \
(guppi_element_view_valid_x_vp((gev), (x)) && \
 guppi_element_view_valid_y_vp((gev), (y)))

void guppi_element_view_vp2pt (GuppiElementView *,
			       double, double, double *, double *);
void guppi_element_view_pt2vp (GuppiElementView *,
			       double, double, double *, double *);

struct _GuppiCanvasItem *guppi_element_view_make_canvas_item (GuppiElementView
							      *,
							      GnomeCanvas *,
							      GnomeCanvasGroup
							      *);
struct _GuppiElementPrint *guppi_element_view_make_print (GuppiElementView *,
							  GnomePrintContext
							  *);

void guppi_element_view_change_along_with_shared_object (GuppiElementView *,
							 GuppiShared *);

void guppi_element_view_connect (GuppiElementView * v1, const gchar * key1,
				 GuppiElementView * v2, const gchar * key2);

void guppi_element_view_set_preferred_x_view (GuppiElementView *);
void guppi_element_view_set_preferred_y_view (GuppiElementView *);
void guppi_element_view_set_preferred_view (GuppiElementView *);

void guppi_element_view_force_preferred_x_view (GuppiElementView *, gboolean);
void guppi_element_view_force_preferred_y_view (GuppiElementView *, gboolean);
void guppi_element_view_force_preferred_view (GuppiElementView *, gboolean);

gboolean guppi_element_view_visible (GuppiElementView *);
void guppi_element_view_show (GuppiElementView *);
void guppi_element_view_hide (GuppiElementView *);
void guppi_element_view_set_visibility (GuppiElementView *, gboolean);

void guppi_element_view_style_bounds (GuppiElementView *, gint *, gint *);
gboolean guppi_element_view_style_in_bounds (GuppiElementView *, gint);
struct _GuppiStyle *guppi_element_view_style (GuppiElementView *, gint);

gboolean guppi_element_view_tools_are_blocked (GuppiElementView *);
void guppi_element_view_set_tool_blocking (GuppiElementView *, gboolean);

GuppiConfigItem *guppi_element_view_config_tree (GuppiElementView *);

void guppi_element_view_print (GuppiElementView *, GnomePrintContext *);
void guppi_element_view_print_to_bbox (GuppiElementView *,
				       GnomePrintContext *,
				       double x0, double y0,
				       double x1, double y1);
void guppi_element_view_print_ps_to_file (GuppiElementView *,
					  const gchar * filename);

void guppi_element_view_changed (GuppiElementView *);
void guppi_element_view_changed_delayed (GuppiElementView *);
void guppi_element_view_flush_changes (GuppiElementView *);

void guppi_element_view_changed_size (GuppiElementView *);

void guppi_element_view_freeze (GuppiElementView *);
void guppi_element_view_thaw (GuppiElementView *);

void guppi_element_view_changed_structure (GuppiElementView *);
void guppi_element_view_changed_structure_delayed (GuppiElementView *);

void guppi_element_view_write_xml (GuppiElementView *, GuppiOutputXML *);
void guppi_element_view_spew_xml (GuppiElementView *);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_ELEMENT_VIEW_H */

/* $Id: guppi-element-view.h,v 1.22 2000/12/12 03:47:48 trow Exp $ */
