/* This is -*- C -*- */
/* $Id: guppi-data-impl.c,v 1.9 2000/12/17 05:24:56 trow Exp $ */

/*
 * guppi-data-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-memory.h>
#include "guppi-data-impl.h"

static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0
};

enum {
  CHANGED,
  CHANGED_SUBDATA,
  LAST_SIGNAL
};
static guint impl_signals[LAST_SIGNAL] = { 0 };

static void
guppi_data_impl_get_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_data_impl_set_arg (GtkObject * obj, GtkArg * arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_data_impl_finalize (GtkObject * obj)
{
  guppi_finalized (obj);

  if (parent_class->finalize)
    parent_class->finalize (obj);
}

static void
guppi_data_impl_class_init (GuppiDataImplClass * klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *) klass;

  parent_class = gtk_type_class (GTK_TYPE_OBJECT);

  klass->impl_name = "-* GuppiDataImpl *- (If you are seeing this, something is wrong";

  object_class->get_arg = guppi_data_impl_get_arg;
  object_class->set_arg = guppi_data_impl_set_arg;
  object_class->finalize = guppi_data_impl_finalize;

  impl_signals[CHANGED] =
    gtk_signal_new ("changed",
		    GTK_RUN_LAST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (GuppiDataImplClass, changed),
		    gtk_marshal_NONE__NONE, GTK_TYPE_NONE, 0);

  impl_signals[CHANGED_SUBDATA] =
    gtk_signal_new ("changed_subdata",
		    GTK_RUN_LAST,
		    object_class->type,
		    GTK_SIGNAL_OFFSET (GuppiDataImplClass, changed_subdata),
		    gtk_marshal_NONE__NONE, GTK_TYPE_NONE, 0);


  gtk_object_class_add_signals (object_class, impl_signals, LAST_SIGNAL);

}

static void
guppi_data_impl_init (GuppiDataImpl * obj)
{

}

GtkType guppi_data_impl_get_type (void)
{
  static GtkType guppi_data_impl_type = 0;
  if (!guppi_data_impl_type) {
    static const GtkTypeInfo guppi_data_impl_info = {
      "GuppiDataImpl",
      sizeof (GuppiDataImpl),
      sizeof (GuppiDataImplClass),
      (GtkClassInitFunc) guppi_data_impl_class_init,
      (GtkObjectInitFunc) guppi_data_impl_init,
      NULL, NULL, (GtkClassInitFunc) NULL
    };
    guppi_data_impl_type =
      gtk_type_unique (GTK_TYPE_OBJECT, &guppi_data_impl_info);
  }
  return guppi_data_impl_type;
}

const gchar *
guppi_data_impl_get_impl_name (GuppiDataImpl *impl)
{
  g_return_val_if_fail (impl && GUPPI_IS_DATA_IMPL (impl), NULL);
  return GUPPI_DATA_IMPL_CLASS (GTK_OBJECT (impl)->klass)->impl_name;
}

void
guppi_data_impl_changed (GuppiDataImpl *impl)
{
  g_return_if_fail (impl && GUPPI_IS_DATA_IMPL (impl));
  gtk_signal_emit (GTK_OBJECT (impl), impl_signals[CHANGED]);
}

void
guppi_data_impl_changed_subdata (GuppiDataImpl *impl)
{
  g_return_if_fail (impl && GUPPI_IS_DATA_IMPL (impl));
  gtk_signal_emit (GTK_OBJECT (impl), impl_signals[CHANGED_SUBDATA]);
}

void
guppi_data_impl_touch (GuppiDataImpl *impl)
{
  g_return_if_fail (impl && GUPPI_IS_DATA_IMPL (impl));
  guppi_data_impl_changed (impl);
}


/* $Id: guppi-data-impl.c,v 1.9 2000/12/17 05:24:56 trow Exp $ */
