from Guppi import *
from Guppi.plot import *
import Guppi

pie_styles = GuppiSeqStyle()
pie_data = GuppiSeqScalar()
pie_labels = GuppiSeqString()

pie_data_numbers = (1500, 500, 150, 600, 350, 450, 120)
colors = ('red', 'blue', 'orange', 'green', 'purple', 'goldenrod', 'pink')
labels = ('Rent', 'Food', 'Utilities', 'Car', 'Pinball', 'Beer', 'Pork Rinds')


def init():
    for x in pie_data_numbers:
        pie_data.append(x)

    for x in colors:
        sty = GuppiStyle()
        sty.set_color(x)
        pie_styles.append(sty)
    
def pie_demo():
    pie_state = GuppiPieState()
    legend_state = GuppiLegendState()
    text_state = GuppiTextState()
    pie_view = pie_state.make_view()
    legend_view = legend_state.make_view()
    text_view = text_state.make_view()

    plot = GuppiPlot()

    pie_state.set_data(pie_data)
    pie_state.set_styles(pie_styles)
    pie_state.set_labels(pie_labels)

    pie_state.set_radius_maximize(1) # "#t"?

    text_state.set_text('Monthly Spending')
    text_state.set_font_size(24)

    pie_state.connect('style-data', legend_state, 'style-data')
    pie_state.connect('label-data', legend_state, 'label-data')

    plot.set_size(72 * 6, 72 * 4.5)

    plot.layout_flush_top(text_view, 7.2)
    plot.layout_horizontal_fill(text_view, 0, 0)
    plot.layout_natural_height(text_view)

    plot.layout_flush_bottom(pie_view, 0)
    plot.layout_vertically_adjacent(text_view, pie_view, 0)
    plot.layout_horizontally_adjacent(pie_view, legend_view, 0)
    plot.layout_flush_left(pie_view, 0)

    plot.layout_natural_height(legend_view)
    plot.layout_natural_width(legend_view)
    plot.layout_flush_right(legend_view, 0)
    plot.layout_same_y_center(pie_view, legend_view)

    plot.show_in_window()

    return pie_state
    
if __name__ == '__main__':
    init()
    pie_demo()
