/* vim: set sw=8: */

/*
 * graph-manger.c:
 *
 * Copyright (C) 2000 Jody Goldberg (jgoldberg@home.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "config.h"
#include "corba-graph-manager.h"
#include "gnumeric-graphs.h"
#include <guppi-chart-selector.h>
#include <guppi-bonobo.h>
#include "corba-graph-series.h"
#include <guppi-seq-data.h>
#include <guppi-seq-scalar.h>
#include <guppi-seq-date.h>
#include <guppi-seq-string.h>
#include <guppi-useful.h>

typedef struct {
	BonoboObjectClass parent_class;
} GraphManagerClass;

/***************************************************************************/

static POA_GNOME_Gnumeric_Graph_Manager__vepv graph_manager_vepv;

static inline GraphManager *
graph_manager_from_servant (PortableServer_Servant servant)
{
	return GRAPH_MANAGER (bonobo_object_from_servant (servant));
}

static Bonobo_Control
impl_getTypeSelectControl (PortableServer_Servant servant,
			   CORBA_Environment *ev)
{
	GraphManager *manager = graph_manager_from_servant (servant);

	puts ("Guppi : get type selector");
	if (manager->chart_type_selector.widget == NULL) {
		GtkWidget *selector = guppi_chart_selector_widget (&manager->details);

		/* Very important ! */
		gtk_widget_show_all (selector);

		manager->chart_type_selector.widget = selector;
		manager->chart_type_selector.control =
			bonobo_control_new (selector);
		manager->chart_type_selector.bonobo_control =
			bonobo_control_corba_object_create (BONOBO_OBJECT (
				manager->chart_type_selector.control));
	}

	return CORBA_Object_duplicate (manager->chart_type_selector.bonobo_control, ev);
}

static Bonobo_Control
impl_getLayoutControl (PortableServer_Servant servant,
		       CORBA_Environment *ev)
{
	GraphManager *manager = graph_manager_from_servant (servant);
	CORBA_Environment myev;
	CORBA_exception_init (&myev);
	CORBA_exception_free (&myev);

	puts ("Guppi : layout config");

	return CORBA_OBJECT_NIL;
}

static GNOME_Gnumeric_VectorScalarNotify
impl_addVectorScalar (PortableServer_Servant servant,
		      const GNOME_Gnumeric_VectorScalar vec,
		      CORBA_Environment *ev)
{
	GraphManager *manager = graph_manager_from_servant (servant);

	CORBA_Environment myev;
	GNOME_Gnumeric_SeqScalar *values;
	CORBA_char *name;

	printf ("addVectorScalar manager == 0x%p\n", manager);

	CORBA_exception_init (&myev);
	GNOME_Gnumeric_VectorScalar_value (vec, &values, &name, &myev);

	if (myev._major == CORBA_NO_EXCEPTION) {
		SeqNotify *notify;
		GuppiData *data;

		puts ("Guppi : add vector scalar");

		if (manager->scalars == NULL)
			manager->scalars = g_ptr_array_new ();
		notify = seq_notify_new (SERIES_SCALAR, vec);
		g_ptr_array_add (manager->scalars, notify);

		guppi_seq_string_append (manager->details.series_names, name);
		data = seq_notify_get_data (notify);
		guppi_seq_data_append (manager->details.series, data);
		guppi_seq_scalar_append_many (GUPPI_SEQ_SCALAR (data),
					      values->_buffer,
					      sizeof(double), values->_length);

		return seq_notify_get_servant (notify);
	} else
		puts ("addVectorScalar FOOBAR");
	CORBA_exception_free (&myev);

	return CORBA_OBJECT_NIL;
}

static GNOME_Gnumeric_VectorDateNotify
impl_addVectorDate (PortableServer_Servant servant,
		    const GNOME_Gnumeric_VectorDate vec,
		    CORBA_Environment *ev)
{
	GraphManager *manager = graph_manager_from_servant (servant);

#if 0
	CORBA_Environment myev;
	GNOME_Gnumeric_SeqDate *values;
	CORBA_char *name;

	printf ("addVectorDate manager == 0x%p\n", manager);

	CORBA_exception_init (&myev);
	GNOME_Gnumeric_VectorDate_value (vec, &values, &name, &myev);

	if (myev._major == CORBA_NO_EXCEPTION) {
		SeqNotify *notify;
		GuppiData *data;

		puts ("Guppi : add vector date");

		if (manager->dates == NULL)
			manager->dates = g_ptr_array_new ();
		notify = seq_notify_new (SERIES_DATE, vec);
		g_ptr_array_add (manager->dates, notify);

		guppi_seq_data_append (manager->details.series_names, name);
		data = seq_notify_get_data (notify);
		guppi_seq_data_append (manager->details.series, data);
		guppi_seq_date_append (GUPPI_SEQ_DATE (data),
					    values->_buffer,
					    sizeof(double), values->_length);

		return seq_notify_get_servant (notify);
	} else
		puts ("addVectorDate FOOBAR");
	CORBA_exception_free (&myev);
#endif

	return CORBA_OBJECT_NIL;
}

static GNOME_Gnumeric_VectorStringNotify
impl_addVectorString (PortableServer_Servant servant,
		      const GNOME_Gnumeric_VectorString vec,
		      CORBA_Environment *ev)
{
	GraphManager *manager = graph_manager_from_servant (servant);

	CORBA_Environment myev;
	GNOME_Gnumeric_SeqString *values;
	CORBA_char *name;

	printf ("addVectorString manager == 0x%p\n", manager);

	CORBA_exception_init (&myev);
	GNOME_Gnumeric_VectorString_value (vec, &values, &name, &myev);

	if (myev._major == CORBA_NO_EXCEPTION) {
		SeqNotify *notify;
		GuppiData *data;
		int i;

		puts ("Guppi : add vector string");

		if (manager->strings == NULL)
			manager->strings = g_ptr_array_new ();
		notify = seq_notify_new (SERIES_STRING, vec);
		g_ptr_array_add (manager->strings, notify);

		guppi_seq_string_append (manager->details.series_names, name);
		data = seq_notify_get_data (notify);
		guppi_seq_data_append (manager->details.labels, data);

		for (i = 0; i < values->_length; i++)
			guppi_seq_string_append (GUPPI_SEQ_STRING (data),
						 values->_buffer [i]);

		return seq_notify_get_servant (notify);
	} else
		puts ("addVectorString FOOBAR");
	CORBA_exception_free (&myev);

	return CORBA_OBJECT_NIL;
}

static void
corba_implementation_classes_init (void)
{
	static POA_GNOME_Gnumeric_Graph_Manager__epv graph_manager_epv;
	graph_manager_epv.getTypeSelectControl = &impl_getTypeSelectControl;
	graph_manager_epv.getLayoutControl = &impl_getLayoutControl;
	graph_manager_epv.addVectorScalar = &impl_addVectorScalar;
	graph_manager_epv.addVectorDate = &impl_addVectorDate;
	graph_manager_epv.addVectorString = &impl_addVectorString;

	graph_manager_vepv.Bonobo_Unknown_epv = bonobo_object_get_epv ();
	graph_manager_vepv.GNOME_Gnumeric_Graph_Manager_epv = &graph_manager_epv;
}

static GtkObjectClass *graph_manager_parent_class = NULL;
static void
graph_manager_destroy (GtkObject *object)
{
	puts ("GUPPI : GraphManager destroyed");

	if (graph_manager_parent_class->destroy)
		graph_manager_parent_class->destroy (object);
}

static void
graph_manager_class_init (GtkObjectClass *object_class)
{
	object_class->destroy = graph_manager_destroy;

	graph_manager_parent_class =
		gtk_type_class (bonobo_object_get_type ());

	corba_implementation_classes_init ();
}

static void
graph_manager_init (GtkObject *object)
{
	GraphManager *manager = GRAPH_MANAGER (object);
	manager->chart_type_selector.widget = NULL;
	manager->scalars = NULL;
	manager->dates = NULL;
	manager->strings = NULL;
	guppi_chart_selector_init (&manager->details);
}

GtkType
graph_manager_get_type (void)
{
	static GtkType type = 0;

	if (!type) {
		GtkTypeInfo info = {
			"GraphManager",
			sizeof (GraphManager),
			sizeof (GraphManagerClass),
			(GtkClassInitFunc) graph_manager_class_init,
			(GtkObjectInitFunc) graph_manager_init,
			NULL, /* reserved 1 */
			NULL, /* reserved 2 */
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (bonobo_object_get_type (), &info);
	}

	return type;
}

static GNOME_Gnumeric_Graph_Manager
manager_corba_object_create (BonoboObject *object)
{
	POA_GNOME_Gnumeric_Graph_Manager *servant;
	CORBA_Environment ev;

	servant = (POA_GNOME_Gnumeric_Graph_Manager *) guppi_new0 (BonoboObjectServant, 1);
	servant->vepv = &graph_manager_vepv;

	CORBA_exception_init (&ev);
	POA_GNOME_Gnumeric_Graph_Manager__init ((PortableServer_Servant) servant, &ev);
	if (ev._major != CORBA_NO_EXCEPTION){
		guppi_free (servant);
		CORBA_exception_free (&ev);
		return CORBA_OBJECT_NIL;
	}

	CORBA_exception_free (&ev);
	return (GNOME_Gnumeric_Graph_Manager) bonobo_object_activate_servant (object, servant);
}

GraphManager *
graph_manager_new (void)
{
	GraphManager *manager;
	GNOME_Gnumeric_Graph_Manager manager_corba;

	manager = guppi_type_new (graph_manager_get_type ());

	printf ("Manager::new() == 0x%p\n", manager);
	manager_corba = manager_corba_object_create (BONOBO_OBJECT (manager));
	if (manager_corba == CORBA_OBJECT_NIL){
		gtk_object_destroy (GTK_OBJECT (manager));
		return NULL;
	}
	bonobo_object_construct (BONOBO_OBJECT (manager), manager_corba);
	manager->embeddable = NULL;
	return manager;
}
