/* This is -*- C -*- */
/* $Id: guppi-text-state.h,v 1.5 2000/10/27 18:22:51 trow Exp $ */

/*
 * guppi-text-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_TEXT_STATE_H
#define _INC_GUPPI_TEXT_STATE_H

#include <gnome.h>
#include <libgnomeprint/gnome-font.h>
#include <guppi-element-state.h>
#include <guppi-defs.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiTextState GuppiTextState;
typedef struct _GuppiTextStateClass GuppiTextStateClass;

struct _GuppiTextState {
  GuppiElementState parent;

  gchar *text;
  guint32 text_color;
  double rot_angle;

  GnomeFont *font;

  gboolean filled_text;
  double outline_width;

  double top_margin, bottom_margin, left_margin, right_margin;
};

struct _GuppiTextStateClass {
  GuppiElementStateClass parent_class;
};

#define GUPPI_TYPE_TEXT_STATE (guppi_text_state_get_type())
#define GUPPI_TEXT_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_TEXT_STATE,GuppiTextState))
#define GUPPI_TEXT_STATE0(obj) ((obj) ? (GUPPI_TEXT_STATE(obj)) : NULL)
#define GUPPI_TEXT_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_TEXT_STATE,GuppiTextStateClass))
#define GUPPI_IS_TEXT_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_TEXT_STATE))
#define GUPPI_IS_TEXT_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_TEXT_STATE(obj)))
#define GUPPI_IS_TEXT_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_TEXT_STATE))

GtkType guppi_text_state_get_type (void);

GuppiElementState *guppi_text_state_new (void);

#define guppi_text_state_text(x) ((x)->text)
#define guppi_text_state_color(x) ((x)->text_color)
#define guppi_text_state_rot_angle(x) ((x)->rot_angle)
#define guppi_text_state_font(x) ((x)->font)
#define guppi_text_state_font_size(x) (gnome_font_get_size ((x)->font))
#define guppi_text_state_filled(x) ((x)->filled_text)
#define guppi_text_state_outline(x) (!(x)->filled_text)
#define guppi_text_state_outline_width(x) ((x)->outline_width)
#define guppi_text_state_top_margin(x) ((x)->top_margin)
#define guppi_text_state_bottom_margin(x) ((x)->bottom_margin)
#define guppi_text_state_left_margin(x) ((x)->left_margin)
#define guppi_text_state_right_margin(x) ((x)->right_margin)

void guppi_text_state_set_text (GuppiTextState *, const gchar *);
void guppi_text_state_set_color (GuppiTextState *, guint32 rgba);
void guppi_text_state_set_rot_angle (GuppiTextState *, double);
void guppi_text_state_set_font (GuppiTextState *, GnomeFont *);
void guppi_text_state_set_font_size (GuppiTextState *, double);
void guppi_text_state_set_filled (GuppiTextState *, gboolean);
void guppi_text_state_set_outline (GuppiTextState *, gboolean);
void guppi_text_state_set_outline_width (GuppiTextState *, double);
void guppi_text_state_set_top_margin (GuppiTextState *, double);
void guppi_text_state_set_bottom_margin (GuppiTextState *, double);
void guppi_text_state_set_left_margin (GuppiTextState *, double);
void guppi_text_state_set_right_margin (GuppiTextState *, double);

#endif /* _INC_GUPPI_TEXT_STATE_H */

END_GUPPI_DECLS

/* $Id: guppi-text-state.h,v 1.5 2000/10/27 18:22:51 trow Exp $ */
