/* This is -*- C -*- */
/* $Id: guppi-frame-state.h,v 1.4 2000/10/27 18:22:46 trow Exp $ */

/*
 * guppi-frame-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_FRAME_STATE_H
#define _INC_GUPPI_FRAME_STATE_H

#include <gnome.h>
#include <guppi-defs.h>
#include <guppi-enums.h>
#include <guppi-element-state.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiFrameState GuppiFrameState;
typedef struct _GuppiFrameStateClass GuppiFrameStateClass;

struct _GuppiFrameState {
  GuppiElementState parent;

  gboolean show_major_ticks;
  guint32 major_tick_color;
  double major_tick_thickness, major_tick_length;

  gboolean show_minor_ticks;
  guint32 minor_tick_color;
  double minor_tick_thickness, minor_tick_length;

  gboolean show_micro_ticks;
  guint32 micro_tick_color;
  double micro_tick_thickness, micro_tick_length;

  gboolean show_major_rules;
  guint32 major_rule_color;
  double major_rule_thickness;

  gboolean show_minor_rules;
  guint32 minor_rule_color;
  double minor_rule_thickness;

  gboolean show_micro_rules;
  guint32 micro_rule_color;
  double micro_rule_thickness;

  gint frame_flags;
  guint32 frame_color;
  double frame_thickness;
};

struct _GuppiFrameStateClass {
  GuppiElementStateClass parent_class;
};

#define GUPPI_TYPE_FRAME_STATE (guppi_frame_state_get_type())
#define GUPPI_FRAME_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_FRAME_STATE,GuppiFrameState))
#define GUPPI_FRAME_STATE0(obj) ((obj) ? (GUPPI_FRAME_STATE(obj)) : NULL)
#define GUPPI_FRAME_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_FRAME_STATE,GuppiFrameStateClass))
#define GUPPI_IS_FRAME_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_FRAME_STATE))
#define GUPPI_IS_FRAME_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_FRAME_STATE(obj)))
#define GUPPI_IS_FRAME_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_FRAME_STATE))

GtkType guppi_frame_state_get_type (void);

GuppiElementState *guppi_frame_state_new (void);

#define guppi_frame_state_show_major_ticks(x) ((x)->show_major_ticks)
#define guppi_frame_state_major_tick_color(x) ((x)->major_tick_color)
#define guppi_frame_state_major_tick_thickness(x) ((x)->major_tick_thickness)
#define guppi_frame_state_major_tick_length(x) ((x)->major_tick_length)

#define guppi_frame_state_show_minor_ticks(x) ((x)->show_minor_ticks)
#define guppi_frame_state_minor_tick_color(x) ((x)->minor_tick_color)
#define guppi_frame_state_minor_tick_thickness(x) ((x)->minor_tick_thickness)
#define guppi_frame_state_minor_tick_length(x) ((x)->minor_tick_length)

#define guppi_frame_state_show_micro_ticks(x) ((x)->show_micro_ticks)
#define guppi_frame_state_micro_tick_color(x) ((x)->micro_tick_color)
#define guppi_frame_state_micro_tick_thickness(x) ((x)->micro_tick_thickness)
#define guppi_frame_state_micro_tick_length(x) ((x)->micro_tick_length)

#define guppi_frame_state_show_major_rules(x) ((x)->show_major_rules)
#define guppi_frame_state_major_rule_color(x) ((x)->major_rule_color)
#define guppi_frame_state_major_rule_thickness(x) ((x)->major_rule_thickness)

#define guppi_frame_state_show_minor_rules(x) ((x)->show_minor_rules)
#define guppi_frame_state_minor_rule_color(x) ((x)->minor_rule_color)
#define guppi_frame_state_minor_rule_thickness(x) ((x)->minor_rule_thickness)

#define guppi_frame_state_show_micro_rules(x) ((x)->show_micro_rules)
#define guppi_frame_state_micro_rule_color(x) ((x)->micro_rule_color)
#define guppi_frame_state_micro_rule_thickness(x) ((x)->micro_rule_thickness)

#define guppi_frame_state_frame_north(x) ((x)->frame_flags & GUPPI_NORTH)
#define guppi_frame_state_frame_south(x) ((x)->frame_flags & GUPPI_SOUTH)
#define guppi_frame_state_frame_east(x) ((x)->frame_flags & GUPPI_EAST)
#define guppi_frame_state_frame_west(x) ((x)->frame_flags & GUPPI_WEST)
#define guppi_frame_state_frame_color(x) ((x)->frame_color)
#define guppi_frame_state_frame_thickness(x) ((x)->frame_thickness)

void guppi_frame_state_set_show_major_ticks (GuppiFrameState *, gboolean);
void guppi_frame_state_set_major_tick_color (GuppiFrameState *, guint32);
void guppi_frame_state_set_major_tick_thickness (GuppiFrameState *, double);
void guppi_frame_state_set_major_tick_length (GuppiFrameState *, double);

void guppi_frame_state_set_show_minor_ticks (GuppiFrameState *, gboolean);
void guppi_frame_state_set_minor_tick_color (GuppiFrameState *, guint32);
void guppi_frame_state_set_minor_tick_thickness (GuppiFrameState *, double);
void guppi_frame_state_set_minor_tick_length (GuppiFrameState *, double);

void guppi_frame_state_set_show_micro_ticks (GuppiFrameState *, gboolean);
void guppi_frame_state_set_micro_tick_color (GuppiFrameState *, guint32);
void guppi_frame_state_set_micro_tick_thickness (GuppiFrameState *, double);
void guppi_frame_state_set_micro_tick_length (GuppiFrameState *, double);

void guppi_frame_state_set_show_major_rules (GuppiFrameState *, gboolean);
void guppi_frame_state_set_major_rule_color (GuppiFrameState *, guint32);
void guppi_frame_state_set_major_rule_thickness (GuppiFrameState *, double);

void guppi_frame_state_set_show_minor_rules (GuppiFrameState *, gboolean);
void guppi_frame_state_set_minor_rule_color (GuppiFrameState *, guint32);
void guppi_frame_state_set_minor_rule_thickness (GuppiFrameState *, double);

void guppi_frame_state_set_show_micro_rules (GuppiFrameState *, gboolean);
void guppi_frame_state_set_micro_rule_color (GuppiFrameState *, guint32);
void guppi_frame_state_set_micro_rule_thickness (GuppiFrameState *, double);

void guppi_frame_state_set_frame_north (GuppiFrameState *, gboolean);
void guppi_frame_state_set_frame_south (GuppiFrameState *, gboolean);
void guppi_frame_state_set_frame_east (GuppiFrameState *, gboolean);
void guppi_frame_state_set_frame_west (GuppiFrameState *, gboolean);
void guppi_frame_state_set_frame_color (GuppiFrameState *, guint32);
void guppi_frame_state_set_frame_thickness (GuppiFrameState *, double);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_FRAME_STATE_H */

/* $Id: guppi-frame-state.h,v 1.4 2000/10/27 18:22:46 trow Exp $ */
