/* This is -*- C -*- */
/* vim: set sw=2: */

/*
 * guppi-linegraph-register.c
 *
 * Copyright (C) 2000 Helix Code, Inc.
 *
 * Developed by Jody Goldberg <jgoldberg@home.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <guppi-root-group-view.h>
#include "guppi-XLplots-common.h"
#include "guppi-chart-type.h"
#include "guppi-linegraph-register.h"
#include "linegraph.xpm"

typedef struct
{
  int dummy;
} LineChartDescriptor;

static GuppiRootGroupView *
guppi_linegraph_config (GuppiMinorChartType const *t,
			GuppiSeqData   *series,
			GuppiSeqData   *labels,
			GuppiSeqString *series_names)
{
  return guppi_unimplemented_plot ();
}

void
guppi_linegraph_register ()
{
  GuppiMajorChartType *linegraph_types =
      guppi_major_chart_type_register ( _("Line"), linegraph_icon, NULL);

  {
    static LineChartDescriptor const desc = { };
    guppi_minor_chart_type_register (linegraph_types,
      _("Line"), "chart_line_1_1.png",
      _("Category versus value"),
      1, 1, &guppi_linegraph_config, &desc);
  }

  {
    static LineChartDescriptor const desc = { };
    guppi_minor_chart_type_register (linegraph_types,
      _("Stacked lines"), "chart_line_1_2.png",
      _("Minor categories stacked in lines that are grouped "
	"by major category"),
      1, 2, &guppi_linegraph_config, &desc);
  }

  {
    static LineChartDescriptor const desc = { };
    guppi_minor_chart_type_register (linegraph_types,
      _("Percentage lines"), "chart_line_1_3.png",
      _("Minor categories stacked as percentages of the minor total, "
	"in lines, grouped by major category"),
      1, 3, &guppi_linegraph_config, &desc);
  }

  {
    static LineChartDescriptor const desc = { };
    guppi_minor_chart_type_register (linegraph_types,
      _("Marked lines"), "chart_line_2_1.png",
      _("Category versus value, with markers at each point"),
      2, 1, &guppi_linegraph_config, &desc);
  }

  {
    static LineChartDescriptor const desc = { };
    guppi_minor_chart_type_register (linegraph_types,
      _("3D Stacked Lines"), "chart_line_2_2.png",
      _("Minor categories stacked in lines that are grouped "
	"by major category, with markers at each point"),
      2, 2, &guppi_linegraph_config, &desc);
  }

  {
    static LineChartDescriptor const desc = { };
    guppi_minor_chart_type_register (linegraph_types,
      _("3D Percentage Lines"), "chart_line_2_3.png",
      _("Minor categories stacked as percentages of the minor total, "
	"in lines, grouped by major category, with markers at each point"),
      2, 3, &guppi_linegraph_config, &desc);
  }

  {
    static LineChartDescriptor const desc = { };
    guppi_minor_chart_type_register (linegraph_types,
      _("3D lines"), "chart_line_3_1.png",
      _("Category versus value as lines in pseudo-3D"),
      3, 1, &guppi_linegraph_config, &desc);
  }
}
