/* $Id: guppi-enums.h,v 1.1 2000/05/03 17:06:52 trow Exp $ */

/*
 * guppi-enums.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_ENUMS_H
#define _INC_GUPPI_ENUMS_H

#include <config.h>
#include <gnome.h>

typedef enum _guppi_compass_t guppi_compass_t;
enum _guppi_compass_t { GUPPI_COMPASS_INVALID,
			GUPPI_NORTH, GUPPI_SOUTH, GUPPI_EAST, GUPPI_WEST };

typedef enum _guppi_alignment_t guppi_alignment_t;
enum _guppi_alignment_t { GUPPI_ALIGNMENT_INVALID,
			  GUPPI_LEFT, GUPPI_RIGHT,
			  GUPPI_TOP, GUPPI_BOTTOM,
			  GUPPI_CENTER };

typedef enum _guppi_orientation_t guppi_orientation_t;
enum _guppi_orientation_t { GUPPI_ORIENTATION_INVALID,
			    GUPPI_HORIZONTAL, GUPPI_VERTICAL };

const gchar* guppi_compass2str(guppi_compass_t);
guppi_compass_t guppi_str2compass(const gchar*);

const gchar* guppi_alignment2str(guppi_alignment_t);
guppi_alignment_t guppi_str2alignment(const gchar*);

#define guppi_alignment_is_horizontal(x) \
((x) == GUPPI_LEFT || (x) == GUPPI_RIGHT || (x) == GUPPI_CENTER)

#define guppi_alignment_is_vertical(x) \
((x) == GUPPI_TOP || (x) == GUPPI_BOTTOM || (x) == GUPPI_CENTER)

#define guppi_alignment_matches_orientation(align, orien) \
(((orien) == GUPPI_HORIZONTAL && guppi_alignment_is_horizontal(align)) || \
 ((orien) == GUPPI_VERTICAL && guppi_alignment_is_vertical(align)))
 
const gchar* guppi_orientation2str(guppi_orientation_t);
guppi_orientation_t guppi_str2orientation(const gchar*);



#endif /* _INC_GUPPI_ENUMS_H */

/* $Id: guppi-enums.h,v 1.1 2000/05/03 17:06:52 trow Exp $ */
