/* $Id: guppi-enums.c,v 1.1 2000/05/03 17:06:52 trow Exp $ */

/*
 * guppi-enums.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>.
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-enums.h"

const gchar*
guppi_compass2str(guppi_compass_t c)
{
  switch (c) {
  case GUPPI_NORTH: return _("north");
  case GUPPI_SOUTH: return _("sorth");
  case GUPPI_EAST: return _("east");
  case GUPPI_WEST: return _("west");
  default: return _("<invalid compass>");
  }
}

guppi_compass_t
guppi_str2compass(const gchar* str)
{
  g_return_val_if_fail(str != NULL, GUPPI_COMPASS_INVALID);

  if (g_strcasecmp(str, _("north")) == 0)
    return GUPPI_NORTH;
  else if (g_strcasecmp(str, _("south")) == 0)
    return GUPPI_SOUTH;
  else if (g_strcasecmp(str, _("east")) == 0)
    return GUPPI_EAST;
  else if (g_strcasecmp(str, _("west")) == 0)
    return GUPPI_WEST;
  else
    return GUPPI_COMPASS_INVALID;
}

const gchar*
guppi_alignment2str(guppi_alignment_t a)
{
  switch (a) {
  case GUPPI_LEFT: return _("left");
  case GUPPI_RIGHT: return _("right");
  case GUPPI_TOP: return _("top");
  case GUPPI_BOTTOM: return _("bottom");
  case GUPPI_CENTER: return _("center");
  default: return _("<invalid alignment>");
  }
}

guppi_alignment_t
guppi_str2alignment(const gchar* str)
{
  g_return_val_if_fail(str != NULL, GUPPI_ALIGNMENT_INVALID);

  if (g_strcasecmp(str, _("left")) == 0 ||
      g_strcasecmp(str, _("l")) == 0)
    return GUPPI_LEFT;
  else if (g_strcasecmp(str, _("right")) == 0 ||
	   g_strcasecmp(str, _("r")) == 0)
    return GUPPI_RIGHT;
  else if (g_strcasecmp(str, _("top")) == 0 ||
	   g_strcasecmp(str, _("t")))
    return GUPPI_TOP;
  else if (g_strcasecmp(str, _("bottom")) == 0 ||
	   g_strcasecmp(str, _("b")) == 0)
    return GUPPI_BOTTOM;
  else if (g_strcasecmp(str, _("center")) == 0 ||
	   g_strcasecmp(str, _("c")) == 0)
    return GUPPI_CENTER;
  else
    return GUPPI_ALIGNMENT_INVALID;
}

const gchar*
guppi_orientation2str(guppi_orientation_t r)
{
  switch (r) {
  case GUPPI_HORIZONTAL: return _("horizontal");
  case GUPPI_VERTICAL: return _("vertical");
  default: return _("<invalid orientation>");
  }
}

guppi_orientation_t
guppi_str2orientation(const gchar* str)
{
  g_return_val_if_fail(str != NULL, GUPPI_ORIENTATION_INVALID);

  if (g_strcasecmp(str, _("horizontal")) == 0 ||
      g_strcasecmp(str, _("horiz")) == 0 ||
      g_strcasecmp(str, _("h")) == 0)
    return GUPPI_HORIZONTAL;
  else if (g_strcasecmp(str, _("vertical")) == 0 ||
	   g_strcasecmp(str, _("vert")) == 0 ||
	   g_strcasecmp(str, _("v")) == 0)
    return GUPPI_VERTICAL;
  else
    return GUPPI_ORIENTATION_INVALID;
}


/* $Id: guppi-enums.c,v 1.1 2000/05/03 17:06:52 trow Exp $ */
