/* This is -*- C -*- */
/* $Id: guppi-canvas-item.h,v 1.14 2000/05/01 04:41:38 trow Exp $ */

/*
 * guppi-canvas-item.h
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_CANVAS_ITEM_H
#define _INC_GUPPI_CANVAS_ITEM_H

#include <config.h>
#include <gnome.h>
#include "transform.h"
#include "guppi-item-state.h"

typedef struct _GuppiCanvasItem GuppiCanvasItem;
typedef struct _GuppiCanvasItemClass GuppiCanvasItemClass;

struct _GuppiCanvasItem {
  GnomeCanvasItem canvas_item;

  gboolean need_geometry_recalc, changed_geometry;
  double min_width, min_height;
  double optimal_width, optimal_height;
  double max_width, max_height;
  double width_hunger, height_hunger;
  gboolean block_changed_geometry_signals;

  /* Bounding box of object in world & canvas coordinates. */
  double wx0, wy0, wx1, wy1;
  gint cx0, cy0, cx1, cy1;

  /* x- and y-ranges of plot coordinates. */
  double x0, y0, x1, y1;

  /* bounding box for noteworthy item contents (in plot coordinates) */
  gboolean bb_passive; /* will not try to enforce own bb */
  double bb_x0, bb_y0, bb_x1, bb_y1;

  /* "Full window" x- and y- ranges of plot coordinates */
  double full_x0, full_y0, full_x1, full_y1;
  gboolean reneg_x_started, reneg_y_started;

  /* A constant multiplier for magnifications. */
  double mag_factor;

  /* plot <-> pixel coordinate transformers */
  Transform* x_transform;
  Transform* y_transform;

  GuppiItemState* state;

  /* A cop-out to avoid circular dependencies. */
  gpointer active_tool;
};

struct _GuppiCanvasItemClass {
  GnomeCanvasItemClass parent_class;

  /* virtual functions */
  void (*state_set_hook)(GuppiCanvasItem*, GuppiItemState*);
  void (*state_unset_hook)(GuppiCanvasItem*);
  void (*calc_geometry)(GuppiCanvasItem*);

  /* signal functions */
  void (*changed_geometry)(GuppiCanvasItem*);
  void (*rescaled_x)(GuppiCanvasItem*, double x0, double x1);
  void (*rescaled_y)(GuppiCanvasItem*, double y0, double y1);
  void (*rebounded_x)(GuppiCanvasItem*, double x0, double x1);
  void (*rebounded_y)(GuppiCanvasItem*, double y0, double y1);
  void (*renegotiate_x_start)(GuppiCanvasItem*);
  void (*renegotiate_x_declare)(GuppiCanvasItem*, double, double);
  void (*renegotiate_y_start)(GuppiCanvasItem*);
  void (*renegotiate_y_declare)(GuppiCanvasItem*, double, double);
};

#define GUPPI_TYPE_CANVAS_ITEM (guppi_canvas_item_get_type())
#define GUPPI_CANVAS_ITEM(obj) (GTK_CHECK_CAST((obj), \
                                   GUPPI_TYPE_CANVAS_ITEM, \
                                   GuppiCanvasItem))
#define GUPPI_CANVAS_ITEM_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass), \
                                           GUPPI_TYPE_CANVAS_ITEM, \
                                           GuppiCanvasItemClass))
#define GUPPI_IS_CANVAS_ITEM(obj) (GTK_CHECK_TYPE((obj), \
                                      GUPPI_TYPE_CANVAS_Item))
#define GUPPI_IS_CANVAS_ITEM_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), \
                                              GUPPI_TYPE_CANVAS_ITEM))

GtkType guppi_canvas_item_get_type(void);

void guppi_canvas_item_set_geometry(GuppiCanvasItem*,
				    double w0, double w, double w1,
				    double whung,
				    double h0, double h, double h1, 
				    double hhung);
void guppi_canvas_item_calc_geometry(GuppiCanvasItem*);
void guppi_canvas_item_calc_geometry_when_idle(GuppiCanvasItem*);

GuppiItemState* guppi_canvas_item_state(GuppiCanvasItem*);
void guppi_canvas_item_set_state(GuppiCanvasItem*, GuppiItemState*);

void guppi_canvas_item_set_x_world(GuppiCanvasItem*, double x0, double x1);
void guppi_canvas_item_set_y_world(GuppiCanvasItem*, double y0, double y1);
void guppi_canvas_item_set_world(GuppiCanvasItem*,
				 double x0, double y0,
				 double x1, double y1);

void guppi_canvas_item_set_x_bounds(GuppiCanvasItem*, double x0, double x1);
void guppi_canvas_item_set_y_bounds(GuppiCanvasItem*, double y0, double y1);
void guppi_canvas_item_set_bounds(GuppiCanvasItem*,
				  double x0, double y0,
				  double x1, double y1);

void guppi_canvas_item_set_x_scale(GuppiCanvasItem*, double x0, double x1);
void guppi_canvas_item_set_y_scale(GuppiCanvasItem*, double y0, double y1);
void guppi_canvas_item_set_scales(GuppiCanvasItem*,
				  double x0, double y0,
				  double x1, double y1);
void guppi_canvas_item_rescale_around_point(GuppiCanvasItem*,
					    double x, double y,
					    double factor);
void guppi_canvas_item_recenter_around_point(GuppiCanvasItem*,
					     double x, double y);
void guppi_canvas_item_translate(GuppiCanvasItem*, double dx, double dy);
void guppi_canvas_item_home_view(GuppiCanvasItem*);

double guppi_canvas_item_x_magnification(const GuppiCanvasItem*);
double guppi_canvas_item_y_magnification(const GuppiCanvasItem*);
double guppi_canvas_item_magnification(const GuppiCanvasItem*);

void guppi_canvas_item_plot2pixel(const GuppiCanvasItem*,
				  double x, double y,
				  gint* cx, gint* cy);
    
void guppi_canvas_item_pixel2plot(const GuppiCanvasItem*,
				  gint cx, gint cy,
				  double* x, double* y);

/* Convert canvas "world" coordinates to plot coordinates, and vis versa */
void guppi_canvas_item_world2plot(const GuppiCanvasItem*,
				  double wx, double wy,
				  double* x, double* y);
void guppi_canvas_item_plot2world(const GuppiCanvasItem*,
				  double wx, double wy,
				  double* x, double* y);

void guppi_canvas_item_request_redraw(GuppiCanvasItem*,
				      double x0, double y0,
				      double x1, double y1);
void guppi_canvas_item_request_total_redraw(GuppiCanvasItem*);

void guppi_canvas_item_request_update(GuppiCanvasItem*);

/* Connect/disconnect two items to rescale together */
void guppi_canvas_item_connect_x_scales(GuppiCanvasItem*, GuppiCanvasItem*);
void guppi_canvas_item_connect_y_scales(GuppiCanvasItem*, GuppiCanvasItem*);
void guppi_canvas_item_connect_scales(GuppiCanvasItem*, GuppiCanvasItem*);
void guppi_canvas_item_disconnect(GuppiCanvasItem*, GuppiCanvasItem*);

GnomeCanvasBuf* guppi_canvas_item_clip_buf(GuppiCanvasItem*, GnomeCanvasBuf*);

#endif /* _INC_GUPPI_CANVAS_ITEM_H */

/* $Id: guppi-canvas-item.h,v 1.14 2000/05/01 04:41:38 trow Exp $ */
