/* $Id: guppi-data-init.c,v 1.7 2000/04/21 23:22:44 trow Exp $ */

/*
 * guppi-data-init.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-data-init.h"
#include "guppi-scm-data.h"

#include "guppi-seq-boolean.h"
#include "guppi-seq-date.h"
#include "guppi-seq-scalar.h"
#include "guppi-seq-string.h"

void
guppi_data_init(void)
{
  static gboolean inited = FALSE;
  g_return_if_fail(!inited);
  inited = TRUE;

  /* Invoke our various data types to make sure that they have been
     created. */
  guppi_seq_boolean_get_type();
  guppi_seq_date_get_type();
  guppi_seq_scalar_get_type();
  guppi_seq_integer_get_type();
  guppi_seq_string_get_type();

  guppi_scm_data_init();
}


/* $Id: guppi-data-init.c,v 1.7 2000/04/21 23:22:44 trow Exp $ */
