/* This is -*- C -*- */
/* $Id: guppi-slinreg-state.h,v 1.2 2000/04/11 02:48:53 trow Exp $ */

/*
 * guppi-slinreg-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SLINREG_STATE_H
#define _INC_GUPPI_SLINREG_STATE_H

#include <config.h>
#include <gnome.h>
#include <libgnomeprint/gnome-font.h>

#include <guppi-item-state.h>
#include <guppi-simple-linreg.h>

typedef struct _GuppiSlinregState GuppiSlinregState;
typedef struct _GuppiSlinregStateClass GuppiSlinregStateClass;

struct _GuppiSlinregState {
  GuppiItemState parent;

  double line_width;
  guint32 line_color;

  gboolean show_label;
  GnomeFont* label_font;
  double label_size;
  guint32 label_color;

  GuppiSimpleLinreg* slr;
};

struct _GuppiSlinregStateClass {
  GuppiItemStateClass parent_class;
};

#define GUPPI_TYPE_SLINREG_STATE (guppi_slinreg_state_get_type())
#define GUPPI_SLINREG_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SLINREG_STATE,GuppiSlinregState))
#define GUPPI_SLINREG_STATE0(obj) ((obj) ? (GUPPI_SLINREG_STATE(obj)) : NULL)
#define GUPPI_SLINREG_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SLINREG_STATE,GuppiSlinregStateClass))
#define GUPPI_IS_SLINREG_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SLINREG_STATE))
#define GUPPI_IS_SLINREG_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_SLINREG_STATE(obj)))
#define GUPPI_IS_SLINREG_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SLINREG_STATE))

GtkType guppi_slinreg_state_get_type(void);

GuppiSlinregState* guppi_slinreg_state_new(void);



#endif /* _INC_GUPPI_SLINREG_STATE_H */

/* $Id: guppi-slinreg-state.h,v 1.2 2000/04/11 02:48:53 trow Exp $ */
