/* This is -*- C -*- */
/* $Id: guppi-scatter-element.c,v 1.3 2000/04/25 13:57:14 trow Exp $ */

/*
 * guppi-scatter-element.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-scatter-element.h"
#include <guppi-scatter-state-control.h>
#include <guppi-scatter-item.h>
#include "guppi-scatter-tools.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_scatter_element_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_scatter_element_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_scatter_element_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_scatter_element_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static GtkWidget*
gse_make_state_widget(GuppiPlotElement* gpe)
{
  GuppiScatterElement* gse = GUPPI_SCATTER_ELEMENT(gpe);
  GuppiScatterState* state;

  g_return_val_if_fail(gse != NULL, NULL);

  state = GUPPI_SCATTER_STATE(guppi_plot_element_state(gpe));
  g_assert(state);

  return guppi_scatter_state_control_new(state);
}

static void
guppi_scatter_element_class_init(GuppiScatterElementClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiPlotElementClass* pe_klass = GUPPI_PLOT_ELEMENT_CLASS(klass);
  gint i;

  parent_class = gtk_type_class(GUPPI_TYPE_PLOT_ELEMENT);

  pe_klass->state_type = GUPPI_TYPE_SCATTER_STATE;
  pe_klass->item_type = GUPPI_TYPE_SCATTER_ITEM;
  pe_klass->type_name = _("scatter plot");
  pe_klass->make_state_widget = gse_make_state_widget;

  object_class->get_arg = guppi_scatter_element_get_arg;
  object_class->set_arg = guppi_scatter_element_set_arg;
  object_class->destroy = guppi_scatter_element_destroy;
  object_class->finalize = guppi_scatter_element_finalize;

  guppi_plot_toolkit_set_button_tool(&pe_klass->default_toolkit,
				     2, GDK_SHIFT_MASK,
				     guppi_scatter_tool_frame_brush(0));

  for (i=1; i<=3; ++i) 
    guppi_plot_toolkit_set_button_tool(&pe_klass->default_toolkit,
				       i, GDK_CONTROL_MASK,
				       guppi_scatter_tool_radius_brush(i,10*i));

  guppi_plot_toolkit_set_button_tool(&pe_klass->default_toolkit,
				     1, GDK_SHIFT_MASK | GDK_CONTROL_MASK,
				     guppi_scatter_tool_home_view());

  guppi_plot_toolkit_set_button_tool(&pe_klass->default_toolkit,
				     2, GDK_SHIFT_MASK | GDK_CONTROL_MASK,
				     guppi_scatter_tool_drag_point());
}

static void
guppi_scatter_element_init(GuppiScatterElement* obj)
{

}

GtkType
guppi_scatter_element_get_type(void)
{
  static GtkType guppi_scatter_element_type = 0;
  if (!guppi_scatter_element_type) {
    static const GtkTypeInfo guppi_scatter_element_info = {
      "GuppiScatterElement",
      sizeof(GuppiScatterElement),
      sizeof(GuppiScatterElementClass),
      (GtkClassInitFunc)guppi_scatter_element_class_init,
      (GtkObjectInitFunc)guppi_scatter_element_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_scatter_element_type = gtk_type_unique(GUPPI_TYPE_PLOT_ELEMENT, &guppi_scatter_element_info);
  }
  return guppi_scatter_element_type;
}

GuppiPlotElement*
guppi_scatter_element_new(void)
{
  return GUPPI_PLOT_ELEMENT(gtk_type_new(guppi_scatter_element_get_type()));
}


/* $Id: guppi-scatter-element.c,v 1.3 2000/04/25 13:57:14 trow Exp $ */
