/* This is -*- C -*- */
/* $Id: guppi-graphpaper-item.c,v 1.1 2000/04/21 23:22:40 trow Exp $ */

/*
 * guppi-graphpaper-item.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <guppi-rgb.h>
#include "guppi-nice-values.h"
#include "guppi-graphpaper-item.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0,
  ARG_STATE
};

static void
guppi_graphpaper_item_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_graphpaper_item_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {
  case ARG_STATE:
    guppi_canvas_item_set_state(GUPPI_CANVAS_ITEM(obj),
				GUPPI_ITEM_STATE(GTK_VALUE_POINTER(*arg)));
    break;

  default:
    break;
  };
}

static void
guppi_graphpaper_item_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_graphpaper_item_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_graphpaper_item_class_init(GuppiGraphpaperItemClass* klass)
{
  static void guppi_graphpaper_item_update(GnomeCanvasItem*, double affine[6],
					   ArtSVP*, gint);
  static void guppi_graphpaper_item_render(GnomeCanvasItem*, GnomeCanvasBuf*);
  static void guppi_graphpaper_item_state_set_hook(GuppiCanvasItem*,
						   GuppiItemState*);

  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GnomeCanvasItemClass* item_class = GNOME_CANVAS_ITEM_CLASS(klass);
  GuppiCanvasItemClass* gci_class = GUPPI_CANVAS_ITEM_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_CANVAS_ITEM);

  gtk_object_add_arg_type("GuppiGraphpaperItem::state",
			  GTK_TYPE_POINTER,
			  GTK_ARG_WRITABLE,
			  ARG_STATE);

  object_class->get_arg = guppi_graphpaper_item_get_arg;
  object_class->set_arg = guppi_graphpaper_item_set_arg;
  object_class->destroy = guppi_graphpaper_item_destroy;
  object_class->finalize = guppi_graphpaper_item_finalize;

  item_class->update = guppi_graphpaper_item_update;
  item_class->render = guppi_graphpaper_item_render;
  
  gci_class->state_set_hook = guppi_graphpaper_item_state_set_hook;
}

static void
guppi_graphpaper_item_init(GuppiGraphpaperItem* obj)
{

}

GtkType
guppi_graphpaper_item_get_type(void)
{
  static GtkType guppi_graphpaper_item_type = 0;
  if (!guppi_graphpaper_item_type) {
    static const GtkTypeInfo guppi_graphpaper_item_info = {
      "GuppiGraphpaperItem",
      sizeof(GuppiGraphpaperItem),
      sizeof(GuppiGraphpaperItemClass),
      (GtkClassInitFunc)guppi_graphpaper_item_class_init,
      (GtkObjectInitFunc)guppi_graphpaper_item_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_graphpaper_item_type = gtk_type_unique(GUPPI_TYPE_CANVAS_ITEM, &guppi_graphpaper_item_info);
  }
  return guppi_graphpaper_item_type;
}

GtkObject*
guppi_graphpaper_item_new(void)
{
  return GTK_OBJECT(gtk_type_new(guppi_graphpaper_item_get_type()));
}

static void
guppi_graphpaper_item_update(GnomeCanvasItem* item, double affine[6],
			     ArtSVP* clip_path, gint flags)
{
  GuppiCanvasItem* gci = GUPPI_CANVAS_ITEM(item);
  GuppiGraphpaperItem* ggp = GUPPI_GRAPHPAPER_ITEM(item);

  /* Chain our calls to update */
  if (parent_class && GNOME_CANVAS_ITEM_CLASS(parent_class)->update)
    GNOME_CANVAS_ITEM_CLASS(parent_class)->update(item,affine,clip_path,flags);

  g_free(ggp->xvals);
  g_free(ggp->yvals);

  ggp->xvals = guppi_nice_values(gci->x0, gci->x1, 6, 10, &ggp->xN);
  ggp->yvals = guppi_nice_values(gci->y0, gci->y1, 6, 10, &ggp->yN);

  guppi_canvas_item_request_total_redraw(gci);
}

static void
guppi_graphpaper_item_render(GnomeCanvasItem* item,
			     GnomeCanvasBuf* buf)
{
  GuppiCanvasItem* gci = GUPPI_CANVAS_ITEM(item);
  GuppiGraphpaperItem* ggp = GUPPI_GRAPHPAPER_ITEM(item);
  double t;
  gint i, j, xc, yc, xw, yw;
  guchar alph;
  gpointer ptr;

  /* Chain our calls to render */
  if (parent_class && GNOME_CANVAS_ITEM_CLASS(parent_class)->render)
    GNOME_CANVAS_ITEM_CLASS(parent_class)->render(item, buf);

  buf = guppi_canvas_item_clip_buf(gci, buf);

  xw = buf->rect.x1 - buf->rect.x0;
  yw = buf->rect.y1 - buf->rect.y0;

  for (j=0; j<ggp->xN; ++j) {
    t = ggp->xvals[j];
    alph = t==0 ? 0x80 : 0x20;
    guppi_canvas_item_plot2pixel(gci, t, 0, &xc, NULL);
    if (buf->rect.x0 <= xc && xc < buf->rect.x1) {
      ptr = buf->buf + 3*(xc-buf->rect.x0);
      for (i=0; i<yw; ++i) {
	PIXEL_RGBA(ptr, 0, 0, 0, alph);
	ptr += buf->buf_rowstride;
      }
    }
  }

  for (j=0; j<ggp->yN; ++j) {
    t = ggp->yvals[j];
    alph = t==0 ? 0x80 : 0x20;
    guppi_canvas_item_plot2pixel(gci, 0, t, NULL, &yc);
    if (buf->rect.y0 <= yc && yc < buf->rect.y1) {
      ptr = buf->buf + buf->buf_rowstride*(yc-buf->rect.y0);
      for (i=0; i<xw; ++i) {
	PIXEL_RGBA(ptr, 0, 0, 0, alph);
	ptr += 3;
      }
    }
  }

  g_free(buf);
}

static void
guppi_graphpaper_item_state_set_hook(GuppiCanvasItem* item, GuppiItemState* state)
{

}



/* $Id: guppi-graphpaper-item.c,v 1.1 2000/04/21 23:22:40 trow Exp $ */
