/* This is -*- C -*- */
/* $Id: guppi-boxplot-element.c,v 1.1 2000/04/25 13:57:13 trow Exp $ */

/*
 * guppi-boxplot-element.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-boxplot-element.h"
#include "guppi-boxplot-state.h"
#include "guppi-boxplot-item.h"


static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_boxplot_element_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_boxplot_element_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_boxplot_element_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_boxplot_element_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static GtkWidget*
make_state_widget(GuppiPlotElement* gpe)
{
  return NULL;
}

static void
guppi_boxplot_element_class_init(GuppiBoxplotElementClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiPlotElementClass* pe_class = GUPPI_PLOT_ELEMENT_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_PLOT_ELEMENT);

  pe_class->state_type = GUPPI_TYPE_BOXPLOT_STATE;
  pe_class->item_type = GUPPI_TYPE_BOXPLOT_ITEM;
  pe_class->type_name = _("boxplot");
  pe_class->make_state_widget = make_state_widget;

  object_class->get_arg = guppi_boxplot_element_get_arg;
  object_class->set_arg = guppi_boxplot_element_set_arg;
  object_class->destroy = guppi_boxplot_element_destroy;
  object_class->finalize = guppi_boxplot_element_finalize;

}

static void
guppi_boxplot_element_init(GuppiBoxplotElement* obj)
{

}

GtkType
guppi_boxplot_element_get_type(void)
{
  static GtkType guppi_boxplot_element_type = 0;
  if (!guppi_boxplot_element_type) {
    static const GtkTypeInfo guppi_boxplot_element_info = {
      "GuppiBoxplotElement",
      sizeof(GuppiBoxplotElement),
      sizeof(GuppiBoxplotElementClass),
      (GtkClassInitFunc)guppi_boxplot_element_class_init,
      (GtkObjectInitFunc)guppi_boxplot_element_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_boxplot_element_type = gtk_type_unique(GUPPI_TYPE_PLOT_ELEMENT, &guppi_boxplot_element_info);
  }
  return guppi_boxplot_element_type;
}

GuppiPlotElement*
guppi_boxplot_element_new(void)
{
  return GUPPI_PLOT_ELEMENT(gtk_type_new(guppi_boxplot_element_get_type()));
}



/* $Id: guppi-boxplot-element.c,v 1.1 2000/04/25 13:57:13 trow Exp $ */
