/* This is -*- C -*- */
/* $Id: guppi-axis-state.h,v 1.3 2000/04/25 13:57:13 trow Exp $ */

/*
 * guppi-axis-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_AXIS_STATE_H
#define _INC_GUPPI_AXIS_STATE_H

#include <config.h>
#include <gnome.h>
#include <libgnomeprint/gnome-font.h>

#include <guppi-item-state.h>
#include <guppi-seq-scalar.h>

typedef enum _GuppiAxisType GuppiAxisType;
enum _GuppiAxisType {
  AXIS_NORTH,
  AXIS_SOUTH,
  AXIS_EAST,
  AXIS_WEST
};

#define guppi_axis_type_horizontal(x) ((x) == AXIS_NORTH || (x) == AXIS_SOUTH)
#define guppi_axis_type_vertical(x) ((x) == AXIS_WEST || (x) == AXIS_EAST)

typedef struct _GuppiAxisState GuppiAxisState;
typedef struct _GuppiAxisStateClass GuppiAxisStateClass;

struct _GuppiAxisState {
  GuppiItemState parent;

  GuppiAxisType type;
  GuppiSeqScalar* data;
  GnomeFont* default_font;

  double rule_width;
  double tick_size, tick_width;
};

struct _GuppiAxisStateClass {
  GuppiItemStateClass parent_class;
};

#define GUPPI_TYPE_AXIS_STATE (guppi_axis_state_get_type())
#define GUPPI_AXIS_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_AXIS_STATE,GuppiAxisState))
#define GUPPI_AXIS_STATE0(obj) ((obj) ? (GUPPI_AXIS_STATE(obj)) : NULL)
#define GUPPI_AXIS_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_AXIS_STATE,GuppiAxisStateClass))
#define GUPPI_IS_AXIS_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_AXIS_STATE))
#define GUPPI_IS_AXIS_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_AXIS_STATE(obj)))
#define GUPPI_IS_AXIS_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_AXIS_STATE))

GtkType guppi_axis_state_get_type(void);

GuppiAxisState* guppi_axis_state_new(void);

#define guppi_axis_state_horizontal(x) ((x) && guppi_axis_type_horizontal((x)->type))
#define guppi_axis_state_vertical(x) ((x) && guppi_axis_type_vertical((x)->type))



#endif /* _INC_GUPPI_AXIS_STATE_H */

/* $Id: guppi-axis-state.h,v 1.3 2000/04/25 13:57:13 trow Exp $ */
