/* $Id: guppi-exit.c,v 1.1 2000/01/17 05:44:56 trow Exp $ */

/*
 * guppi-exit.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-exit.h"

typedef struct _GuppiApprivalPair GuppiApprovalPair;
struct _GuppiApprivalPair {
  GuppiApprovalFunc func;
  gpointer user_data;
};

static GList* approval_list = NULL;

typedef struct _GuppiShutdownPair GuppiShutdownPair;
struct _GuppiShutdownPair {
  GuppiShutdownFunc func;
  gpointer user_data;
};

static GList* shutdown_list = NULL;

/****************************************************************************/

void
guppi_exit_connect_approval_func(GuppiApprovalFunc fn, gpointer data)
{
  GuppiApprovalPair* pair;
  g_return_if_fail(fn != NULL);

  pair = g_new(GuppiApprovalPair, 1);
  pair->func = fn;
  pair->user_data = data;

  approval_list = g_list_prepend(approval_list, pair);
}

void
guppi_exit_disconnect_approval_func(GuppiApprovalFunc fn, gpointer data)
{
  GList* iter;
  GList* next;
  GuppiApprovalPair* pair;
  g_return_if_fail(fn != NULL);

  iter = approval_list;
  while (iter != NULL) {
    next = g_list_next(iter);
    pair = (GuppiApprovalPair*)iter->data;
    if (pair->func == fn && pair->user_data == data) {
      g_free(pair);
      g_list_remove_link(approval_list, iter);
    }
    iter = next;
  }
}

void
guppi_exit_connect_shutdown_func(GuppiShutdownFunc fn, gpointer data)
{
  GuppiShutdownPair* pair;
  g_return_if_fail(fn != NULL);

  pair = g_new(GuppiShutdownPair, 1);
  pair->func = fn;
  pair->user_data = data;

  shutdown_list = g_list_prepend(shutdown_list, pair);
}

void
guppi_exit_disconnect_shutdown_func(GuppiShutdownFunc fn, gpointer data)
{
  GList* iter;
  GList* next;
  GuppiShutdownPair* pair;
  g_return_if_fail(fn != NULL);

  iter = shutdown_list;
  while (iter != NULL) {
    next = g_list_next(iter);
    pair= (GuppiShutdownPair*)iter->data;
    if (pair->func == fn && pair->user_data == data) {
      g_free(pair);
      g_list_remove_link(shutdown_list, iter);
    }
    iter = next;
  }
}

/****************************************************************************/

static gboolean
approve_shutdown(void)
{
  GuppiApprovalPair* pair;
  GList* iter = approval_list;

  while (iter != NULL) {
    pair = (GuppiApprovalPair*)iter->data;
    if (pair != NULL && !(pair->func)(pair->user_data))
      return FALSE;

    iter = g_list_next(iter);
  }

  return TRUE;
}

static void
do_shutdown(void)
{
  GuppiShutdownPair* pair;
  GList* iter = shutdown_list;

  while (iter != NULL) {
    pair = (GuppiShutdownPair*)iter->data;
    if (pair != NULL)
      (pair->func)(pair->user_data);

    iter = g_list_next(iter);
  }

  /* We do some automatically */
  gtk_main_quit();
  g_message("Shutdown complete.");
}

void
guppi_exit(void)
{
  g_message("Exiting Guppi...");
  if (approve_shutdown())
    do_shutdown();
  else
    g_message("Shutdown cancelled.");
}

void
guppi_abort(void)
{
  g_message("Aborting Guppi...");
  do_shutdown();
}


/* $Id: guppi-exit.c,v 1.1 2000/01/17 05:44:56 trow Exp $ */
