/* This is -*- C -*- */
/* $Id: guppi-plot-state.c,v 1.9 2000/04/13 19:45:20 trow Exp $ */

/*
 * guppi-plot-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-plot-state.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

enum {
  ADD, REMOVE,
  LAST_SIGNAL
};

guint gps_signals[LAST_SIGNAL] = { 0 };

static void
guppi_plot_state_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_plot_state_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_plot_state_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_plot_state_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_plot_state_class_init(GuppiPlotStateClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  gps_signals[ADD] =
    gtk_signal_new("add",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiPlotStateClass, add),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1,
		   GTK_TYPE_POINTER);

  gps_signals[REMOVE] =
    gtk_signal_new("remove",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiPlotStateClass, remove),
		   gtk_marshal_NONE__POINTER,
		   GTK_TYPE_NONE, 1,
		   GTK_TYPE_POINTER);

  gtk_object_class_add_signals(object_class, gps_signals, LAST_SIGNAL);

  object_class->get_arg = guppi_plot_state_get_arg;
  object_class->set_arg = guppi_plot_state_set_arg;
  object_class->destroy = guppi_plot_state_destroy;
  object_class->finalize = guppi_plot_state_finalize;

}

static void
guppi_plot_state_init(GuppiPlotState* obj)
{

}

GtkType
guppi_plot_state_get_type(void)
{
  static GtkType guppi_plot_state_type = 0;
  if (!guppi_plot_state_type) {
    static const GtkTypeInfo guppi_plot_state_info = {
      "GuppiPlotState",
      sizeof(GuppiPlotState),
      sizeof(GuppiPlotStateClass),
      (GtkClassInitFunc)guppi_plot_state_class_init,
      (GtkObjectInitFunc)guppi_plot_state_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_plot_state_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_plot_state_info);
  }
  return guppi_plot_state_type;
}

GuppiPlotState*
guppi_plot_state_new(void)
{
  return GUPPI_PLOT_STATE(gtk_type_new(guppi_plot_state_get_type()));
}

static void
raise_lower_cb(GuppiPlotElement* element, gint n, gpointer ptr)
{
  GuppiPlotState* gps;
  gint index, target;

  g_return_if_fail(element != NULL);
  g_return_if_fail(ptr != NULL);

  if (n == 0)
    return;

  gps = GUPPI_PLOT_STATE(ptr);

  /* Move element from position index to position index + n */
  index = g_list_index(gps->elements, element);
  gps->elements = g_list_remove(gps->elements, element);
  target = index-n;
  if (target<0)
    target=0;
  gps->elements = g_list_insert(gps->elements, element, target);

}

void
guppi_plot_state_add_element(GuppiPlotState* gps, GuppiPlotElement* element)
{
  g_return_if_fail(gps != NULL);
  g_return_if_fail(element != NULL);

  gtk_object_ref(GTK_OBJECT(element));

  gps->elements = g_list_prepend(gps->elements, element);

  gtk_signal_connect(GTK_OBJECT(element),
		     "raise_or_lower",
		     GTK_SIGNAL_FUNC(raise_lower_cb),
		     gps);
    
  gtk_signal_emit(GTK_OBJECT(gps), gps_signals[ADD], element);
}

void
guppi_plot_state_remove_element(GuppiPlotState* gps, GuppiPlotElement* element)
{
  g_return_if_fail(gps != NULL);
  g_return_if_fail(element != NULL);

  gtk_signal_disconnect_by_data(GTK_OBJECT(element), gps);
  gps->elements = g_list_remove(gps->elements, element);

  gtk_signal_emit(GTK_OBJECT(gps), gps_signals[REMOVE], element);

  gtk_object_unref(GTK_OBJECT(element));
}

guint
guppi_plot_state_element_count(GuppiPlotState* gps)
{
  g_return_val_if_fail(gps != NULL, 0);
  return g_list_length(gps->elements);
}

GuppiPlotElement*
guppi_plot_state_get_element(GuppiPlotState* gps, gint i)
{
  GList* x;

  g_return_val_if_fail(gps != NULL, NULL);
  
  if (i<0) return NULL;
  x = g_list_nth(gps->elements, (guint)i);

  return x ? GUPPI_PLOT_ELEMENT(x->data) : NULL;
}

/*****************************************************************************/

/*
  Eventually, we will look at geometry information in the
  GuppiPlotElement objects (which isn't there yet) to decide how to
  lay these things out on the canvas.

  For now, we just plop everything down and fill up the canvas.
*/

static void
item_show_cb(GuppiPlotElement* e, gpointer data)
{
  gnome_canvas_item_show(GNOME_CANVAS_ITEM(data));
}

static void
item_hide_cb(GuppiPlotElement* e, gpointer data)
{
  gnome_canvas_item_hide(GNOME_CANVAS_ITEM(data));
}

static void
item_raise_lower_cb(GuppiPlotElement* e, gint n, gpointer data)
{
  if (n > 0)
    gnome_canvas_item_raise(GNOME_CANVAS_ITEM(data), n);
  else
    gnome_canvas_item_lower(GNOME_CANVAS_ITEM(data), -n);
}

void
guppi_plot_state_render(GuppiPlotState* gps, GnomeCanvas* canvas)
{
  gint i;
  GuppiPlotElement* e;
  GuppiCanvasItem* ci;
  GuppiCanvasItem* first_ci = NULL;

  g_return_if_fail(gps != NULL);
  g_return_if_fail(canvas != NULL);

  /* Some hard-wired canvas info for now */
  gtk_widget_set_usize(GTK_WIDGET(canvas), 500, 400);
  gnome_canvas_set_scroll_region(canvas, 0, 0, 500, 400);

  /* We store stuff top to bottom, so we have to render "backwards" 
     to get the stacking in the right order. */
  i = guppi_plot_state_element_count(gps);
  while (i>0) {
    --i;
    e = guppi_plot_state_get_element(gps, i);
    ci = guppi_plot_element_make_canvas_item(e, canvas, 0, 0, 100, 100);

    /* Automatically connect all items.  This is a hack. */
    if (first_ci == NULL)
      first_ci = ci;
    else {
      guppi_canvas_item_connect_scales(first_ci, ci);
      guppi_item_state_connect_x_data(first_ci->state, ci->state);
      guppi_item_state_connect_y_data(first_ci->state, ci->state);
    }

    gtk_signal_connect_object(GTK_OBJECT(e),
			      "destroy",
			      GTK_SIGNAL_FUNC(gtk_object_destroy),
			      GTK_OBJECT(ci));
    gtk_signal_connect(GTK_OBJECT(e),
		       "show",
		       GTK_SIGNAL_FUNC(item_show_cb),
		       ci);
    gtk_signal_connect(GTK_OBJECT(e),
		       "hide",
		       GTK_SIGNAL_FUNC(item_hide_cb),
		       ci);
    gtk_signal_connect(GTK_OBJECT(e),
		       "raise_or_lower",
		       GTK_SIGNAL_FUNC(item_raise_lower_cb),
		       ci);

    /* If this canvas item goes away for some reason, we need to make sure
       that we are not trying to send it signals after it has been
       destroyed. */
    gtk_signal_connect_object(GTK_OBJECT(ci),
			      "destroy",
			      GTK_SIGNAL_FUNC(gtk_signal_disconnect_by_data),
			      GTK_OBJECT(e));

    if (e->visible)
      gnome_canvas_item_show(GNOME_CANVAS_ITEM(ci));
    else
      gnome_canvas_item_hide(GNOME_CANVAS_ITEM(ci));
  }
  

}

#include "guppi-plot-window.h"
void
guppi_plot_state_view(GuppiPlotState* state)
{
  GtkWidget* win;

  win = guppi_plot_window_new(state);
  gtk_widget_show_all(win);
}


/* $Id: guppi-plot-state.c,v 1.9 2000/04/13 19:45:20 trow Exp $ */
