/* This is -*- C -*- */
/* $Id: guppi-seq-boolean.h,v 1.1 2000/02/09 21:04:56 trow Exp $ */

/*
 * guppi-seq-boolean.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_SEQ_BOOLEAN_H
#define _INC_GUPPI_SEQ_BOOLEAN_H

#include <config.h>
#include <gnome.h>

#include "guppi-seq.h"

typedef struct _GuppiSeqBoolean GuppiSeqBoolean;
typedef struct _GuppiSeqBooleanClass GuppiSeqBooleanClass;

struct _GuppiSeqBoolean {
  GuppiSeq parent;
};

struct _GuppiSeqBooleanClass {
  GuppiSeqClass parent_class;
};

#define GUPPI_TYPE_SEQ_BOOLEAN (guppi_seq_boolean_get_type())
#define GUPPI_SEQ_BOOLEAN(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_SEQ_BOOLEAN,GuppiSeqBoolean))
#define GUPPI_SEQ_BOOLEAN0(obj) ((obj) ? (GUPPI_SEQ_BOOLEAN(obj)) : NULL)
#define GUPPI_SEQ_BOOLEAN_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_SEQ_BOOLEAN,GuppiSeqBooleanClass))
#define GUPPI_IS_SEQ_BOOLEAN(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_SEQ_BOOLEAN))
#define GUPPI_IS_SEQ_BOOLEAN0(obj) (((obj) == NULL) || (GUPPI_IS_SEQ_BOOLEAN(obj)))
#define GUPPI_IS_SEQ_BOOLEAN_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_SEQ_BOOLEAN))

GtkType guppi_seq_boolean_get_type(void);

GuppiData* guppi_seq_boolean_new(void);
GuppiData* guppi_seq_boolean_new_aligned(const GuppiSeq*);

gboolean guppi_seq_boolean_get(const GuppiSeqBoolean*, gint);
void guppi_seq_boolean_set(GuppiSeqBoolean*, gint, gboolean);
void guppi_seq_boolean_set_all(GuppiSeqBoolean*, gboolean);
void guppi_seq_boolean_clear(GuppiSeqBoolean*);

void guppi_seq_boolean_prepend(GuppiSeqBoolean*, gboolean);
void guppi_seq_boolean_prepend_many(GuppiSeqBoolean*, gboolean, gsize);

void guppi_seq_boolean_append(GuppiSeqBoolean*, gboolean);
void guppi_seq_boolean_append_many(GuppiSeqBoolean*, gboolean, gsize);

void guppi_seq_boolean_insert(GuppiSeqBoolean*, gint i, gboolean);
void guppi_seq_boolean_insert_many(GuppiSeqBoolean*, gint i, gboolean, gsize);

void guppi_seq_boolean_bitwise_and(GuppiSeqBoolean*, const GuppiSeqBoolean*);
void guppi_seq_boolean_bitwise_or(GuppiSeqBoolean*, const GuppiSeqBoolean*);
void guppi_seq_boolean_bitwise_xor(GuppiSeqBoolean*, const GuppiSeqBoolean*);
void guppi_seq_boolean_bitwise_not(GuppiSeqBoolean*);

gint guppi_seq_boolean_first_true(const GuppiSeqBoolean*);
gint guppi_seq_boolean_next_true(const GuppiSeqBoolean*, gint);

gsize guppi_seq_boolean_true_count(const GuppiSeqBoolean*);



#endif /* _INC_GUPPI_SEQ_BOOLEAN_H */

/* $Id: guppi-seq-boolean.h,v 1.1 2000/02/09 21:04:56 trow Exp $ */

