/* This is -*- C -*- */
/* $Id: guppi-slinreg-state.c,v 1.2 2000/04/11 02:48:53 trow Exp $ */

/*
 * guppi-slinreg-state.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-slinreg-state.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_slinreg_state_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_slinreg_state_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_slinreg_state_destroy(GtkObject* obj)
{
  GuppiSlinregState* gss = GUPPI_SLINREG_STATE(obj);

  if (parent_class->destroy)
    parent_class->destroy(obj);

  gtk_object_unref(GTK_OBJECT(gss->slr));
  gss->slr = NULL;
}

static void
guppi_slinreg_state_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static gboolean
set_x_data(GuppiItemState* item, GuppiData* data)
{
  GuppiSlinregState* ss = GUPPI_SLINREG_STATE(ss);
  GuppiSeqScalar* sc = GUPPI_SEQ_SCALAR0(data);

  g_return_val_if_fail(ss != NULL, FALSE);

  if (ss->slr->x_data == sc)
    return FALSE;

  guppi_simple_linreg_set_x_data(ss->slr, sc);

  return TRUE;
}

static GuppiData*
get_x_data(GuppiItemState* item)
{
  GuppiSlinregState* ss = GUPPI_SLINREG_STATE(ss);
  return ss && ss->slr ? GUPPI_DATA0(ss->slr->x_data) : NULL;
}

static gboolean
set_y_data(GuppiItemState* item, GuppiData* data)
{
  GuppiSlinregState* ss = GUPPI_SLINREG_STATE(ss);
  GuppiSeqScalar* sc = GUPPI_SEQ_SCALAR0(data);

  g_return_val_if_fail(ss != NULL, FALSE);

  if (ss->slr->y_data == sc)
    return FALSE;

  guppi_simple_linreg_set_y_data(ss->slr, sc);

  return TRUE;
}

static GuppiData*
get_y_data(GuppiItemState* item)
{
  GuppiSlinregState* ss = GUPPI_SLINREG_STATE(ss);
  return ss && ss->slr ? GUPPI_DATA0(ss->slr->y_data) : NULL;
}

static void
guppi_slinreg_state_class_init(GuppiSlinregStateClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;
  GuppiItemStateClass* is_class = GUPPI_ITEM_STATE_CLASS(klass);

  parent_class = gtk_type_class(GUPPI_TYPE_ITEM_STATE);

  object_class->get_arg = guppi_slinreg_state_get_arg;
  object_class->set_arg = guppi_slinreg_state_set_arg;
  object_class->destroy = guppi_slinreg_state_destroy;
  object_class->finalize = guppi_slinreg_state_finalize;
  
  is_class->set_x_data = set_x_data;
  is_class->get_x_data = get_x_data;

  is_class->set_y_data = set_y_data;
  is_class->get_y_data = get_y_data;

}

static void
guppi_slinreg_state_init(GuppiSlinregState* obj)
{
  obj->slr = guppi_simple_linreg_new();
  obj->line_width = 3.5;
  obj->line_color = 0xff00ff8f;

  obj->show_label = TRUE;
  obj->label_size = 12;
  obj->label_color = 0x000000ff;
}

GtkType
guppi_slinreg_state_get_type(void)
{
  static GtkType guppi_slinreg_state_type = 0;
  if (!guppi_slinreg_state_type) {
    static const GtkTypeInfo guppi_slinreg_state_info = {
      "GuppiSlinregState",
      sizeof(GuppiSlinregState),
      sizeof(GuppiSlinregStateClass),
      (GtkClassInitFunc)guppi_slinreg_state_class_init,
      (GtkObjectInitFunc)guppi_slinreg_state_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_slinreg_state_type = gtk_type_unique(GUPPI_TYPE_ITEM_STATE, &guppi_slinreg_state_info);
  }
  return guppi_slinreg_state_type;
}

GuppiSlinregState*
guppi_slinreg_state_new(void)
{
  return GUPPI_SLINREG_STATE(gtk_type_new(guppi_slinreg_state_get_type()));
}



/* $Id: guppi-slinreg-state.c,v 1.2 2000/04/11 02:48:53 trow Exp $ */
