/* This is -*- C -*- */
/* $Id: guppi-scatter-marker-menu.c,v 1.2 2000/04/13 19:45:17 trow Exp $ */

/*
 * guppi-scatter-marker-menu.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-scatter-marker-menu.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

enum {
  SELECTED_MARKER,
  LAST_SIGNAL
};
static guint gsmm_signals[LAST_SIGNAL] = { 0 };

static void
guppi_scatter_marker_menu_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_scatter_marker_menu_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_scatter_marker_menu_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_scatter_marker_menu_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_scatter_marker_menu_class_init(GuppiScatterMarkerMenuClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OPTION_MENU);

  gsmm_signals[SELECTED_MARKER] =
    gtk_signal_new("selected_marker",
		   GTK_RUN_FIRST,
		   object_class->type,
		   GTK_SIGNAL_OFFSET(GuppiScatterMarkerMenuClass,
				     selected_marker),
		   gtk_marshal_NONE__INT,
		   GTK_TYPE_NONE, 1,
		   GTK_TYPE_INT);

  gtk_object_class_add_signals(object_class, gsmm_signals, LAST_SIGNAL);

  object_class->get_arg = guppi_scatter_marker_menu_get_arg;
  object_class->set_arg = guppi_scatter_marker_menu_set_arg;
  object_class->destroy = guppi_scatter_marker_menu_destroy;
  object_class->finalize = guppi_scatter_marker_menu_finalize;

}

static void
guppi_scatter_marker_menu_init(GuppiScatterMarkerMenu* obj)
{

}

GtkType
guppi_scatter_marker_menu_get_type(void)
{
  static GtkType guppi_scatter_marker_menu_type = 0;
  if (!guppi_scatter_marker_menu_type) {
    static const GtkTypeInfo guppi_scatter_marker_menu_info = {
      "GuppiScatterMarkerMenu",
      sizeof(GuppiScatterMarkerMenu),
      sizeof(GuppiScatterMarkerMenuClass),
      (GtkClassInitFunc)guppi_scatter_marker_menu_class_init,
      (GtkObjectInitFunc)guppi_scatter_marker_menu_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_scatter_marker_menu_type = gtk_type_unique(GTK_TYPE_OPTION_MENU, &guppi_scatter_marker_menu_info);
  }
  return guppi_scatter_marker_menu_type;
}

/*****************************************************************************/

static void
on_menu_item_activate(GtkWidget* item, gpointer gsmm_ptr)
{
  gpointer data = gtk_object_get_user_data(GTK_OBJECT(item));
  GuppiScatterMarker marker = (GuppiScatterMarker)GPOINTER_TO_INT(data);
  gtk_signal_emit(GTK_OBJECT(gsmm_ptr), gsmm_signals[SELECTED_MARKER], marker);
}

void
guppi_scatter_marker_menu_construct(GuppiScatterMarkerMenu* gsmm)
{
  GtkOptionMenu* option_menu;
  GtkMenu* menu;
  GtkWidget* mi;
  gint i;
  const gchar* name;
  GuppiScatterMarker marker;

  option_menu = GTK_OPTION_MENU(gsmm);
  g_return_if_fail(option_menu != NULL);

  menu = GTK_MENU(gtk_menu_new());

  for (i=0; i < (gint)SCATTER_MARKER_LAST_MARKER; ++i) {
    name = guppi_scatter_marker_info[i].name;
    marker = guppi_scatter_marker_info[i].marker;

    if (name != NULL && marker != SCATTER_MARKER_LAST_MARKER) {
      mi = gtk_menu_item_new_with_label(name);
      gtk_object_set_user_data(GTK_OBJECT(mi), GINT_TO_POINTER((gint)marker));
      gtk_signal_connect(GTK_OBJECT(mi),
			 "activate",
			 GTK_SIGNAL_FUNC(on_menu_item_activate),
			 gsmm);
      gtk_widget_show(mi);
      gtk_menu_append(menu, mi);
    }
  }
  
  gtk_option_menu_set_menu(option_menu, GTK_WIDGET(menu));
}

GtkWidget*
guppi_scatter_marker_menu_new(void)
{
  GtkWidget* w = 
    GTK_WIDGET(gtk_type_new(guppi_scatter_marker_menu_get_type()));

  guppi_scatter_marker_menu_construct(GUPPI_SCATTER_MARKER_MENU(w));

  return w;
  
}

GuppiScatterMarker
guppi_scatter_marker_menu_get_selection(GuppiScatterMarkerMenu* gsmm)
{
  GtkWidget* menu;
  gpointer data;

  g_return_val_if_fail(gsmm != NULL, SCATTER_MARKER_NONE);
  
  menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(gsmm));
  g_return_val_if_fail(menu != NULL, SCATTER_MARKER_NONE);

  menu = gtk_menu_get_active(GTK_MENU(menu));
  if (menu == NULL)
    return SCATTER_MARKER_NONE;

  data = gtk_object_get_user_data(GTK_OBJECT(menu));

  return (GuppiScatterMarker)GPOINTER_TO_INT(data);
}

void
guppi_scatter_marker_menu_set_selection(GuppiScatterMarkerMenu* gsmm,
					GuppiScatterMarker marker)
{
  GtkMenu* menu;
  GList* items;
  gint pick=0;
  gpointer data;

  g_return_if_fail(gsmm != NULL);
  g_return_if_fail(marker != SCATTER_MARKER_LAST_MARKER);

  menu = GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(gsmm)));
  g_return_if_fail(menu != NULL);

  items = GTK_MENU_SHELL(menu)->children;
  while (items != NULL) {
    if (items->data) {
      data = gtk_object_get_user_data(GTK_OBJECT(items->data));
      if (marker == (GuppiScatterMarker)GPOINTER_TO_INT(data)) {
	gtk_option_menu_set_history(GTK_OPTION_MENU(gsmm), pick);
	return;
      }
    }
    items = g_list_next(items);
    ++pick;
  }
}

GtkWidget*
guppi_scatter_marker_menu_glade_custom_func(gchar* name,
					    gchar* def_marker,
					    gchar* d1,
					    gint d2,
					    gint d3)
{
  GuppiScatterMarker marker = SCATTER_MARKER_NONE;
  GtkWidget* w;

  w = guppi_scatter_marker_menu_new();

  if (def_marker != NULL)
    marker = string2scatter_marker(def_marker);
  guppi_scatter_marker_menu_set_selection(GUPPI_SCATTER_MARKER_MENU(w),
					  marker);

  return w;
}



/* $Id: guppi-scatter-marker-menu.c,v 1.2 2000/04/13 19:45:17 trow Exp $ */
