/* $Id: jitter.c,v 1.2 2000/02/06 03:17:13 trow Exp $ */

/*
 * jitter.c
 *
 * Copyright (C) 1999 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org>
 * and Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <math.h>
#include "jitter.h"

void
jitter(guint seed, double size, gint i, double* xj, double* yj)
{
  static double pa1 = -1, pb1 = -1;
  static double pa2 = -1, pb2 = -1;

  double r, theta;

  if (pa1 < 0) {
    pa1 = sqrt(2), pb1 = sqrt(7);
    pa2 = sqrt(5), pb2 = sqrt(3);
  }

  i = seed * i + 0xdeadbeef;
  i = seed * i + 0x00abba00;
  i = seed * i + 0xbadd00d0;

  r = fmod(abs(i) * (i > 0 ? pa1 : pb1), 1);
  theta = fmod(abs(i) * (i > 0 ? pa2 : pb2), 1);

  *xj = r * cos(2*M_PI* theta);
  *yj = r * sin(2*M_PI* theta);
}


/* $Id: jitter.c,v 1.2 2000/02/06 03:17:13 trow Exp $ */
