/* This is -*- C -*- */
/* $Id: guppi-plot-toolkit.c,v 1.1 2000/02/28 04:55:18 trow Exp $ */

/*
 * guppi-plot-toolkit.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-plot-toolkit.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_plot_toolkit_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_plot_toolkit_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_plot_toolkit_destroy(GtkObject* obj)
{
  GuppiPlotToolkit* tk = GUPPI_PLOT_TOOLKIT(obj);
  gint i;

  if (parent_class->destroy)
    parent_class->destroy(obj);

  for (i=0; i<3; ++i) {
    if (tk->button_tool[i])
      gtk_object_unref(GTK_OBJECT(tk->button_tool[i]));
    if (tk->shift_button_tool[i])
      gtk_object_unref(GTK_OBJECT(tk->shift_button_tool[i]));
    if (tk->ctrl_button_tool[i])
      gtk_object_unref(GTK_OBJECT(tk->ctrl_button_tool[i]));
    if (tk->ctrl_shift_button_tool[i])
      gtk_object_unref(GTK_OBJECT(tk->ctrl_shift_button_tool[i]));
  }

}

static void
guppi_plot_toolkit_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_plot_toolkit_class_init(GuppiPlotToolkitClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GTK_TYPE_OBJECT);

  object_class->get_arg = guppi_plot_toolkit_get_arg;
  object_class->set_arg = guppi_plot_toolkit_set_arg;
  object_class->destroy = guppi_plot_toolkit_destroy;
  object_class->finalize = guppi_plot_toolkit_finalize;

}

static void
guppi_plot_toolkit_init(GuppiPlotToolkit* obj)
{

}

GtkType
guppi_plot_toolkit_get_type(void)
{
  static GtkType guppi_plot_toolkit_type = 0;
  if (!guppi_plot_toolkit_type) {
    static const GtkTypeInfo guppi_plot_toolkit_info = {
      "GuppiPlotToolkit",
      sizeof(GuppiPlotToolkit),
      sizeof(GuppiPlotToolkitClass),
      (GtkClassInitFunc)guppi_plot_toolkit_class_init,
      (GtkObjectInitFunc)guppi_plot_toolkit_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_plot_toolkit_type = gtk_type_unique(GTK_TYPE_OBJECT, &guppi_plot_toolkit_info);
  }
  return guppi_plot_toolkit_type;
}

GuppiPlotToolkit*
guppi_plot_toolkit_new(void)
{
  return GUPPI_PLOT_TOOLKIT(gtk_type_new(guppi_plot_toolkit_get_type()));
}

GuppiPlotTool*
guppi_plot_toolkit_get_button_tool(GuppiPlotToolkit* tk,
				   guint button, guint state)
{
  GuppiPlotTool** tools = NULL;

  g_return_val_if_fail(tk != NULL, NULL);
  g_return_val_if_fail(0 < button && button <= 3, NULL);

  if ((state & GDK_SHIFT_MASK) && (state & GDK_CONTROL_MASK))
    tools = tk->ctrl_shift_button_tool;
  else if (state & GDK_SHIFT_MASK) 
    tools = tk->shift_button_tool;
  else if (state & GDK_CONTROL_MASK)
    tools = tk->ctrl_button_tool;
  else
    tools = tk->button_tool;

  g_assert(tools != NULL);

  return tools[button-1];
}

void
guppi_plot_toolkit_set_button_tool(GuppiPlotToolkit* tk,
				   guint button, guint state,
				   GuppiPlotTool* tool)
{
  GuppiPlotTool** tools = NULL;

  g_return_if_fail(tk != NULL);
  g_return_if_fail(0 < button && button <= 3);

  if ((state & GDK_SHIFT_MASK) && (state & GDK_CONTROL_MASK))
    tools = tk->ctrl_shift_button_tool;
  else if (state & GDK_SHIFT_MASK) 
    tools = tk->shift_button_tool;
  else if (state & GDK_CONTROL_MASK)
    tools = tk->ctrl_button_tool;
  else
    tools = tk->button_tool;

  g_assert(tools != NULL);
  
  if (tools[button-1])
    gtk_object_unref(GTK_OBJECT(tools[button-1]));

  if (tool)
    gtk_object_ref(GTK_OBJECT(tool));
  tools[button-1] = tool;
}

static gboolean
guppi_plot_toolkit_check_button_motion(GuppiPlotToolkit* tk, guint b)
{
  GuppiPlotTool* tool;

  g_return_val_if_fail(tk != NULL, FALSE);
  g_return_val_if_fail(0 < b && b <= 3, FALSE);

  tool = guppi_plot_toolkit_get_button_tool(tk, b, 0);
  if (tool && tool->tracks_motion)
    return TRUE;

  tool = guppi_plot_toolkit_get_button_tool(tk, b, GDK_SHIFT_MASK);
  if (tool && tool->tracks_motion)
    return TRUE;

  tool = guppi_plot_toolkit_get_button_tool(tk, b, GDK_CONTROL_MASK);
  if (tool && tool->tracks_motion)
    return TRUE;

  tool = guppi_plot_toolkit_get_button_tool(tk, b, GDK_SHIFT_MASK | GDK_CONTROL_MASK);
  if (tool && tool->tracks_motion)
    return TRUE;

  return FALSE;
}

void
guppi_plot_toolkit_optimize_events(GuppiPlotToolkit* tk, GtkWidget* w)
{
  gint mask = gtk_widget_get_events(w);

  /* These will usually be on by default.  We set them again just to make
     sure. */
  mask |= GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK;

  /* Turn off all motion events.  They might get turned on later. */
  mask &= ~(GDK_POINTER_MOTION_MASK | GDK_BUTTON1_MOTION_MASK | GDK_BUTTON2_MOTION_MASK | GDK_BUTTON3_MOTION_MASK | GDK_BUTTON_MOTION_MASK);

  if (guppi_plot_toolkit_check_button_motion(tk, 1))
    mask |= GDK_BUTTON1_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK;

  if (guppi_plot_toolkit_check_button_motion(tk, 2))
    mask |= GDK_BUTTON2_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK;

  if (guppi_plot_toolkit_check_button_motion(tk, 3))
    mask |= GDK_BUTTON3_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK;
  
  gtk_widget_set_events(w, mask);
}


/* $Id: guppi-plot-toolkit.c,v 1.1 2000/02/28 04:55:18 trow Exp $ */
