/* This is -*- C -*- */
/* $Id: guppi-array-impl.c,v 1.1 2000/02/09 21:04:56 trow Exp $ */

/*
 * guppi-array-impl.c
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "guppi-array-impl.h"

static GtkObjectClass* parent_class = NULL;

enum {
  ARG_0
};

static void
guppi_array_impl_get_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_array_impl_set_arg(GtkObject* obj, GtkArg* arg, guint arg_id)
{
  switch (arg_id) {

  default:
    break;
  };
}

static void
guppi_array_impl_destroy(GtkObject* obj)
{
  if (parent_class->destroy)
    parent_class->destroy(obj);
}

static void
guppi_array_impl_finalize(GtkObject* obj)
{
  if (parent_class->finalize)
    parent_class->finalize(obj);
}

static void
guppi_array_impl_class_init(GuppiArrayImplClass* klass)
{
  GtkObjectClass* object_class = (GtkObjectClass*)klass;

  parent_class = gtk_type_class(GUPPI_TYPE_DATA_IMPL);

  GUPPI_DATA_IMPL_CLASS(object_class)->impl_name = "-* Array Impl *-";

  object_class->get_arg = guppi_array_impl_get_arg;
  object_class->set_arg = guppi_array_impl_set_arg;
  object_class->destroy = guppi_array_impl_destroy;
  object_class->finalize = guppi_array_impl_finalize;

}

static void
guppi_array_impl_init(GuppiArrayImpl* obj)
{

}

GtkType
guppi_array_impl_get_type(void)
{
  static GtkType guppi_array_impl_type = 0;
  if (!guppi_array_impl_type) {
    static const GtkTypeInfo guppi_array_impl_info = {
      "GuppiArrayImpl",
      sizeof(GuppiArrayImpl),
      sizeof(GuppiArrayImplClass),
      (GtkClassInitFunc)guppi_array_impl_class_init,
      (GtkObjectInitFunc)guppi_array_impl_init,
      NULL, NULL, (GtkClassInitFunc)NULL
    };
    guppi_array_impl_type = gtk_type_unique(GUPPI_TYPE_DATA_IMPL, &guppi_array_impl_info);
  }
  return guppi_array_impl_type;
}


/* $Id: guppi-array-impl.c,v 1.1 2000/02/09 21:04:56 trow Exp $ */
